/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.FilterDirectory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Lock;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.NoLockFactory;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.store.Store;

final class LocalShardSnapshot
implements Closeable {
    private final IndexShard shard;
    private final Store store;
    private final IndexCommit indexCommit;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LocalShardSnapshot(IndexShard shard) {
        this.shard = shard;
        this.store = shard.store();
        this.store.incRef();
        boolean success = false;
        try {
            this.indexCommit = shard.acquireIndexCommit(true);
            success = true;
        }
        finally {
            if (!success) {
                this.store.decRef();
            }
        }
    }

    Index getIndex() {
        return this.shard.indexSettings().getIndex();
    }

    Directory getSnapshotDirectory() {
        return new FilterDirectory(this.store.directory()){

            @Override
            public String[] listAll() throws IOException {
                Collection<String> fileNames = LocalShardSnapshot.this.indexCommit.getFileNames();
                String[] fileNameArray = fileNames.toArray(new String[fileNames.size()]);
                return fileNameArray;
            }

            @Override
            public void deleteFile(String name) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public void sync(Collection<String> names) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public void rename(String source, String dest) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public IndexOutput createOutput(String name, IOContext context) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
                throw new UnsupportedOperationException("this directory is read-only");
            }

            @Override
            public Lock obtainLock(String name) throws IOException {
                return NoLockFactory.INSTANCE.obtainLock(this.in, name);
            }

            @Override
            public void close() throws IOException {
                throw new UnsupportedOperationException("nobody should close this directory wrapper");
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.shard.releaseIndexCommit(this.indexCommit);
            }
            finally {
                this.store.decRef();
            }
        }
    }

    ImmutableOpenMap<String, MappingMetaData> getMappings() {
        return this.shard.indexSettings.getIndexMetaData().getMappings();
    }

    public String toString() {
        return "local_shard_snapshot:[" + this.shard.shardId() + " indexCommit: " + this.indexCommit + "]";
    }
}

