/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.mapper.BaseGeoPointFieldMapper;
import org.elasticsearch.index.query.QueryShardContext;

@Deprecated
public class LegacyIndexedGeoBoundingBoxQuery {
    public static Query create(GeoPoint topLeft, GeoPoint bottomRight, BaseGeoPointFieldMapper.LegacyGeoPointFieldType fieldType, QueryShardContext context) {
        if (!fieldType.isLatLonEnabled()) {
            throw new IllegalArgumentException("lat/lon is not enabled (indexed) for field [" + fieldType.name() + "], can't use indexed filter on it");
        }
        if (topLeft.lon() > bottomRight.lon()) {
            return LegacyIndexedGeoBoundingBoxQuery.westGeoBoundingBoxFilter(topLeft, bottomRight, fieldType, context);
        }
        return LegacyIndexedGeoBoundingBoxQuery.eastGeoBoundingBoxFilter(topLeft, bottomRight, fieldType, context);
    }

    private static Query westGeoBoundingBoxFilter(GeoPoint topLeft, GeoPoint bottomRight, BaseGeoPointFieldMapper.LegacyGeoPointFieldType fieldType, QueryShardContext context) {
        BooleanQuery.Builder filter = new BooleanQuery.Builder();
        filter.setMinimumNumberShouldMatch(1);
        filter.add(fieldType.lonFieldType().rangeQuery(null, bottomRight.lon(), true, true, context), BooleanClause.Occur.SHOULD);
        filter.add(fieldType.lonFieldType().rangeQuery(topLeft.lon(), null, true, true, context), BooleanClause.Occur.SHOULD);
        filter.add(fieldType.latFieldType().rangeQuery(bottomRight.lat(), topLeft.lat(), true, true, context), BooleanClause.Occur.MUST);
        return new ConstantScoreQuery(filter.build());
    }

    private static Query eastGeoBoundingBoxFilter(GeoPoint topLeft, GeoPoint bottomRight, BaseGeoPointFieldMapper.LegacyGeoPointFieldType fieldType, QueryShardContext context) {
        BooleanQuery.Builder filter = new BooleanQuery.Builder();
        filter.add(fieldType.lonFieldType().rangeQuery(topLeft.lon(), bottomRight.lon(), true, true, context), BooleanClause.Occur.MUST);
        filter.add(fieldType.latFieldType().rangeQuery(bottomRight.lat(), topLeft.lat(), true, true, context), BooleanClause.Occur.MUST);
        return new ConstantScoreQuery(filter.build());
    }
}

