/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.WorkingBulkByScrollTask;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractAsyncBulkIndexByScrollAction<Request extends AbstractBulkByScrollRequest<Request>>
extends AbstractAsyncBulkByScrollAction<Request> {
    protected final ScriptService scriptService;
    protected final ClusterState clusterState;
    private final BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> scriptApplier;

    public AbstractAsyncBulkIndexByScrollAction(WorkingBulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, Request mainRequest, ActionListener<BulkIndexByScrollResponse> listener, ScriptService scriptService, ClusterState clusterState) {
        super(task, logger, client, threadPool, mainRequest, listener);
        this.scriptService = scriptService;
        this.clusterState = clusterState;
        this.scriptApplier = Objects.requireNonNull(this.buildScriptApplier(), "script applier must not be null");
    }

    protected BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> buildScriptApplier() {
        return (request, searchHit) -> request;
    }

    @Override
    protected BulkRequest buildBulk(Iterable<? extends ScrollableHitSource.Hit> docs) {
        BulkRequest bulkRequest = new BulkRequest();
        for (ScrollableHitSource.Hit hit : docs) {
            RequestWrapper<?> request;
            if (!this.accept(hit) || (request = this.scriptApplier.apply(this.copyMetadata(this.buildRequest(hit), hit), hit)) == null) continue;
            bulkRequest.add((ActionRequest)request.self());
        }
        return bulkRequest;
    }

    protected boolean accept(ScrollableHitSource.Hit doc) {
        if (doc.getSource() == null) {
            throw new IllegalArgumentException("[" + doc.getIndex() + "][" + doc.getType() + "][" + doc.getId() + "] didn't store _source");
        }
        return true;
    }

    protected abstract RequestWrapper<?> buildRequest(ScrollableHitSource.Hit var1);

    protected RequestWrapper<?> copyMetadata(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
        Long ttl;
        request.setParent(doc.getParent());
        this.copyRouting(request, doc.getRouting());
        Long timestamp = doc.getTimestamp();
        if (timestamp != null) {
            request.setTimestamp(timestamp.toString());
        }
        if ((ttl = doc.getTTL()) != null) {
            request.setTtl(ttl);
        }
        return request;
    }

    protected void copyRouting(RequestWrapper<?> request, String routing) {
        request.setRouting(routing);
    }

    static RequestWrapper<IndexRequest> wrap(IndexRequest request) {
        return new IndexRequestWrapper(request);
    }

    static RequestWrapper<DeleteRequest> wrap(DeleteRequest request) {
        return new DeleteRequestWrapper(request);
    }

    public static enum OpType {
        NOOP("noop"),
        INDEX("index"),
        DELETE("delete");

        private final String id;

        private OpType(String id) {
            this.id = id;
        }

        public static OpType fromString(String opType) {
            String lowerOpType;
            switch (lowerOpType = opType.toLowerCase(Locale.ROOT)) {
                case "noop": {
                    return NOOP;
                }
                case "index": {
                    return INDEX;
                }
                case "delete": {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException("Operation type [" + lowerOpType + "] not allowed, only " + Arrays.toString((Object[])OpType.values()) + " are allowed");
        }

        public String toString() {
            return this.id.toLowerCase(Locale.ROOT);
        }
    }

    public abstract class ScriptApplier
    implements BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> {
        private final WorkingBulkByScrollTask task;
        private final ScriptService scriptService;
        private final Script script;
        private final Map<String, Object> params;
        private ExecutableScript executable;
        private Map<String, Object> context;

        public ScriptApplier(WorkingBulkByScrollTask task, ScriptService scriptService, Script script, Map<String, Object> params) {
            this.task = task;
            this.scriptService = scriptService;
            this.script = script;
            this.params = params;
        }

        @Override
        public RequestWrapper<?> apply(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
            OpType newOpType;
            if (this.script == null) {
                return request;
            }
            if (this.executable == null) {
                CompiledScript compiled = this.scriptService.compile(this.script, ScriptContext.Standard.UPDATE, Collections.emptyMap());
                this.executable = this.scriptService.executable(compiled, this.params);
            }
            if (this.context == null) {
                this.context = new HashMap<String, Object>();
            } else {
                this.context.clear();
            }
            this.context.put("_index", doc.getIndex());
            this.context.put("_type", doc.getType());
            this.context.put("_id", doc.getId());
            Long oldVersion = doc.getVersion();
            this.context.put("_version", oldVersion);
            String oldParent = doc.getParent();
            this.context.put("_parent", oldParent);
            String oldRouting = doc.getRouting();
            this.context.put("_routing", oldRouting);
            Long oldTimestamp = doc.getTimestamp();
            this.context.put("_timestamp", oldTimestamp);
            Long oldTTL = doc.getTTL();
            this.context.put("_ttl", oldTTL);
            this.context.put("_source", request.getSource());
            OpType oldOpType = OpType.INDEX;
            this.context.put("op", oldOpType.toString());
            this.executable.setNextVar("ctx", this.context);
            this.executable.run();
            Map resultCtx = (Map)this.executable.unwrap(this.context);
            String newOp = (String)resultCtx.remove("op");
            if (newOp == null) {
                throw new IllegalArgumentException("Script cleared operation type");
            }
            request.setSource((Map)resultCtx.remove("_source"));
            Object newValue = resultCtx.remove("_index");
            if (!doc.getIndex().equals(newValue)) {
                this.scriptChangedIndex(request, newValue);
            }
            newValue = resultCtx.remove("_type");
            if (!doc.getType().equals(newValue)) {
                this.scriptChangedType(request, newValue);
            }
            newValue = resultCtx.remove("_id");
            if (!doc.getId().equals(newValue)) {
                this.scriptChangedId(request, newValue);
            }
            if (!Objects.equals(oldVersion, newValue = resultCtx.remove("_version"))) {
                this.scriptChangedVersion(request, newValue);
            }
            if (!Objects.equals(oldParent, newValue = resultCtx.remove("_parent"))) {
                this.scriptChangedParent(request, newValue);
            }
            if (!Objects.equals(oldRouting, newValue = resultCtx.remove("_routing"))) {
                this.scriptChangedRouting(request, newValue);
            }
            if (!Objects.equals(oldTimestamp, newValue = resultCtx.remove("_timestamp"))) {
                this.scriptChangedTimestamp(request, newValue);
            }
            if (!Objects.equals(oldTTL, newValue = resultCtx.remove("_ttl"))) {
                this.scriptChangedTTL(request, newValue);
            }
            if ((newOpType = OpType.fromString(newOp)) != oldOpType) {
                return this.scriptChangedOpType(request, oldOpType, newOpType);
            }
            if (!resultCtx.isEmpty()) {
                throw new IllegalArgumentException("Invalid fields added to context [" + String.join((CharSequence)",", resultCtx.keySet()) + ']');
            }
            return request;
        }

        protected RequestWrapper<?> scriptChangedOpType(RequestWrapper<?> request, OpType oldOpType, OpType newOpType) {
            switch (newOpType) {
                case NOOP: {
                    this.task.countNoop();
                    return null;
                }
                case DELETE: {
                    RequestWrapper<DeleteRequest> delete = AbstractAsyncBulkIndexByScrollAction.wrap(new DeleteRequest(request.getIndex(), request.getType(), request.getId()));
                    delete.setVersion(request.getVersion());
                    delete.setVersionType(VersionType.INTERNAL);
                    delete.setParent(request.getParent());
                    delete.setRouting(request.getRouting());
                    return delete;
                }
            }
            throw new IllegalArgumentException("Unsupported operation type change from [" + (Object)((Object)oldOpType) + "] to [" + (Object)((Object)newOpType) + "]");
        }

        protected abstract void scriptChangedIndex(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedType(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedId(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedVersion(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedRouting(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedParent(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedTimestamp(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedTTL(RequestWrapper<?> var1, Object var2);
    }

    public static class DeleteRequestWrapper
    implements RequestWrapper<DeleteRequest> {
        private final DeleteRequest request;

        DeleteRequestWrapper(DeleteRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped DeleteRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setType(String type) {
            this.request.type(type);
        }

        @Override
        public String getType() {
            return this.request.type();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setParent(String parent) {
            this.request.parent(parent);
        }

        @Override
        public String getParent() {
            return this.request.parent();
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public void setTimestamp(String timestamp) {
            throw new UnsupportedOperationException("unable to set [timestamp] on action request [" + this.request.getClass() + "]");
        }

        @Override
        public void setTtl(Long ttl) {
            throw new UnsupportedOperationException("unable to set [ttl] on action request [" + this.request.getClass() + "]");
        }

        @Override
        public Map<String, Object> getSource() {
            throw new UnsupportedOperationException("unable to get source from action request [" + this.request.getClass() + "]");
        }

        @Override
        public void setSource(Map<String, Object> source) {
            throw new UnsupportedOperationException("unable to set [source] on action request [" + this.request.getClass() + "]");
        }

        @Override
        public DeleteRequest self() {
            return this.request;
        }
    }

    public static class IndexRequestWrapper
    implements RequestWrapper<IndexRequest> {
        private final IndexRequest request;

        IndexRequestWrapper(IndexRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped IndexRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setType(String type) {
            this.request.type(type);
        }

        @Override
        public String getType() {
            return this.request.type();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setParent(String parent) {
            this.request.parent(parent);
        }

        @Override
        public String getParent() {
            return this.request.parent();
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public void setTimestamp(String timestamp) {
            this.request.timestamp(timestamp);
        }

        @Override
        public void setTtl(Long ttl) {
            if (ttl == null) {
                this.request.ttl((TimeValue)null);
            } else {
                this.request.ttl(ttl);
            }
        }

        @Override
        public Map<String, Object> getSource() {
            return this.request.sourceAsMap();
        }

        @Override
        public void setSource(Map<String, Object> source) {
            this.request.source(source);
        }

        @Override
        public IndexRequest self() {
            return this.request;
        }
    }

    static interface RequestWrapper<Self extends ActionRequest> {
        public void setIndex(String var1);

        public String getIndex();

        public void setType(String var1);

        public String getType();

        public void setId(String var1);

        public String getId();

        public void setVersion(long var1);

        public long getVersion();

        public void setVersionType(VersionType var1);

        public void setParent(String var1);

        public String getParent();

        public void setRouting(String var1);

        public String getRouting();

        public void setTimestamp(String var1);

        public void setTtl(Long var1);

        public void setSource(Map<String, Object> var1);

        public Map<String, Object> getSource();

        public Self self();
    }
}

