/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BaseTermQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;

public class TermQueryBuilder
extends BaseTermQueryBuilder<TermQueryBuilder> {
    public static final String NAME = "term";
    private static final ParseField TERM_FIELD = new ParseField("term", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);

    public TermQueryBuilder(String fieldName, String value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, int value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, long value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, float value) {
        super(fieldName, Float.valueOf(value));
    }

    public TermQueryBuilder(String fieldName, double value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, boolean value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, Object value) {
        super(fieldName, value);
    }

    public TermQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public static Optional<TermQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String queryName = null;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                TermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, TERM_FIELD)) {
                        value = parser.objectBytes();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, VALUE_FIELD)) {
                        value = parser.objectBytes();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                        queryName = parser.text();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[term] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (token.isValue()) {
                TermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
                fieldName = currentFieldName;
                value = parser.objectBytes();
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            throw new ParsingException(parser.getTokenLocation(), "[term] query does not support array of values", new Object[0]);
        }
        TermQueryBuilder termQuery = new TermQueryBuilder(fieldName, value);
        termQuery.boost(boost);
        if (queryName != null) {
            termQuery.queryName(queryName);
        }
        return Optional.of(termQuery);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query query = null;
        MappedFieldType mapper = context.fieldMapper(this.fieldName);
        if (mapper != null) {
            query = mapper.termQuery(this.value, context);
        }
        if (query == null) {
            query = new TermQuery(new Term(this.fieldName, BytesRefs.toBytesRef(this.value)));
        }
        return query;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

