/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Accountables;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BitSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;

public abstract class GeoPointArrayLegacyAtomicFieldData
extends AbstractAtomicGeoPointFieldData {
    @Override
    public void close() {
    }

    public static class Single
    extends GeoPointArrayLegacyAtomicFieldData {
        private final DoubleArray lon;
        private final DoubleArray lat;
        private final BitSet set;

        public Single(DoubleArray lon, DoubleArray lat, BitSet set) {
            this.lon = lon;
            this.lat = lat;
            this.set = set;
        }

        @Override
        public long ramBytesUsed() {
            return 4L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed() + (this.set == null ? 0L : this.set.ramBytesUsed());
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("latitude", this.lat));
            resources.add(Accountables.namedAccountable("longitude", this.lon));
            if (this.set != null) {
                resources.add(Accountables.namedAccountable("missing bitset", this.set));
            }
            return Collections.unmodifiableList(resources);
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final GeoPoint point = new GeoPoint();
            GeoPointValues values = new GeoPointValues(){

                @Override
                public GeoPoint get(int docID) {
                    if (set == null || set.get(docID)) {
                        return point.reset(lat.get(docID), lon.get(docID));
                    }
                    return point.reset(Double.NaN, Double.NaN);
                }
            };
            return FieldData.singleton(values, (Bits)this.set);
        }
    }

    static class WithOrdinals
    extends GeoPointArrayLegacyAtomicFieldData {
        private final DoubleArray lon;
        private final DoubleArray lat;
        private final Ordinals ordinals;
        private final int maxDoc;

        public WithOrdinals(DoubleArray lon, DoubleArray lat, Ordinals ordinals, int maxDoc) {
            this.lon = lon;
            this.lat = lat;
            this.ordinals = ordinals;
            this.maxDoc = maxDoc;
        }

        @Override
        public long ramBytesUsed() {
            return 4L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed();
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("latitude", this.lat));
            resources.add(Accountables.namedAccountable("longitude", this.lon));
            return Collections.unmodifiableList(resources);
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final RandomAccessOrds ords = this.ordinals.ordinals();
            final SortedDocValues singleOrds = DocValues.unwrapSingleton(ords);
            if (singleOrds != null) {
                final GeoPoint point = new GeoPoint();
                GeoPointValues values = new GeoPointValues(){

                    @Override
                    public GeoPoint get(int docID) {
                        int ord = singleOrds.getOrd(docID);
                        if (ord >= 0) {
                            return point.reset(lat.get(ord), lon.get(ord));
                        }
                        return point.reset(Double.NaN, Double.NaN);
                    }
                };
                return FieldData.singleton(values, DocValues.docsWithValue(singleOrds, this.maxDoc));
            }
            final GeoPoint point = new GeoPoint();
            return new MultiGeoPointValues(){

                @Override
                public GeoPoint valueAt(int index) {
                    long ord = ords.ordAt(index);
                    if (ord >= 0L) {
                        return point.reset(lat.get(ord), lon.get(ord));
                    }
                    return point.reset(Double.NaN, Double.NaN);
                }

                @Override
                public void setDocument(int docId) {
                    ords.setDocument(docId);
                }

                @Override
                public int count() {
                    return ords.cardinality();
                }
            };
        }
    }
}

