/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzerProvider;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreBuiltCharFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenizerFactoryFactory;
import org.elasticsearch.index.analysis.StandardAnalyzerProvider;
import org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.analysis.PreBuiltAnalyzers;
import org.elasticsearch.indices.analysis.PreBuiltCharFilters;
import org.elasticsearch.indices.analysis.PreBuiltTokenFilters;
import org.elasticsearch.indices.analysis.PreBuiltTokenizers;

public final class AnalysisRegistry
implements Closeable {
    public static final String INDEX_ANALYSIS_CHAR_FILTER = "index.analysis.char_filter";
    public static final String INDEX_ANALYSIS_FILTER = "index.analysis.filter";
    public static final String INDEX_ANALYSIS_TOKENIZER = "index.analysis.tokenizer";
    private final PrebuiltAnalysis prebuiltAnalysis = new PrebuiltAnalysis();
    private final Map<String, Analyzer> cachedAnalyzer = new ConcurrentHashMap<String, Analyzer>();
    private final Environment environment;
    private final Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> charFilters;
    private final Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> tokenFilters;
    private final Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> tokenizers;
    private final Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<?>>> analyzers;

    public AnalysisRegistry(Environment environment, Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> charFilters, Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> tokenFilters, Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> tokenizers, Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<?>>> analyzers) {
        this.environment = environment;
        this.charFilters = Collections.unmodifiableMap(charFilters);
        this.tokenFilters = Collections.unmodifiableMap(tokenFilters);
        this.tokenizers = Collections.unmodifiableMap(tokenizers);
        this.analyzers = Collections.unmodifiableMap(analyzers);
    }

    public static Settings getSettingsFromIndexSettings(IndexSettings indexSettings, String groupName) {
        Settings settings = indexSettings.getSettings().getAsSettings(groupName);
        if (settings.isEmpty()) {
            settings = Settings.builder().put("index.version.created", indexSettings.getIndexVersionCreated()).build();
        }
        return settings;
    }

    public AnalysisModule.AnalysisProvider<TokenizerFactory> getTokenizerProvider(String tokenizer) {
        return this.tokenizers.getOrDefault(tokenizer, this.prebuiltAnalysis.getTokenizerFactory(tokenizer));
    }

    public AnalysisModule.AnalysisProvider<TokenFilterFactory> getTokenFilterProvider(String tokenFilter) {
        return this.tokenFilters.getOrDefault(tokenFilter, this.prebuiltAnalysis.getTokenFilterFactory(tokenFilter));
    }

    public AnalysisModule.AnalysisProvider<CharFilterFactory> getCharFilterProvider(String charFilter) {
        return this.charFilters.getOrDefault(charFilter, this.prebuiltAnalysis.getCharFilterFactory(charFilter));
    }

    public Analyzer getAnalyzer(String analyzer) throws IOException {
        AnalysisModule.AnalysisProvider<AnalyzerProvider<?>> analyzerProvider = this.prebuiltAnalysis.getAnalyzerProvider(analyzer);
        if (analyzerProvider == null) {
            AnalysisModule.AnalysisProvider<AnalyzerProvider<?>> provider = this.analyzers.get(analyzer);
            return provider == null ? null : this.cachedAnalyzer.computeIfAbsent(analyzer, key -> {
                try {
                    return ((AnalyzerProvider)provider.get(this.environment, (String)key)).get();
                }
                catch (IOException ex) {
                    throw new ElasticsearchException("failed to load analyzer for name " + key, (Throwable)ex, new Object[0]);
                }
            });
        }
        return analyzerProvider.get(this.environment, analyzer).get();
    }

    @Override
    public void close() throws IOException {
        try {
            this.prebuiltAnalysis.close();
        }
        finally {
            IOUtils.close(this.cachedAnalyzer.values());
        }
    }

    public IndexAnalyzers build(IndexSettings indexSettings) throws IOException {
        Map<String, CharFilterFactory> charFilterFactories = this.buildCharFilterFactories(indexSettings);
        Map<String, TokenizerFactory> tokenizerFactories = this.buildTokenizerFactories(indexSettings);
        Map<String, TokenFilterFactory> tokenFilterFactories = this.buildTokenFilterFactories(indexSettings);
        Map<String, AnalyzerProvider<?>> analyzierFactories = this.buildAnalyzerFactories(indexSettings);
        return this.build(indexSettings, analyzierFactories, tokenizerFactories, charFilterFactories, tokenFilterFactories);
    }

    public Map<String, TokenFilterFactory> buildTokenFilterFactories(IndexSettings indexSettings) throws IOException {
        Map<String, Settings> tokenFiltersSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_FILTER);
        HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> tokenFilters = new HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>(this.tokenFilters);
        tokenFilters.put("synonym", AnalysisRegistry.requriesAnalysisSettings((is, env, name, settings) -> new SynonymTokenFilterFactory(is, env, this, name, settings)));
        return this.buildMapping(false, "tokenfilter", indexSettings, tokenFiltersSettings, Collections.unmodifiableMap(tokenFilters), this.prebuiltAnalysis.tokenFilterFactories);
    }

    public Map<String, TokenizerFactory> buildTokenizerFactories(IndexSettings indexSettings) throws IOException {
        Map<String, Settings> tokenizersSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_TOKENIZER);
        return this.buildMapping(false, "tokenizer", indexSettings, tokenizersSettings, this.tokenizers, this.prebuiltAnalysis.tokenizerFactories);
    }

    public Map<String, CharFilterFactory> buildCharFilterFactories(IndexSettings indexSettings) throws IOException {
        Map<String, Settings> charFiltersSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_CHAR_FILTER);
        return this.buildMapping(false, "charfilter", indexSettings, charFiltersSettings, this.charFilters, this.prebuiltAnalysis.charFilterFactories);
    }

    public Map<String, AnalyzerProvider<?>> buildAnalyzerFactories(IndexSettings indexSettings) throws IOException {
        Map<String, Settings> analyzersSettings = indexSettings.getSettings().getGroups("index.analysis.analyzer");
        return this.buildMapping(true, "analyzer", indexSettings, analyzersSettings, this.analyzers, this.prebuiltAnalysis.analyzerProviderFactories);
    }

    public AnalysisModule.AnalysisProvider<TokenizerFactory> getTokenizerProvider(String tokenizer, IndexSettings indexSettings) {
        Map<String, Settings> tokenizerSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_TOKENIZER);
        if (tokenizerSettings.containsKey(tokenizer)) {
            Settings currentSettings = tokenizerSettings.get(tokenizer);
            return this.getAnalysisProvider("tokenizer", this.tokenizers, tokenizer, currentSettings.get("type"));
        }
        return this.getTokenizerProvider(tokenizer);
    }

    public AnalysisModule.AnalysisProvider<TokenFilterFactory> getTokenFilterProvider(String tokenFilter, IndexSettings indexSettings) {
        Map<String, Settings> tokenFilterSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_FILTER);
        if (tokenFilterSettings.containsKey(tokenFilter)) {
            Settings currentSettings = tokenFilterSettings.get(tokenFilter);
            String typeName = currentSettings.get("type");
            if ("synonym".equals(typeName)) {
                return AnalysisRegistry.requriesAnalysisSettings((is, env, name, settings) -> new SynonymTokenFilterFactory(is, env, this, name, settings));
            }
            return this.getAnalysisProvider("tokenfilter", this.tokenFilters, tokenFilter, typeName);
        }
        return this.getTokenFilterProvider(tokenFilter);
    }

    public AnalysisModule.AnalysisProvider<CharFilterFactory> getCharFilterProvider(String charFilter, IndexSettings indexSettings) {
        Map<String, Settings> tokenFilterSettings = indexSettings.getSettings().getGroups(INDEX_ANALYSIS_CHAR_FILTER);
        if (tokenFilterSettings.containsKey(charFilter)) {
            Settings currentSettings = tokenFilterSettings.get(charFilter);
            return this.getAnalysisProvider("charfilter", this.charFilters, charFilter, currentSettings.get("type"));
        }
        return this.getCharFilterProvider(charFilter);
    }

    private static <T> AnalysisModule.AnalysisProvider<T> requriesAnalysisSettings(final AnalysisModule.AnalysisProvider<T> provider) {
        return new AnalysisModule.AnalysisProvider<T>(){

            @Override
            public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
                return provider.get(indexSettings, environment, name, settings);
            }

            @Override
            public boolean requiresAnalysisSettings() {
                return true;
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> Map<String, T> buildMapping(boolean analyzer, String toBuild, IndexSettings settings, Map<String, Settings> settingsMap, Map<String, AnalysisModule.AnalysisProvider<T>> providerMap, Map<String, AnalysisModule.AnalysisProvider<T>> defaultInstance) throws IOException {
        AnalysisModule.AnalysisProvider provider;
        String name;
        Settings defaultSettings = Settings.builder().put("index.version.created", settings.getIndexVersionCreated()).build();
        HashMap factories = new HashMap();
        for (Map.Entry<String, Settings> entry : settingsMap.entrySet()) {
            name = entry.getKey();
            Settings currentSettings = entry.getValue();
            String typeName = currentSettings.get("type");
            if (analyzer) {
                void var14_22;
                if (typeName == null) {
                    if (currentSettings.get("tokenizer") == null) throw new IllegalArgumentException(toBuild + " [" + name + "] must specify either an analyzer type, or a tokenizer");
                    CustomAnalyzerProvider customAnalyzerProvider = new CustomAnalyzerProvider(settings, name, currentSettings);
                } else if (typeName.equals("custom")) {
                    CustomAnalyzerProvider customAnalyzerProvider = new CustomAnalyzerProvider(settings, name, currentSettings);
                } else {
                    AnalysisModule.AnalysisProvider<T> type = providerMap.get(typeName);
                    if (type == null) {
                        throw new IllegalArgumentException("Unknown " + toBuild + " type [" + typeName + "] for [" + name + "]");
                    }
                    T t = type.get(settings, this.environment, name, currentSettings);
                }
                factories.put(name, var14_22);
                continue;
            }
            AnalysisModule.AnalysisProvider<T> analysisProvider = this.getAnalysisProvider(toBuild, providerMap, name, typeName);
            T factory = analysisProvider.get(settings, this.environment, name, currentSettings);
            factories.put(name, factory);
        }
        for (Map.Entry<String, Object> entry : providerMap.entrySet()) {
            void var14_27;
            name = entry.getKey();
            provider = (AnalysisModule.AnalysisProvider)entry.getValue();
            if (settingsMap.containsKey(name) || provider.requiresAnalysisSettings()) continue;
            AnalysisModule.AnalysisProvider<T> defaultProvider = defaultInstance.get(name);
            if (defaultProvider == null) {
                Object t = provider.get(settings, this.environment, name, defaultSettings);
            } else {
                T t = defaultProvider.get(settings, this.environment, name, defaultSettings);
            }
            factories.put(name, var14_27);
        }
        for (Map.Entry<String, Object> entry : defaultInstance.entrySet()) {
            name = entry.getKey();
            provider = (AnalysisModule.AnalysisProvider)entry.getValue();
            if (factories.containsKey(name)) continue;
            Object instance = provider.get(settings, this.environment, name, defaultSettings);
            if (factories.containsKey(name)) continue;
            factories.put(name, instance);
        }
        return factories;
    }

    private <T> AnalysisModule.AnalysisProvider<T> getAnalysisProvider(String toBuild, Map<String, AnalysisModule.AnalysisProvider<T>> providerMap, String name, String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(toBuild + " [" + name + "] must specify either an analyzer type, or a tokenizer");
        }
        AnalysisModule.AnalysisProvider<T> type = providerMap.get(typeName);
        if (type == null) {
            throw new IllegalArgumentException("Unknown " + toBuild + " type [" + typeName + "] for [" + name + "]");
        }
        return type;
    }

    public IndexAnalyzers build(IndexSettings indexSettings, Map<String, AnalyzerProvider<?>> analyzerProviders, Map<String, TokenizerFactory> tokenizerFactoryFactories, Map<String, CharFilterFactory> charFilterFactoryFactories, Map<String, TokenFilterFactory> tokenFilterFactoryFactories) {
        NamedAnalyzer defaultAnalyzer;
        Index index = indexSettings.getIndex();
        analyzerProviders = new HashMap(analyzerProviders);
        Logger logger = Loggers.getLogger(this.getClass(), indexSettings.getSettings(), new String[0]);
        DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
        HashMap<String, NamedAnalyzer> analyzerAliases = new HashMap<String, NamedAnalyzer>();
        HashMap<String, NamedAnalyzer> analyzers = new HashMap<String, NamedAnalyzer>();
        for (Map.Entry<String, AnalyzerProvider<?>> entry : analyzerProviders.entrySet()) {
            this.processAnalyzerFactory(deprecationLogger, indexSettings, entry.getKey(), entry.getValue(), analyzerAliases, analyzers, tokenFilterFactoryFactories, charFilterFactoryFactories, tokenizerFactoryFactories);
        }
        for (Map.Entry<String, AnalyzerProvider<Object>> entry : analyzerAliases.entrySet()) {
            String key = entry.getKey();
            if (analyzers.containsKey(key) && !("default".equals(key) || "default_search".equals(key) || "default_search_quoted".equals(key))) {
                throw new IllegalStateException("already registered analyzer with name: " + key);
            }
            NamedAnalyzer configured = (NamedAnalyzer)((Object)entry.getValue());
            analyzers.put(key, configured);
        }
        if (!analyzers.containsKey("default")) {
            this.processAnalyzerFactory(deprecationLogger, indexSettings, "default", new StandardAnalyzerProvider(indexSettings, null, "default", Settings.Builder.EMPTY_SETTINGS), analyzerAliases, analyzers, tokenFilterFactoryFactories, charFilterFactoryFactories, tokenizerFactoryFactories);
        }
        if (!analyzers.containsKey("default_search")) {
            analyzers.put("default_search", (NamedAnalyzer)analyzers.get("default"));
        }
        if (!analyzers.containsKey("default_search_quoted")) {
            analyzers.put("default_search_quoted", (NamedAnalyzer)analyzers.get("default_search"));
        }
        if ((defaultAnalyzer = (NamedAnalyzer)analyzers.get("default")) == null) {
            throw new IllegalArgumentException("no default analyzer configured");
        }
        if (analyzers.containsKey("default_index")) {
            Version version = indexSettings.getIndexVersionCreated();
            if (version.onOrAfter(Version.V_5_0_0_alpha1)) {
                throw new IllegalArgumentException("setting [index.analysis.analyzer.default_index] is not supported anymore, use [index.analysis.analyzer.default] instead for index [" + index.getName() + "]");
            }
            deprecationLogger.deprecated("setting [index.analysis.analyzer.default_index] is deprecated, use [index.analysis.analyzer.default] instead for index [{}]", index.getName());
        }
        NamedAnalyzer namedAnalyzer = analyzers.containsKey("default_index") ? (NamedAnalyzer)analyzers.get("default_index") : defaultAnalyzer;
        NamedAnalyzer defaultSearchAnalyzer = analyzers.containsKey("default_search") ? (NamedAnalyzer)analyzers.get("default_search") : defaultAnalyzer;
        NamedAnalyzer defaultSearchQuoteAnalyzer = analyzers.containsKey("default_search_quote") ? (NamedAnalyzer)analyzers.get("default_search_quote") : defaultSearchAnalyzer;
        for (Map.Entry analyzer : analyzers.entrySet()) {
            if (!((String)analyzer.getKey()).startsWith("_")) continue;
            throw new IllegalArgumentException("analyzer name must not start with '_'. got \"" + (String)analyzer.getKey() + "\"");
        }
        return new IndexAnalyzers(indexSettings, namedAnalyzer, defaultSearchAnalyzer, defaultSearchQuoteAnalyzer, Collections.unmodifiableMap(analyzers));
    }

    private void processAnalyzerFactory(DeprecationLogger deprecationLogger, IndexSettings indexSettings, String name, AnalyzerProvider<?> analyzerFactory, Map<String, NamedAnalyzer> analyzerAliases, Map<String, NamedAnalyzer> analyzers, Map<String, TokenFilterFactory> tokenFilters, Map<String, CharFilterFactory> charFilters, Map<String, TokenizerFactory> tokenizers) {
        NamedAnalyzer analyzer;
        Object analyzerF;
        int overridePositionIncrementGap = 100;
        if (analyzerFactory instanceof CustomAnalyzerProvider) {
            ((CustomAnalyzerProvider)analyzerFactory).build(tokenizers, charFilters, tokenFilters);
            overridePositionIncrementGap = Integer.MIN_VALUE;
        }
        if ((analyzerF = analyzerFactory.get()) == null) {
            throw new IllegalArgumentException("analyzer [" + analyzerFactory.name() + "] created null analyzer");
        }
        if (analyzerF instanceof NamedAnalyzer) {
            analyzer = (NamedAnalyzer)analyzerF;
            if (overridePositionIncrementGap >= 0 && analyzer.getPositionIncrementGap(analyzer.name()) != overridePositionIncrementGap) {
                analyzer = new NamedAnalyzer(analyzer, overridePositionIncrementGap);
            }
        } else {
            analyzer = new NamedAnalyzer(name, analyzerFactory.scope(), (Analyzer)analyzerF, overridePositionIncrementGap);
        }
        if (analyzers.containsKey(name)) {
            throw new IllegalStateException("already registered analyzer with name: " + name);
        }
        analyzers.put(name, analyzer);
        String analyzerAliasKey = "index.analysis.analyzer." + analyzerFactory.name() + ".alias";
        if (indexSettings.getSettings().get(analyzerAliasKey) != null) {
            if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_5_0_0_beta1)) {
                throw new IllegalArgumentException("setting [" + analyzerAliasKey + "] is not supported");
            }
            deprecationLogger.deprecated("setting [{}] is only allowed on index [{}] because it was created before 5.x; analyzer aliases can no longer be created on new indices.", analyzerAliasKey, indexSettings.getIndex().getName());
            HashSet<String> aliases = Sets.newHashSet(indexSettings.getSettings().getAsArray(analyzerAliasKey));
            for (String alias : aliases) {
                if (analyzerAliases.putIfAbsent(alias, analyzer) == null) continue;
                throw new IllegalStateException("alias [" + alias + "] is already used by [" + analyzerAliases.get(alias).name() + "]");
            }
        }
    }

    private static class PrebuiltAnalysis
    implements Closeable {
        final Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<?>>> analyzerProviderFactories;
        final Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> tokenizerFactories;
        final Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> tokenFilterFactories;
        final Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> charFilterFactories;

        private PrebuiltAnalysis() {
            String name;
            HashMap<String, PreBuiltAnalyzerProviderFactory> analyzerProviderFactories = new HashMap<String, PreBuiltAnalyzerProviderFactory>();
            HashMap<String, PreBuiltTokenizerFactoryFactory> tokenizerFactories = new HashMap<String, PreBuiltTokenizerFactoryFactory>();
            HashMap<String, PreBuiltTokenFilterFactoryFactory> tokenFilterFactories = new HashMap<String, PreBuiltTokenFilterFactoryFactory>();
            HashMap<String, PreBuiltCharFilterFactoryFactory> charFilterFactories = new HashMap<String, PreBuiltCharFilterFactoryFactory>();
            for (PreBuiltAnalyzers preBuiltAnalyzers : PreBuiltAnalyzers.values()) {
                name = preBuiltAnalyzers.name().toLowerCase(Locale.ROOT);
                analyzerProviderFactories.put(name, new PreBuiltAnalyzerProviderFactory(name, AnalyzerScope.INDICES, preBuiltAnalyzers.getAnalyzer(Version.CURRENT)));
            }
            for (Enum enum_ : PreBuiltTokenizers.values()) {
                name = enum_.name().toLowerCase(Locale.ROOT);
                tokenizerFactories.put(name, new PreBuiltTokenizerFactoryFactory(((PreBuiltTokenizers)enum_).getTokenizerFactory(Version.CURRENT)));
            }
            tokenizerFactories.put("nGram", new PreBuiltTokenizerFactoryFactory(PreBuiltTokenizers.NGRAM.getTokenizerFactory(Version.CURRENT)));
            tokenizerFactories.put("edgeNGram", new PreBuiltTokenizerFactoryFactory(PreBuiltTokenizers.EDGE_NGRAM.getTokenizerFactory(Version.CURRENT)));
            tokenizerFactories.put("PathHierarchy", new PreBuiltTokenizerFactoryFactory(PreBuiltTokenizers.PATH_HIERARCHY.getTokenizerFactory(Version.CURRENT)));
            for (Enum enum_ : PreBuiltTokenFilters.values()) {
                name = enum_.name().toLowerCase(Locale.ROOT);
                tokenFilterFactories.put(name, new PreBuiltTokenFilterFactoryFactory(((PreBuiltTokenFilters)enum_).getTokenFilterFactory(Version.CURRENT)));
            }
            tokenFilterFactories.put("nGram", new PreBuiltTokenFilterFactoryFactory(PreBuiltTokenFilters.NGRAM.getTokenFilterFactory(Version.CURRENT)));
            tokenFilterFactories.put("edgeNGram", new PreBuiltTokenFilterFactoryFactory(PreBuiltTokenFilters.EDGE_NGRAM.getTokenFilterFactory(Version.CURRENT)));
            for (Enum enum_ : PreBuiltCharFilters.values()) {
                name = enum_.name().toLowerCase(Locale.ROOT);
                charFilterFactories.put(name, new PreBuiltCharFilterFactoryFactory(((PreBuiltCharFilters)enum_).getCharFilterFactory(Version.CURRENT)));
            }
            charFilterFactories.put("htmlStrip", new PreBuiltCharFilterFactoryFactory(PreBuiltCharFilters.HTML_STRIP.getCharFilterFactory(Version.CURRENT)));
            this.analyzerProviderFactories = Collections.unmodifiableMap(analyzerProviderFactories);
            this.charFilterFactories = Collections.unmodifiableMap(charFilterFactories);
            this.tokenFilterFactories = Collections.unmodifiableMap(tokenFilterFactories);
            this.tokenizerFactories = Collections.unmodifiableMap(tokenizerFactories);
        }

        public AnalysisModule.AnalysisProvider<CharFilterFactory> getCharFilterFactory(String name) {
            return this.charFilterFactories.get(name);
        }

        public AnalysisModule.AnalysisProvider<TokenFilterFactory> getTokenFilterFactory(String name) {
            return this.tokenFilterFactories.get(name);
        }

        public AnalysisModule.AnalysisProvider<TokenizerFactory> getTokenizerFactory(String name) {
            return this.tokenizerFactories.get(name);
        }

        public AnalysisModule.AnalysisProvider<AnalyzerProvider<?>> getAnalyzerProvider(String name) {
            return this.analyzerProviderFactories.get(name);
        }

        Analyzer analyzer(String name) {
            PreBuiltAnalyzerProviderFactory analyzerProviderFactory = (PreBuiltAnalyzerProviderFactory)this.analyzerProviderFactories.get(name);
            if (analyzerProviderFactory == null) {
                return null;
            }
            return analyzerProviderFactory.analyzer();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.analyzerProviderFactories.values().stream().map(a -> ((PreBuiltAnalyzerProviderFactory)a).analyzer()).collect(Collectors.toList()));
        }
    }
}

