/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MergePolicy;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NoMergePolicy;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TieredMergePolicy;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.IndexSettings;

public final class MergePolicyConfig {
    private final TieredMergePolicy mergePolicy = new TieredMergePolicy();
    private final Logger logger;
    private final boolean mergesEnabled;
    public static final double DEFAULT_EXPUNGE_DELETES_ALLOWED = 10.0;
    public static final ByteSizeValue DEFAULT_FLOOR_SEGMENT = new ByteSizeValue(2L, ByteSizeUnit.MB);
    public static final int DEFAULT_MAX_MERGE_AT_ONCE = 10;
    public static final int DEFAULT_MAX_MERGE_AT_ONCE_EXPLICIT = 30;
    public static final ByteSizeValue DEFAULT_MAX_MERGED_SEGMENT = new ByteSizeValue(5L, ByteSizeUnit.GB);
    public static final double DEFAULT_SEGMENTS_PER_TIER = 10.0;
    public static final double DEFAULT_RECLAIM_DELETES_WEIGHT = 2.0;
    public static final Setting<Double> INDEX_COMPOUND_FORMAT_SETTING = new Setting<Double>("index.compound_format", Double.toString(0.1), MergePolicyConfig::parseNoCFSRatio, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING = Setting.doubleSetting("index.merge.policy.expunge_deletes_allowed", 10.0, 0.0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING = Setting.byteSizeSetting("index.merge.policy.floor_segment", DEFAULT_FLOOR_SEGMENT, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING = Setting.intSetting("index.merge.policy.max_merge_at_once", 10, 2, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT_SETTING = Setting.intSetting("index.merge.policy.max_merge_at_once_explicit", 30, 2, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING = Setting.byteSizeSetting("index.merge.policy.max_merged_segment", DEFAULT_MAX_MERGED_SEGMENT, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING = Setting.doubleSetting("index.merge.policy.segments_per_tier", 10.0, 2.0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT_SETTING = Setting.doubleSetting("index.merge.policy.reclaim_deletes_weight", 2.0, 0.0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String INDEX_MERGE_ENABLED = "index.merge.enabled";

    MergePolicyConfig(Logger logger, IndexSettings indexSettings) {
        this.logger = logger;
        double forceMergeDeletesPctAllowed = indexSettings.getValue(INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING);
        ByteSizeValue floorSegment = indexSettings.getValue(INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING);
        int maxMergeAtOnce = indexSettings.getValue(INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING);
        int maxMergeAtOnceExplicit = indexSettings.getValue(INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT_SETTING);
        ByteSizeValue maxMergedSegment = indexSettings.getValue(INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING);
        double segmentsPerTier = indexSettings.getValue(INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING);
        double reclaimDeletesWeight = indexSettings.getValue(INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT_SETTING);
        this.mergesEnabled = indexSettings.getSettings().getAsBoolean(INDEX_MERGE_ENABLED, true);
        if (!this.mergesEnabled) {
            logger.warn("[{}] is set to false, this should only be used in tests and can cause serious problems in production environments", (Object)INDEX_MERGE_ENABLED);
        }
        maxMergeAtOnce = this.adjustMaxMergeAtOnceIfNeeded(maxMergeAtOnce, segmentsPerTier);
        this.mergePolicy.setNoCFSRatio(indexSettings.getValue(INDEX_COMPOUND_FORMAT_SETTING));
        this.mergePolicy.setForceMergeDeletesPctAllowed(forceMergeDeletesPctAllowed);
        this.mergePolicy.setFloorSegmentMB(floorSegment.getMbFrac());
        this.mergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
        this.mergePolicy.setMaxMergeAtOnceExplicit(maxMergeAtOnceExplicit);
        this.mergePolicy.setMaxMergedSegmentMB(maxMergedSegment.getMbFrac());
        this.mergePolicy.setSegmentsPerTier(segmentsPerTier);
        this.mergePolicy.setReclaimDeletesWeight(reclaimDeletesWeight);
        if (logger.isTraceEnabled()) {
            logger.trace("using [tiered] merge mergePolicy with expunge_deletes_allowed[{}], floor_segment[{}], max_merge_at_once[{}], max_merge_at_once_explicit[{}], max_merged_segment[{}], segments_per_tier[{}], reclaim_deletes_weight[{}]", (Object)forceMergeDeletesPctAllowed, (Object)floorSegment, (Object)maxMergeAtOnce, (Object)maxMergeAtOnceExplicit, (Object)maxMergedSegment, (Object)segmentsPerTier, (Object)reclaimDeletesWeight);
        }
    }

    void setReclaimDeletesWeight(Double reclaimDeletesWeight) {
        this.mergePolicy.setReclaimDeletesWeight(reclaimDeletesWeight);
    }

    void setSegmentsPerTier(Double segmentsPerTier) {
        this.mergePolicy.setSegmentsPerTier(segmentsPerTier);
    }

    void setMaxMergedSegment(ByteSizeValue maxMergedSegment) {
        this.mergePolicy.setMaxMergedSegmentMB(maxMergedSegment.getMbFrac());
    }

    void setMaxMergesAtOnceExplicit(Integer maxMergeAtOnceExplicit) {
        this.mergePolicy.setMaxMergeAtOnceExplicit(maxMergeAtOnceExplicit);
    }

    void setMaxMergesAtOnce(Integer maxMergeAtOnce) {
        this.mergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
    }

    void setFloorSegmentSetting(ByteSizeValue floorSegementSetting) {
        this.mergePolicy.setFloorSegmentMB(floorSegementSetting.getMbFrac());
    }

    void setExpungeDeletesAllowed(Double value) {
        this.mergePolicy.setForceMergeDeletesPctAllowed(value);
    }

    void setNoCFSRatio(Double noCFSRatio) {
        this.mergePolicy.setNoCFSRatio(noCFSRatio);
    }

    private int adjustMaxMergeAtOnceIfNeeded(int maxMergeAtOnce, double segmentsPerTier) {
        if (!(segmentsPerTier >= (double)maxMergeAtOnce)) {
            int newMaxMergeAtOnce = (int)segmentsPerTier;
            if (newMaxMergeAtOnce <= 1) {
                newMaxMergeAtOnce = 2;
            }
            this.logger.debug("changing max_merge_at_once from [{}] to [{}] because segments_per_tier [{}] has to be higher or equal to it", (Object)maxMergeAtOnce, (Object)newMaxMergeAtOnce, (Object)segmentsPerTier);
            maxMergeAtOnce = newMaxMergeAtOnce;
        }
        return maxMergeAtOnce;
    }

    MergePolicy getMergePolicy() {
        return this.mergesEnabled ? this.mergePolicy : NoMergePolicy.INSTANCE;
    }

    private static double parseNoCFSRatio(String noCFSRatio) {
        if ((noCFSRatio = noCFSRatio.trim()).equalsIgnoreCase("true")) {
            return 1.0;
        }
        if (noCFSRatio.equalsIgnoreCase("false")) {
            return 0.0;
        }
        try {
            double value = Double.parseDouble(noCFSRatio);
            if (value < 0.0 || value > 1.0) {
                throw new IllegalArgumentException("NoCFSRatio must be in the interval [0..1] but was: [" + value + "]");
            }
            return value;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Expected a boolean or a value in the interval [0..1] but was: [" + noCFSRatio + "]", ex);
        }
    }
}

