/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MergePolicy;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.MergePolicyConfig;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.node.Node;

public final class IndexSettings {
    public static final Setting<String> DEFAULT_FIELD_SETTING = new Setting("index.query.default_field", "_all", Function.identity(), Setting.Property.IndexScope);
    public static final Setting<Boolean> QUERY_STRING_LENIENT_SETTING = Setting.boolSetting("index.query_string.lenient", false, Setting.Property.IndexScope);
    public static final Setting<Boolean> QUERY_STRING_ANALYZE_WILDCARD = Setting.boolSetting("indices.query.query_string.analyze_wildcard", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> QUERY_STRING_ALLOW_LEADING_WILDCARD = Setting.boolSetting("indices.query.query_string.allowLeadingWildcard", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> ALLOW_UNMAPPED = Setting.boolSetting("index.query.parse.allow_unmapped_fields", true, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_TRANSLOG_SYNC_INTERVAL_SETTING = Setting.timeSetting("index.translog.sync_interval", TimeValue.timeValueSeconds(5L), TimeValue.timeValueMillis(100L), Setting.Property.IndexScope);
    public static final Setting<Translog.Durability> INDEX_TRANSLOG_DURABILITY_SETTING = new Setting<Translog.Durability>("index.translog.durability", Translog.Durability.REQUEST.name(), value -> Translog.Durability.valueOf(value.toUpperCase(Locale.ROOT)), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_WARMER_ENABLED_SETTING = Setting.boolSetting("index.warmer.enabled", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_TTL_DISABLE_PURGE_SETTING = Setting.boolSetting("index.ttl.disable_purge", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<String> INDEX_CHECK_ON_STARTUP = new Setting<String>("index.shard.check_on_startup", "false", s -> {
        switch (s) {
            case "false": 
            case "true": 
            case "fix": 
            case "checksum": {
                return s;
            }
        }
        throw new IllegalArgumentException("unknown value for [index.shard.check_on_startup] must be one of [true, false, fix, checksum] but was: " + s);
    }, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_RESULT_WINDOW_SETTING = Setting.intSetting("index.max_result_window", 10000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_RESCORE_WINDOW_SETTING = Setting.intSetting("index.max_rescore_window", MAX_RESULT_WINDOW_SETTING, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final TimeValue DEFAULT_REFRESH_INTERVAL = new TimeValue(1L, TimeUnit.SECONDS);
    public static final Setting<TimeValue> INDEX_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.refresh_interval", DEFAULT_REFRESH_INTERVAL, new TimeValue(-1L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.flush_threshold_size", new ByteSizeValue(512L, ByteSizeUnit.MB), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final TimeValue DEFAULT_GC_DELETES = TimeValue.timeValueSeconds(60L);
    public static final Setting<TimeValue> INDEX_GC_DELETES_SETTING = Setting.timeSetting("index.gc_deletes", DEFAULT_GC_DELETES, new TimeValue(-1L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_REFRESH_LISTENERS_PER_SHARD = Setting.intSetting("index.max_refresh_listeners", 1000, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_SLICES_PER_SCROLL = Setting.intSetting("index.max_slices_per_scroll", 1024, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private final Index index;
    private final Version version;
    private final Logger logger;
    private final String nodeName;
    private final Settings nodeSettings;
    private final int numberOfShards;
    private final boolean isShadowReplicaIndex;
    private final ParseFieldMatcher parseFieldMatcher;
    private volatile Settings settings;
    private volatile IndexMetaData indexMetaData;
    private final String defaultField;
    private final boolean queryStringLenient;
    private final boolean queryStringAnalyzeWildcard;
    private final boolean queryStringAllowLeadingWildcard;
    private final boolean defaultAllowUnmappedFields;
    private final Predicate<String> indexNameMatcher;
    private volatile Translog.Durability durability;
    private final TimeValue syncInterval;
    private volatile TimeValue refreshInterval;
    private volatile ByteSizeValue flushThresholdSize;
    private final MergeSchedulerConfig mergeSchedulerConfig;
    private final MergePolicyConfig mergePolicyConfig;
    private final IndexScopedSettings scopedSettings;
    private long gcDeletesInMillis = DEFAULT_GC_DELETES.millis();
    private volatile boolean warmerEnabled;
    private volatile int maxResultWindow;
    private volatile int maxRescoreWindow;
    private volatile boolean TTLPurgeDisabled;
    private volatile int maxRefreshListeners;
    private volatile int maxSlicesPerScroll;

    public String getDefaultField() {
        return this.defaultField;
    }

    public boolean isQueryStringLenient() {
        return this.queryStringLenient;
    }

    public boolean isQueryStringAnalyzeWildcard() {
        return this.queryStringAnalyzeWildcard;
    }

    public boolean isQueryStringAllowLeadingWildcard() {
        return this.queryStringAllowLeadingWildcard;
    }

    public boolean isDefaultAllowUnmappedFields() {
        return this.defaultAllowUnmappedFields;
    }

    public IndexSettings(IndexMetaData indexMetaData, Settings nodeSettings) {
        this(indexMetaData, nodeSettings, index -> Regex.simpleMatch(index, indexMetaData.getIndex().getName()), IndexScopedSettings.DEFAULT_SCOPED_SETTINGS);
    }

    public IndexSettings(IndexMetaData indexMetaData, Settings nodeSettings, Predicate<String> indexNameMatcher, IndexScopedSettings indexScopedSettings) {
        this.scopedSettings = indexScopedSettings.copy(nodeSettings, indexMetaData);
        this.nodeSettings = nodeSettings;
        this.settings = Settings.builder().put(nodeSettings).put(indexMetaData.getSettings()).build();
        this.index = indexMetaData.getIndex();
        this.version = Version.indexCreated(this.settings);
        this.logger = Loggers.getLogger(this.getClass(), this.settings, this.index, new String[0]);
        this.nodeName = Node.NODE_NAME_SETTING.get(this.settings);
        this.indexMetaData = indexMetaData;
        this.numberOfShards = this.settings.getAsInt("index.number_of_shards", null);
        this.isShadowReplicaIndex = IndexMetaData.isIndexUsingShadowReplicas(this.settings);
        this.defaultField = DEFAULT_FIELD_SETTING.get(this.settings);
        this.queryStringLenient = QUERY_STRING_LENIENT_SETTING.get(this.settings);
        this.queryStringAnalyzeWildcard = QUERY_STRING_ANALYZE_WILDCARD.get(nodeSettings);
        this.queryStringAllowLeadingWildcard = QUERY_STRING_ALLOW_LEADING_WILDCARD.get(nodeSettings);
        this.parseFieldMatcher = new ParseFieldMatcher(this.settings);
        this.defaultAllowUnmappedFields = this.scopedSettings.get(ALLOW_UNMAPPED);
        this.indexNameMatcher = indexNameMatcher;
        this.durability = this.scopedSettings.get(INDEX_TRANSLOG_DURABILITY_SETTING);
        this.syncInterval = INDEX_TRANSLOG_SYNC_INTERVAL_SETTING.get(this.settings);
        this.refreshInterval = this.scopedSettings.get(INDEX_REFRESH_INTERVAL_SETTING);
        this.flushThresholdSize = this.scopedSettings.get(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING);
        this.mergeSchedulerConfig = new MergeSchedulerConfig(this);
        this.gcDeletesInMillis = this.scopedSettings.get(INDEX_GC_DELETES_SETTING).getMillis();
        this.warmerEnabled = this.scopedSettings.get(INDEX_WARMER_ENABLED_SETTING);
        this.maxResultWindow = this.scopedSettings.get(MAX_RESULT_WINDOW_SETTING);
        this.maxRescoreWindow = this.scopedSettings.get(MAX_RESCORE_WINDOW_SETTING);
        this.TTLPurgeDisabled = this.scopedSettings.get(INDEX_TTL_DISABLE_PURGE_SETTING);
        this.maxRefreshListeners = this.scopedSettings.get(MAX_REFRESH_LISTENERS_PER_SHARD);
        this.maxSlicesPerScroll = this.scopedSettings.get(MAX_SLICES_PER_SCROLL);
        this.mergePolicyConfig = new MergePolicyConfig(this.logger, this);
        assert (indexNameMatcher.test(indexMetaData.getIndex().getName()));
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_COMPOUND_FORMAT_SETTING, this.mergePolicyConfig::setNoCFSRatio);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING, this.mergePolicyConfig::setExpungeDeletesAllowed);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING, this.mergePolicyConfig::setFloorSegmentSetting);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING, this.mergePolicyConfig::setMaxMergesAtOnce);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT_SETTING, this.mergePolicyConfig::setMaxMergesAtOnceExplicit);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING, this.mergePolicyConfig::setMaxMergedSegment);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING, this.mergePolicyConfig::setSegmentsPerTier);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT_SETTING, this.mergePolicyConfig::setReclaimDeletesWeight);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING, MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING, this.mergeSchedulerConfig::setMaxThreadAndMergeCount);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.AUTO_THROTTLE_SETTING, this.mergeSchedulerConfig::setAutoThrottle);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_DURABILITY_SETTING, this::setTranslogDurability);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TTL_DISABLE_PURGE_SETTING, this::setTTLPurgeDisabled);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_RESULT_WINDOW_SETTING, this::setMaxResultWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_RESCORE_WINDOW_SETTING, this::setMaxRescoreWindow);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_WARMER_ENABLED_SETTING, this::setEnableWarmer);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_GC_DELETES_SETTING, this::setGCDeletes);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING, this::setTranslogFlushThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_REFRESH_INTERVAL_SETTING, this::setRefreshInterval);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_REFRESH_LISTENERS_PER_SHARD, this::setMaxRefreshListeners);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SLICES_PER_SCROLL, this::setMaxSlicesPerScroll);
    }

    private void setTranslogFlushThresholdSize(ByteSizeValue byteSizeValue) {
        this.flushThresholdSize = byteSizeValue;
    }

    private void setGCDeletes(TimeValue timeValue) {
        this.gcDeletesInMillis = timeValue.getMillis();
    }

    private void setRefreshInterval(TimeValue timeValue) {
        this.refreshInterval = timeValue;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getUUID() {
        return this.getIndex().getUUID();
    }

    public boolean hasCustomDataPath() {
        return this.customDataPath() != null;
    }

    public String customDataPath() {
        return this.settings.get("index.data_path");
    }

    public boolean isOnSharedFilesystem() {
        return IndexMetaData.isOnSharedFilesystem(this.getSettings());
    }

    public boolean isIndexUsingShadowReplicas() {
        return IndexMetaData.isOnSharedFilesystem(this.getSettings());
    }

    public Version getIndexVersionCreated() {
        return this.version;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.settings.getAsInt("index.number_of_replicas", null);
    }

    public boolean isShadowReplicaIndex() {
        return this.isShadowReplicaIndex;
    }

    public Settings getNodeSettings() {
        return this.nodeSettings;
    }

    public ParseFieldMatcher getParseFieldMatcher() {
        return this.parseFieldMatcher;
    }

    public boolean matchesIndexName(String expression) {
        return this.indexNameMatcher.test(expression);
    }

    public synchronized boolean updateIndexMetaData(IndexMetaData indexMetaData) {
        Settings newSettings = indexMetaData.getSettings();
        if (!this.version.equals(Version.indexCreated(newSettings))) {
            throw new IllegalArgumentException("version mismatch on settings update expected: " + this.version + " but was: " + Version.indexCreated(newSettings));
        }
        String newUUID = newSettings.get("index.uuid", "_na_");
        if (!newUUID.equals(this.getUUID())) {
            throw new IllegalArgumentException("uuid mismatch on settings update expected: " + this.getUUID() + " but was: " + newUUID);
        }
        this.indexMetaData = indexMetaData;
        Settings existingSettings = this.settings;
        if (existingSettings.filter(IndexScopedSettings.INDEX_SETTINGS_KEY_PREDICATE).getAsMap().equals(newSettings.filter(IndexScopedSettings.INDEX_SETTINGS_KEY_PREDICATE).getAsMap())) {
            return false;
        }
        this.scopedSettings.applySettings(newSettings);
        this.settings = Settings.builder().put(this.nodeSettings).put(newSettings).build();
        return true;
    }

    public Translog.Durability getTranslogDurability() {
        return this.durability;
    }

    private void setTranslogDurability(Translog.Durability durability) {
        this.durability = durability;
    }

    public boolean isWarmerEnabled() {
        return this.warmerEnabled;
    }

    private void setEnableWarmer(boolean enableWarmer) {
        this.warmerEnabled = enableWarmer;
    }

    public TimeValue getTranslogSyncInterval() {
        return this.syncInterval;
    }

    public TimeValue getRefreshInterval() {
        return this.refreshInterval;
    }

    public ByteSizeValue getFlushThresholdSize() {
        return this.flushThresholdSize;
    }

    public MergeSchedulerConfig getMergeSchedulerConfig() {
        return this.mergeSchedulerConfig;
    }

    public int getMaxResultWindow() {
        return this.maxResultWindow;
    }

    private void setMaxResultWindow(int maxResultWindow) {
        this.maxResultWindow = maxResultWindow;
    }

    public int getMaxRescoreWindow() {
        return this.maxRescoreWindow;
    }

    private void setMaxRescoreWindow(int maxRescoreWindow) {
        this.maxRescoreWindow = maxRescoreWindow;
    }

    public long getGcDeletesInMillis() {
        return this.gcDeletesInMillis;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicyConfig.getMergePolicy();
    }

    public boolean isTTLPurgeDisabled() {
        return this.TTLPurgeDisabled;
    }

    private void setTTLPurgeDisabled(boolean ttlPurgeDisabled) {
        this.TTLPurgeDisabled = ttlPurgeDisabled;
    }

    public <T> T getValue(Setting<T> setting) {
        return this.scopedSettings.get(setting);
    }

    public int getMaxRefreshListeners() {
        return this.maxRefreshListeners;
    }

    private void setMaxRefreshListeners(int maxRefreshListeners) {
        this.maxRefreshListeners = maxRefreshListeners;
    }

    public int getMaxSlicesPerScroll() {
        return this.maxSlicesPerScroll;
    }

    private void setMaxSlicesPerScroll(int value) {
        this.maxSlicesPerScroll = value;
    }

    public IndexScopedSettings getScopedSettings() {
        return this.scopedSettings;
    }
}

