/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty3.cors;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.HttpMethod;
import org.elasticsearch.http.netty3.cors.Netty3CorsConfig;

public final class Netty3CorsConfigBuilder {
    Optional<Set<String>> origins;
    Optional<Pattern> pattern;
    final boolean anyOrigin;
    boolean allowNullOrigin;
    boolean enabled = true;
    boolean allowCredentials;
    long maxAge;
    final Set<HttpMethod> requestMethods = new HashSet<HttpMethod>();
    final Set<String> requestHeaders = new HashSet<String>();
    final Map<CharSequence, Callable<?>> preflightHeaders = new HashMap();
    private boolean noPreflightHeaders;
    boolean shortCircuit;

    public static Netty3CorsConfigBuilder forAnyOrigin() {
        return new Netty3CorsConfigBuilder();
    }

    public static Netty3CorsConfigBuilder forOrigin(String origin) {
        if ("*".equals(origin)) {
            return new Netty3CorsConfigBuilder();
        }
        return new Netty3CorsConfigBuilder(origin);
    }

    public static Netty3CorsConfigBuilder forPattern(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("CORS pattern cannot be null");
        }
        return new Netty3CorsConfigBuilder(pattern);
    }

    public static Netty3CorsConfigBuilder forOrigins(String ... origins) {
        return new Netty3CorsConfigBuilder(origins);
    }

    Netty3CorsConfigBuilder(String ... origins) {
        this.origins = Optional.of(new LinkedHashSet<String>(Arrays.asList(origins)));
        this.pattern = Optional.empty();
        this.anyOrigin = false;
    }

    Netty3CorsConfigBuilder() {
        this.anyOrigin = true;
        this.origins = Optional.empty();
        this.pattern = Optional.empty();
    }

    Netty3CorsConfigBuilder(Pattern pattern) {
        this.pattern = Optional.of(pattern);
        this.origins = Optional.empty();
        this.anyOrigin = false;
    }

    Netty3CorsConfigBuilder allowNullOrigin() {
        this.allowNullOrigin = true;
        return this;
    }

    public Netty3CorsConfigBuilder disable() {
        this.enabled = false;
        return this;
    }

    public Netty3CorsConfigBuilder allowCredentials() {
        this.allowCredentials = true;
        return this;
    }

    public Netty3CorsConfigBuilder maxAge(long max) {
        this.maxAge = max;
        return this;
    }

    public Netty3CorsConfigBuilder allowedRequestMethods(Set<HttpMethod> methods) {
        this.requestMethods.addAll(methods);
        return this;
    }

    public Netty3CorsConfigBuilder allowedRequestHeaders(Set<String> headers) {
        this.requestHeaders.addAll(headers);
        return this;
    }

    public Netty3CorsConfigBuilder preflightResponseHeader(CharSequence name, Object ... values) {
        if (values.length == 1) {
            this.preflightHeaders.put(name, new ConstantValueGenerator(values[0]));
        } else {
            this.preflightResponseHeader(name, Arrays.asList(values));
        }
        return this;
    }

    public <T> Netty3CorsConfigBuilder preflightResponseHeader(CharSequence name, Iterable<T> value) {
        this.preflightHeaders.put(name, new ConstantValueGenerator(value));
        return this;
    }

    public <T> Netty3CorsConfigBuilder preflightResponseHeader(CharSequence name, Callable<T> valueGenerator) {
        this.preflightHeaders.put(name, valueGenerator);
        return this;
    }

    public Netty3CorsConfigBuilder noPreflightResponseHeaders() {
        this.noPreflightHeaders = true;
        return this;
    }

    public Netty3CorsConfigBuilder shortCircuit() {
        this.shortCircuit = true;
        return this;
    }

    public Netty3CorsConfig build() {
        if (this.preflightHeaders.isEmpty() && !this.noPreflightHeaders) {
            this.preflightHeaders.put("date", DateValueGenerator.INSTANCE);
            this.preflightHeaders.put("content-length", new ConstantValueGenerator("0"));
        }
        return new Netty3CorsConfig(this);
    }

    private static final class DateValueGenerator
    implements Callable<Date> {
        static final DateValueGenerator INSTANCE = new DateValueGenerator();

        private DateValueGenerator() {
        }

        @Override
        public Date call() throws Exception {
            return new Date();
        }
    }

    private static final class ConstantValueGenerator
    implements Callable<Object> {
        private final Object value;

        private ConstantValueGenerator(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            this.value = value;
        }

        @Override
        public Object call() {
            return this.value;
        }
    }
}

