/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;

public abstract class BaseGatewayShardAllocator
extends AbstractComponent {
    public BaseGatewayShardAllocator(Settings settings) {
        super(settings);
    }

    public void allocateUnassigned(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            ShardRouting shard = unassignedIterator.next();
            AllocateUnassignedDecision allocateUnassignedDecision = this.makeAllocationDecision(shard, allocation, this.logger);
            if (!allocateUnassignedDecision.isDecisionTaken()) continue;
            if (allocateUnassignedDecision.getFinalDecisionSafe() == Decision.Type.YES) {
                unassignedIterator.initialize(allocateUnassignedDecision.getAssignedNodeId(), allocateUnassignedDecision.getAllocationId(), shard.primary() ? -1L : allocation.clusterInfo().getShardSize(shard, -1L), allocation.changes());
                continue;
            }
            unassignedIterator.removeAndIgnore(allocateUnassignedDecision.getAllocationStatus(), allocation.changes());
        }
    }

    public abstract AllocateUnassignedDecision makeAllocationDecision(ShardRouting var1, RoutingAllocation var2, Logger var3);
}

