/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.NoneDiscovery;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class DiscoveryModule {
    public static final Setting<String> DISCOVERY_TYPE_SETTING = new Setting("discovery.type", "zen", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<Optional<String>> DISCOVERY_HOSTS_PROVIDER_SETTING = new Setting<Optional>("discovery.zen.hosts_provider", (String)null, Optional::ofNullable, Setting.Property.NodeScope);
    private final Discovery discovery;

    public DiscoveryModule(Settings settings, ThreadPool threadPool, TransportService transportService, NetworkService networkService, ClusterService clusterService, List<DiscoveryPlugin> plugins) {
        UnicastHostsProvider hostsProvider;
        HashMap hostProviders = new HashMap();
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getZenHostsProviders(transportService, networkService).entrySet().forEach(entry -> {
                if (hostProviders.put(entry.getKey(), entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register zen hosts provider [" + (String)entry.getKey() + "] twice");
                }
            });
        }
        Optional<String> hostsProviderName = DISCOVERY_HOSTS_PROVIDER_SETTING.get(settings);
        if (hostsProviderName.isPresent()) {
            Supplier hostsProviderSupplier = (Supplier)hostProviders.get(hostsProviderName.get());
            if (hostsProviderSupplier == null) {
                throw new IllegalArgumentException("Unknown zen hosts provider [" + hostsProviderName.get() + "]");
            }
            hostsProvider = (UnicastHostsProvider)Objects.requireNonNull(hostsProviderSupplier.get());
        } else {
            hostsProvider = Collections::emptyList;
        }
        HashMap<String, Supplier<Discovery>> discoveryTypes = new HashMap<String, Supplier<Discovery>>();
        discoveryTypes.put("zen", () -> new ZenDiscovery(settings, threadPool, transportService, clusterService, hostsProvider));
        discoveryTypes.put("none", () -> new NoneDiscovery(settings, clusterService, clusterService.getClusterSettings()));
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getDiscoveryTypes(threadPool, transportService, clusterService, hostsProvider).entrySet().forEach(entry -> {
                if (discoveryTypes.put((String)entry.getKey(), (Supplier<Discovery>)entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register discovery type [" + (String)entry.getKey() + "] twice");
                }
            });
        }
        String discoveryType = DISCOVERY_TYPE_SETTING.get(settings);
        Supplier discoverySupplier = (Supplier)discoveryTypes.get(discoveryType);
        if (discoverySupplier == null) {
            throw new IllegalArgumentException("Unknown discovery type [" + discoveryType + "]");
        }
        this.discovery = (Discovery)Objects.requireNonNull(discoverySupplier.get());
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }
}

