/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.script.ExplainableSearchScript;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.SearchScript;

public class ScriptScoreFunction
extends ScoreFunction {
    private final Script sScript;
    private final SearchScript script;

    public ScriptScoreFunction(Script sScript, SearchScript script) {
        super(CombineFunction.REPLACE);
        this.sScript = sScript;
        this.script = script;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) throws IOException {
        final LeafSearchScript leafScript = this.script.getLeafSearchScript(ctx);
        final CannedScorer scorer = new CannedScorer();
        leafScript.setScorer(scorer);
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) {
                leafScript.setDocument(docId);
                scorer.docid = docId;
                scorer.score = subQueryScore;
                double result = leafScript.runAsDouble();
                if (Double.isNaN(result)) {
                    throw new GeneralScriptException("script_score returned NaN");
                }
                return result;
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                if (!(leafScript instanceof ExplainableSearchScript)) {
                    double score = this.score(docId, subQueryScore.getValue());
                    String explanation = "script score function, computed with script:\"" + ScriptScoreFunction.this.sScript + "\"";
                    if (ScriptScoreFunction.this.sScript.getParams() != null) {
                        explanation = explanation + " and parameters: \n" + ScriptScoreFunction.this.sScript.getParams().toString();
                    }
                    Explanation scoreExp = Explanation.match(subQueryScore.getValue(), "_score: ", subQueryScore);
                    return Explanation.match(CombineFunction.toFloat(score), explanation, scoreExp);
                }
                leafScript.setDocument(docId);
                scorer.docid = docId;
                scorer.score = subQueryScore.getValue();
                Explanation exp = ((ExplainableSearchScript)leafScript).explain(subQueryScore);
                return exp;
            }
        };
    }

    @Override
    public boolean needsScores() {
        return this.script.needsScores();
    }

    public String toString() {
        return "script" + this.sScript.toString();
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        ScriptScoreFunction scriptScoreFunction = (ScriptScoreFunction)other;
        return Objects.equals(this.sScript, scriptScoreFunction.sScript);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.sScript);
    }

    static final class CannedScorer
    extends Scorer {
        protected int docid;
        protected float score;

        public CannedScorer() {
            super(null);
        }

        @Override
        public int docID() {
            return this.docid;
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }

        @Override
        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

