/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;

public final class ShardCoreKeyMap {
    private final Map<Object, ShardId> coreKeyToShard = new ConcurrentHashMap<Object, ShardId>();
    private final Map<String, Set<Object>> indexToCoreKey = new HashMap<String, Set<Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LeafReader reader) {
        ShardId shardId = ShardUtils.extractShardId(reader);
        if (shardId == null) {
            throw new IllegalArgumentException("Could not extract shard id from " + reader);
        }
        Object coreKey = reader.getCoreCacheKey();
        if (this.coreKeyToShard.containsKey(coreKey)) {
            return;
        }
        String index = shardId.getIndexName();
        ShardCoreKeyMap shardCoreKeyMap = this;
        synchronized (shardCoreKeyMap) {
            if (!this.coreKeyToShard.containsKey(coreKey)) {
                Set<Object> objects = this.indexToCoreKey.get(index);
                if (objects == null) {
                    objects = new HashSet<Object>();
                    this.indexToCoreKey.put(index, objects);
                }
                boolean added = objects.add(coreKey);
                assert (added);
                LeafReader.CoreClosedListener listener = ownerCoreCacheKey -> {
                    assert (coreKey == ownerCoreCacheKey);
                    ShardCoreKeyMap shardCoreKeyMap = this;
                    synchronized (shardCoreKeyMap) {
                        this.coreKeyToShard.remove(ownerCoreCacheKey);
                        Set<Object> coreKeys = this.indexToCoreKey.get(index);
                        boolean removed = coreKeys.remove(coreKey);
                        assert (removed);
                        if (coreKeys.isEmpty()) {
                            this.indexToCoreKey.remove(index);
                        }
                    }
                };
                boolean addedListener = false;
                try {
                    reader.addCoreClosedListener(listener);
                    addedListener = true;
                    ShardId previous = this.coreKeyToShard.put(coreKey, shardId);
                    assert (previous == null);
                }
                finally {
                    if (!addedListener) {
                        try {
                            listener.onClose(coreKey);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Blow up trying to recover from failure to add listener", e);
                        }
                    }
                }
            }
        }
    }

    public synchronized ShardId getShardId(Object coreKey) {
        return this.coreKeyToShard.get(coreKey);
    }

    public synchronized Set<Object> getCoreKeysForIndex(String index) {
        Set<Object> objects = this.indexToCoreKey.get(index);
        if (objects == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<Object>(objects));
    }

    public synchronized int size() {
        assert (this.assertSize());
        return this.coreKeyToShard.size();
    }

    private synchronized boolean assertSize() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertionsEnabled) {
            throw new AssertionError((Object)"only run this if assertions are enabled");
        }
        Collection<Set<Object>> values = this.indexToCoreKey.values();
        int size = 0;
        for (Set<Object> value : values) {
            size += value.size();
        }
        return size == this.coreKeyToShard.size();
    }
}

