/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Level;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Marker;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.MarkerManager;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.message.Message;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

class PrefixLogger
extends ExtendedLoggerWrapper {
    private static final WeakHashMap<String, WeakReference<Marker>> markers = new WeakHashMap();
    private final Marker marker;

    public String prefix() {
        return this.marker.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrefixLogger(ExtendedLogger logger, String name, String prefix) {
        super(logger, name, null);
        Marker actualMarker;
        String actualPrefix = (prefix == null ? "" : prefix).intern();
        WeakHashMap<String, WeakReference<Marker>> weakHashMap = markers;
        synchronized (weakHashMap) {
            Marker maybeMarker;
            WeakReference<Marker> marker = markers.get(actualPrefix);
            Marker marker2 = maybeMarker = marker == null ? null : (Marker)marker.get();
            if (maybeMarker == null) {
                actualMarker = new MarkerManager.Log4jMarker(actualPrefix);
                markers.put(actualPrefix, new WeakReference<Marker>(actualMarker));
            } else {
                actualMarker = maybeMarker;
            }
        }
        this.marker = actualMarker;
    }

    @Override
    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        assert (marker == null);
        super.logMessage(fqcn, level, this.marker, message, t);
    }
}

