/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.liveness.LivenessRequest;
import org.elasticsearch.action.admin.cluster.node.liveness.LivenessResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

final class TransportClientNodesService
extends AbstractComponent
implements Closeable {
    private final TimeValue nodesSamplerInterval;
    private final long pingTimeout;
    private final ClusterName clusterName;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Version minCompatibilityVersion;
    private volatile List<DiscoveryNode> listedNodes = Collections.emptyList();
    private final Object mutex = new Object();
    private volatile List<DiscoveryNode> nodes = Collections.emptyList();
    private volatile List<DiscoveryNode> filteredNodes = Collections.emptyList();
    private final AtomicInteger tempNodeIdGenerator = new AtomicInteger();
    private final NodeSampler nodesSampler;
    private volatile ScheduledFuture nodesSamplerFuture;
    private final AtomicInteger randomNodeGenerator = new AtomicInteger(Randomness.get().nextInt());
    private final boolean ignoreClusterName;
    private volatile boolean closed;
    private final TransportClient.HostFailureListener hostFailureListener;

    TransportClientNodesService(Settings settings, TransportService transportService, ThreadPool threadPool, TransportClient.HostFailureListener hostFailureListener) {
        super(settings);
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.transportService = transportService;
        this.threadPool = threadPool;
        this.minCompatibilityVersion = Version.CURRENT.minimumCompatibilityVersion();
        this.nodesSamplerInterval = TransportClient.CLIENT_TRANSPORT_NODES_SAMPLER_INTERVAL.get(this.settings);
        this.pingTimeout = TransportClient.CLIENT_TRANSPORT_PING_TIMEOUT.get(this.settings).millis();
        this.ignoreClusterName = TransportClient.CLIENT_TRANSPORT_IGNORE_CLUSTER_NAME.get(this.settings);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("node_sampler_interval[{}]", (Object)this.nodesSamplerInterval);
        }
        this.nodesSampler = TransportClient.CLIENT_TRANSPORT_SNIFF.get(this.settings) != false ? new SniffNodesSampler() : new SimpleNodeSampler();
        this.hostFailureListener = hostFailureListener;
        this.nodesSamplerFuture = threadPool.schedule(this.nodesSamplerInterval, "generic", new ScheduledNodeSampler());
    }

    public List<TransportAddress> transportAddresses() {
        ArrayList<TransportAddress> lstBuilder = new ArrayList<TransportAddress>();
        for (DiscoveryNode listedNode : this.listedNodes) {
            lstBuilder.add(listedNode.getAddress());
        }
        return Collections.unmodifiableList(lstBuilder);
    }

    public List<DiscoveryNode> connectedNodes() {
        return this.nodes;
    }

    public List<DiscoveryNode> filteredNodes() {
        return this.filteredNodes;
    }

    public List<DiscoveryNode> listedNodes() {
        return this.listedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClientNodesService addTransportAddresses(TransportAddress ... transportAddresses) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("transport client is closed, can't add an address");
            }
            ArrayList<TransportAddress> filtered = new ArrayList<TransportAddress>(transportAddresses.length);
            for (TransportAddress transportAddress : transportAddresses) {
                boolean found = false;
                for (DiscoveryNode otherNode : this.listedNodes) {
                    if (!otherNode.getAddress().equals(transportAddress)) continue;
                    found = true;
                    this.logger.debug("address [{}] already exists with [{}], ignoring...", (Object)transportAddress, (Object)otherNode);
                    break;
                }
                if (found) continue;
                filtered.add(transportAddress);
            }
            if (filtered.isEmpty()) {
                return this;
            }
            ArrayList<DiscoveryNode> builder = new ArrayList<DiscoveryNode>();
            builder.addAll(this.listedNodes());
            for (TransportAddress transportAddress : filtered) {
                DiscoveryNode node = new DiscoveryNode("#transport#-" + this.tempNodeIdGenerator.incrementAndGet(), transportAddress, Collections.emptyMap(), Collections.emptySet(), this.minCompatibilityVersion);
                this.logger.debug("adding address [{}]", (Object)node);
                builder.add(node);
            }
            this.listedNodes = Collections.unmodifiableList(builder);
            this.nodesSampler.sample();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClientNodesService removeTransportAddress(TransportAddress transportAddress) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("transport client is closed, can't remove an address");
            }
            ArrayList<DiscoveryNode> listNodesBuilder = new ArrayList<DiscoveryNode>();
            for (DiscoveryNode otherNode : this.listedNodes) {
                if (!otherNode.getAddress().equals(transportAddress)) {
                    listNodesBuilder.add(otherNode);
                    continue;
                }
                this.logger.debug("removing address [{}] from listed nodes", (Object)otherNode);
            }
            this.listedNodes = Collections.unmodifiableList(listNodesBuilder);
            ArrayList<DiscoveryNode> nodesBuilder = new ArrayList<DiscoveryNode>();
            for (DiscoveryNode otherNode : this.nodes) {
                if (!otherNode.getAddress().equals(transportAddress)) {
                    nodesBuilder.add(otherNode);
                    continue;
                }
                this.logger.debug("disconnecting from node with address [{}]", (Object)otherNode);
                this.transportService.disconnectFromNode(otherNode);
            }
            this.nodes = Collections.unmodifiableList(nodesBuilder);
            this.nodesSampler.sample();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Response> void execute(NodeListenerCallback<Response> callback, ActionListener<Response> listener) {
        List<DiscoveryNode> nodes = this.nodes;
        if (this.closed) {
            throw new IllegalStateException("transport client is closed");
        }
        this.ensureNodesAreAvailable(nodes);
        int index = this.getNodeNumber();
        RetryListener<Response> retryListener = new RetryListener<Response>(callback, listener, nodes, index, this.hostFailureListener);
        DiscoveryNode node = retryListener.getNode(0);
        try {
            callback.doWithNode(node, retryListener);
        }
        catch (Exception e) {
            try {
                listener.onFailure(e);
            }
            finally {
                retryListener.maybeNodeFailed(node, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            FutureUtils.cancel(this.nodesSamplerFuture);
            for (DiscoveryNode node : this.nodes) {
                this.transportService.disconnectFromNode(node);
            }
            for (DiscoveryNode listedNode : this.listedNodes) {
                this.transportService.disconnectFromNode(listedNode);
            }
            this.nodes = Collections.emptyList();
        }
    }

    private int getNodeNumber() {
        int index = this.randomNodeGenerator.incrementAndGet();
        if (index < 0) {
            index = 0;
            this.randomNodeGenerator.set(0);
        }
        return index;
    }

    private void ensureNodesAreAvailable(List<DiscoveryNode> nodes) {
        if (nodes.isEmpty()) {
            String message = String.format(Locale.ROOT, "None of the configured nodes are available: %s", this.listedNodes);
            throw new NoNodeAvailableException(message);
        }
    }

    void doSample() {
        this.nodesSampler.doSample();
    }

    public static interface NodeListenerCallback<Response> {
        public void doWithNode(DiscoveryNode var1, ActionListener<Response> var2);
    }

    class SniffNodesSampler
    extends NodeSampler {
        SniffNodesSampler() {
        }

        @Override
        protected void doSample() {
            HashSet<DiscoveryNode> nodesToPing = new HashSet<DiscoveryNode>();
            for (DiscoveryNode node : TransportClientNodesService.this.listedNodes) {
                nodesToPing.add(node);
            }
            for (DiscoveryNode node : TransportClientNodesService.this.nodes) {
                nodesToPing.add(node);
            }
            final CountDownLatch latch = new CountDownLatch(nodesToPing.size());
            final ConcurrentMap clusterStateResponses = ConcurrentCollections.newConcurrentMap();
            for (final DiscoveryNode listedNode : nodesToPing) {
                TransportClientNodesService.this.threadPool.executor("management").execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!TransportClientNodesService.this.transportService.nodeConnected(listedNode)) {
                                try {
                                    if (TransportClientNodesService.this.nodes.contains(listedNode)) {
                                        TransportClientNodesService.this.logger.trace("connecting to cluster node [{}]", (Object)listedNode);
                                        TransportClientNodesService.this.transportService.connectToNode(listedNode);
                                    } else {
                                        TransportClientNodesService.this.logger.trace("connecting to listed node (light) [{}]", (Object)listedNode);
                                        TransportClientNodesService.this.transportService.connectToNodeLight(listedNode);
                                    }
                                }
                                catch (Exception e) {
                                    TransportClientNodesService.this.logger.debug(() -> new ParameterizedMessage("failed to connect to node [{}], ignoring...", (Object)listedNode), (Throwable)e);
                                    latch.countDown();
                                    return;
                                }
                            }
                            TransportClientNodesService.this.transportService.sendRequest(listedNode, "cluster:monitor/state", (TransportRequest)Requests.clusterStateRequest().clear().nodes(true).local(true), TransportRequestOptions.builder().withType(TransportRequestOptions.Type.STATE).withTimeout(TransportClientNodesService.this.pingTimeout).build(), new TransportResponseHandler<ClusterStateResponse>(){

                                @Override
                                public ClusterStateResponse newInstance() {
                                    return new ClusterStateResponse();
                                }

                                @Override
                                public String executor() {
                                    return "same";
                                }

                                @Override
                                public void handleResponse(ClusterStateResponse response) {
                                    clusterStateResponses.put(listedNode, response);
                                    latch.countDown();
                                }

                                @Override
                                public void handleException(TransportException e) {
                                    TransportClientNodesService.this.logger.info(() -> new ParameterizedMessage("failed to get local cluster state for {}, disconnecting...", (Object)listedNode), (Throwable)e);
                                    TransportClientNodesService.this.transportService.disconnectFromNode(listedNode);
                                    latch.countDown();
                                    TransportClientNodesService.this.hostFailureListener.onNodeDisconnected(listedNode, e);
                                }
                            });
                        }
                        catch (Exception e) {
                            TransportClientNodesService.this.logger.info(() -> new ParameterizedMessage("failed to get local cluster state info for {}, disconnecting...", (Object)listedNode), (Throwable)e);
                            TransportClientNodesService.this.transportService.disconnectFromNode(listedNode);
                            latch.countDown();
                            TransportClientNodesService.this.hostFailureListener.onNodeDisconnected(listedNode, e);
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                return;
            }
            HashSet<DiscoveryNode> newNodes = new HashSet<DiscoveryNode>();
            HashSet newFilteredNodes = new HashSet();
            for (Map.Entry entry : clusterStateResponses.entrySet()) {
                if (!TransportClientNodesService.this.ignoreClusterName && !TransportClientNodesService.this.clusterName.equals(((ClusterStateResponse)entry.getValue()).getClusterName())) {
                    TransportClientNodesService.this.logger.warn("node {} not part of the cluster {}, ignoring...", (Object)((ClusterStateResponse)entry.getValue()).getState().nodes().getLocalNode(), (Object)TransportClientNodesService.this.clusterName);
                    newFilteredNodes.add(entry.getKey());
                    continue;
                }
                for (ObjectCursor<DiscoveryNode> objectCursor : ((ClusterStateResponse)entry.getValue()).getState().nodes().getDataNodes().values()) {
                    newNodes.add((DiscoveryNode)objectCursor.value);
                }
            }
            TransportClientNodesService.this.nodes = this.validateNewNodes(newNodes);
            TransportClientNodesService.this.filteredNodes = Collections.unmodifiableList(new ArrayList(newFilteredNodes));
        }
    }

    class SimpleNodeSampler
    extends NodeSampler {
        SimpleNodeSampler() {
        }

        @Override
        protected void doSample() {
            HashSet<DiscoveryNode> newNodes = new HashSet<DiscoveryNode>();
            HashSet<DiscoveryNode> newFilteredNodes = new HashSet<DiscoveryNode>();
            for (DiscoveryNode listedNode : TransportClientNodesService.this.listedNodes) {
                if (!TransportClientNodesService.this.transportService.nodeConnected(listedNode)) {
                    try {
                        TransportClientNodesService.this.logger.trace("connecting to listed node (light) [{}]", (Object)listedNode);
                        TransportClientNodesService.this.transportService.connectToNodeLight(listedNode);
                    }
                    catch (Exception e) {
                        TransportClientNodesService.this.logger.info(() -> new ParameterizedMessage("failed to connect to node [{}], removed from nodes list", (Object)listedNode), (Throwable)e);
                        TransportClientNodesService.this.hostFailureListener.onNodeDisconnected(listedNode, e);
                        newFilteredNodes.add(listedNode);
                        continue;
                    }
                }
                try {
                    LivenessResponse livenessResponse = TransportClientNodesService.this.transportService.submitRequest(listedNode, "cluster:monitor/nodes/liveness", new LivenessRequest(), TransportRequestOptions.builder().withType(TransportRequestOptions.Type.STATE).withTimeout(TransportClientNodesService.this.pingTimeout).build(), new FutureTransportResponseHandler<LivenessResponse>(){

                        @Override
                        public LivenessResponse newInstance() {
                            return new LivenessResponse();
                        }
                    }).txGet();
                    if (!TransportClientNodesService.this.ignoreClusterName && !TransportClientNodesService.this.clusterName.equals(livenessResponse.getClusterName())) {
                        TransportClientNodesService.this.logger.warn("node {} not part of the cluster {}, ignoring...", (Object)listedNode, (Object)TransportClientNodesService.this.clusterName);
                        newFilteredNodes.add(listedNode);
                        continue;
                    }
                    if (livenessResponse.getDiscoveryNode() != null) {
                        DiscoveryNode nodeWithInfo = livenessResponse.getDiscoveryNode();
                        newNodes.add(new DiscoveryNode(nodeWithInfo.getName(), nodeWithInfo.getId(), nodeWithInfo.getEphemeralId(), nodeWithInfo.getHostName(), nodeWithInfo.getHostAddress(), listedNode.getAddress(), nodeWithInfo.getAttributes(), nodeWithInfo.getRoles(), nodeWithInfo.getVersion()));
                        continue;
                    }
                    TransportClientNodesService.this.logger.debug("node {} didn't return any discovery info, temporarily using transport discovery node", (Object)listedNode);
                    newNodes.add(listedNode);
                }
                catch (Exception e) {
                    TransportClientNodesService.this.logger.info(() -> new ParameterizedMessage("failed to get node info for {}, disconnecting...", (Object)listedNode), (Throwable)e);
                    TransportClientNodesService.this.transportService.disconnectFromNode(listedNode);
                    TransportClientNodesService.this.hostFailureListener.onNodeDisconnected(listedNode, e);
                }
            }
            TransportClientNodesService.this.nodes = this.validateNewNodes(newNodes);
            TransportClientNodesService.this.filteredNodes = Collections.unmodifiableList(new ArrayList(newFilteredNodes));
        }
    }

    class ScheduledNodeSampler
    implements Runnable {
        ScheduledNodeSampler() {
        }

        @Override
        public void run() {
            try {
                TransportClientNodesService.this.nodesSampler.sample();
                if (!TransportClientNodesService.this.closed) {
                    TransportClientNodesService.this.nodesSamplerFuture = TransportClientNodesService.this.threadPool.schedule(TransportClientNodesService.this.nodesSamplerInterval, "generic", this);
                }
            }
            catch (Exception e) {
                TransportClientNodesService.this.logger.warn("failed to sample", (Throwable)e);
            }
        }
    }

    abstract class NodeSampler {
        NodeSampler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sample() {
            Object object = TransportClientNodesService.this.mutex;
            synchronized (object) {
                if (TransportClientNodesService.this.closed) {
                    return;
                }
                this.doSample();
            }
        }

        protected abstract void doSample();

        protected List<DiscoveryNode> validateNewNodes(Set<DiscoveryNode> nodes) {
            Iterator<DiscoveryNode> it = nodes.iterator();
            while (it.hasNext()) {
                DiscoveryNode node = it.next();
                if (TransportClientNodesService.this.transportService.nodeConnected(node)) continue;
                try {
                    TransportClientNodesService.this.logger.trace("connecting to node [{}]", (Object)node);
                    TransportClientNodesService.this.transportService.connectToNode(node);
                }
                catch (Exception e) {
                    it.remove();
                    TransportClientNodesService.this.logger.debug(() -> new ParameterizedMessage("failed to connect to discovered node [{}]", (Object)node), (Throwable)e);
                }
            }
            return Collections.unmodifiableList(new ArrayList<DiscoveryNode>(nodes));
        }
    }

    public static class RetryListener<Response>
    implements ActionListener<Response> {
        private final NodeListenerCallback<Response> callback;
        private final ActionListener<Response> listener;
        private final List<DiscoveryNode> nodes;
        private final int index;
        private final TransportClient.HostFailureListener hostFailureListener;
        private volatile int i;

        public RetryListener(NodeListenerCallback<Response> callback, ActionListener<Response> listener, List<DiscoveryNode> nodes, int index, TransportClient.HostFailureListener hostFailureListener) {
            this.callback = callback;
            this.listener = listener;
            this.nodes = nodes;
            this.index = index;
            this.hostFailureListener = hostFailureListener;
        }

        @Override
        public void onResponse(Response response) {
            this.listener.onResponse(response);
        }

        @Override
        public void onFailure(Exception e) {
            Throwable throwable = ExceptionsHelper.unwrapCause(e);
            if (throwable instanceof ConnectTransportException) {
                this.maybeNodeFailed(this.getNode(this.i), (ConnectTransportException)throwable);
                int i = ++this.i;
                if (i >= this.nodes.size()) {
                    this.listener.onFailure(new NoNodeAvailableException("None of the configured nodes were available: " + this.nodes, e));
                } else {
                    try {
                        this.callback.doWithNode(this.getNode(i), this);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        this.listener.onFailure(inner);
                    }
                }
            } else {
                this.listener.onFailure(e);
            }
        }

        final DiscoveryNode getNode(int i) {
            return this.nodes.get((this.index + i) % this.nodes.size());
        }

        final void maybeNodeFailed(DiscoveryNode node, Exception ex) {
            if (ex instanceof NodeDisconnectedException || ex instanceof NodeNotConnectedException) {
                this.hostFailureListener.onNodeDisconnected(node, ex);
            }
        }
    }
}

