/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.http.HttpResponse;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.elasticsearch.client.HeapBufferedAsyncResponseConsumer;

interface HttpAsyncResponseConsumerFactory {
    public static final HttpAsyncResponseConsumerFactory DEFAULT = new HeapBufferedResponseConsumerFactory(0x6400000);

    public HttpAsyncResponseConsumer<HttpResponse> createHttpAsyncResponseConsumer();

    public static class HeapBufferedResponseConsumerFactory
    implements HttpAsyncResponseConsumerFactory {
        static final int DEFAULT_BUFFER_LIMIT = 0x6400000;
        private final int bufferLimit;

        public HeapBufferedResponseConsumerFactory(int bufferLimitBytes) {
            this.bufferLimit = bufferLimitBytes;
        }

        @Override
        public HttpAsyncResponseConsumer<HttpResponse> createHttpAsyncResponseConsumer() {
            return new HeapBufferedAsyncResponseConsumer(this.bufferLimit);
        }
    }
}

