/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;

class SearchQueryAndFetchAsyncAction
extends AbstractSearchAsyncAction<QueryFetchSearchResult> {
    private final SearchPhaseController searchPhaseController;

    SearchQueryAndFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, Function<String, DiscoveryNode> nodeIdToDiscoveryNode, Map<String, AliasFilter> aliasFilter, SearchPhaseController searchPhaseController, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator shardsIts, long startTime, long clusterStateVersion, SearchTask task) {
        super(logger, searchTransportService, nodeIdToDiscoveryNode, aliasFilter, executor, request, listener, shardsIts, startTime, clusterStateVersion, task);
        this.searchPhaseController = searchPhaseController;
    }

    @Override
    protected String firstPhaseName() {
        return "query_fetch";
    }

    @Override
    protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<QueryFetchSearchResult> listener) {
        this.searchTransportService.sendExecuteFetch(node, request, this.task, listener);
    }

    @Override
    protected void moveToSecondPhase() throws Exception {
        this.getExecutor().execute(new ActionRunnable<SearchResponse>(this.listener){

            @Override
            public void doRun() throws IOException {
                boolean isScrollRequest = SearchQueryAndFetchAsyncAction.this.request.scroll() != null;
                SearchQueryAndFetchAsyncAction.this.sortedShardDocs = SearchQueryAndFetchAsyncAction.this.searchPhaseController.sortDocs(isScrollRequest, SearchQueryAndFetchAsyncAction.this.firstResults);
                InternalSearchResponse internalResponse = SearchQueryAndFetchAsyncAction.this.searchPhaseController.merge(isScrollRequest, SearchQueryAndFetchAsyncAction.this.sortedShardDocs, SearchQueryAndFetchAsyncAction.this.firstResults, SearchQueryAndFetchAsyncAction.this.firstResults);
                String scrollId = isScrollRequest ? TransportSearchHelper.buildScrollId(SearchQueryAndFetchAsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)SearchQueryAndFetchAsyncAction.this.firstResults) : null;
                this.listener.onResponse(new SearchResponse(internalResponse, scrollId, SearchQueryAndFetchAsyncAction.this.expectedSuccessfulOps, SearchQueryAndFetchAsyncAction.this.successfulOps.get(), SearchQueryAndFetchAsyncAction.this.buildTookInMillis(), SearchQueryAndFetchAsyncAction.this.buildShardFailures()));
            }

            @Override
            public void onFailure(Exception e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("merge", "", e, SearchQueryAndFetchAsyncAction.this.buildShardFailures());
                if (SearchQueryAndFetchAsyncAction.this.logger.isDebugEnabled()) {
                    SearchQueryAndFetchAsyncAction.this.logger.debug("failed to reduce search", (Throwable)failure);
                }
                super.onFailure(failure);
            }
        });
    }
}

