/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetAliasesResponse
extends ActionResponse {
    private ImmutableOpenMap<String, List<AliasMetaData>> aliases = ImmutableOpenMap.of();

    public GetAliasesResponse(ImmutableOpenMap<String, List<AliasMetaData>> aliases) {
        this.aliases = aliases;
    }

    GetAliasesResponse() {
    }

    public ImmutableOpenMap<String, List<AliasMetaData>> getAliases() {
        return this.aliases;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder aliasesBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<AliasMetaData> value = new ArrayList<AliasMetaData>(valueSize);
            for (int j = 0; j < valueSize; ++j) {
                value.add(AliasMetaData.Builder.readFrom(in));
            }
            aliasesBuilder.put(key, Collections.unmodifiableList(value));
        }
        this.aliases = aliasesBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.aliases.size());
        for (ObjectObjectCursor<String, List<AliasMetaData>> objectObjectCursor : this.aliases) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((List)objectObjectCursor.value).size());
            for (AliasMetaData aliasMetaData : (List)objectObjectCursor.value) {
                aliasMetaData.writeTo(out);
            }
        }
    }
}

