/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.ssl.util;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.util.internal.ThreadLocalRandom;

final class ThreadLocalInsecureRandom
extends SecureRandom {
    private static final long serialVersionUID = -8209473337192526191L;
    private static final SecureRandom INSTANCE = new ThreadLocalInsecureRandom();

    static SecureRandom current() {
        return INSTANCE;
    }

    private ThreadLocalInsecureRandom() {
    }

    public String getAlgorithm() {
        return "insecure";
    }

    public void setSeed(byte[] seed) {
    }

    public void setSeed(long seed) {
    }

    public void nextBytes(byte[] bytes) {
        ThreadLocalInsecureRandom.random().nextBytes(bytes);
    }

    public byte[] generateSeed(int numBytes) {
        byte[] seed = new byte[numBytes];
        ThreadLocalInsecureRandom.random().nextBytes(seed);
        return seed;
    }

    public int nextInt() {
        return ThreadLocalInsecureRandom.random().nextInt();
    }

    public int nextInt(int n) {
        return ThreadLocalInsecureRandom.random().nextInt(n);
    }

    public boolean nextBoolean() {
        return ThreadLocalInsecureRandom.random().nextBoolean();
    }

    public long nextLong() {
        return ThreadLocalInsecureRandom.random().nextLong();
    }

    public float nextFloat() {
        return ThreadLocalInsecureRandom.random().nextFloat();
    }

    public double nextDouble() {
        return ThreadLocalInsecureRandom.random().nextDouble();
    }

    public double nextGaussian() {
        return ThreadLocalInsecureRandom.random().nextGaussian();
    }

    private static Random random() {
        return ThreadLocalRandom.current();
    }
}

