/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.ipfilter;

import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.ipfilter.IpFilterRule;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.ipfilter.IpSubnetFilterRule;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.ipfilter.PatternRule;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.logging.InternalLogger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpFilterRuleList
extends ArrayList<IpFilterRule> {
    private static final long serialVersionUID = -6164162941749588780L;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IpFilterRuleList.class);

    public IpFilterRuleList(String rules) {
        this.parseRules(rules);
    }

    private void parseRules(String rules) {
        String[] ruless;
        for (String rule : ruless = StringUtil.split(rules, ',')) {
            this.parseRule(rule.trim());
        }
    }

    private void parseRule(String rule) {
        if (rule == null || rule.length() == 0) {
            return;
        }
        if (!rule.startsWith("+") && !rule.startsWith("-")) {
            if (logger.isErrorEnabled()) {
                logger.error("syntax error in ip filter rule:" + rule);
            }
            return;
        }
        boolean allow = rule.startsWith("+");
        if (rule.charAt(1) == 'n' || rule.charAt(1) == 'i') {
            this.add(new PatternRule(allow, rule.substring(1)));
        } else if (rule.charAt(1) == 'c') {
            try {
                this.add(new IpSubnetFilterRule(allow, rule.substring(3)));
            }
            catch (UnknownHostException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("error parsing ip filter " + rule, e);
                }
            }
        } else if (logger.isErrorEnabled()) {
            logger.error("syntax error in ip filter rule:" + rule);
        }
    }
}

