/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.socks;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.Channel;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.socks.SocksAuthRequest;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.socks.SocksCommonUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.socks.SocksMessage;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.socks.SocksRequest;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocksAuthRequestDecoder
extends ReplayingDecoder<State> {
    private SocksMessage.SubnegotiationVersion version;
    private int fieldLength;
    private String username;
    private String password;
    private SocksRequest msg = SocksCommonUtils.UNKNOWN_SOCKS_REQUEST;

    public SocksAuthRequestDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.SubnegotiationVersion.fromByte(buffer.readByte());
                if (this.version != SocksMessage.SubnegotiationVersion.AUTH_PASSWORD) break;
                this.checkpoint(State.READ_USERNAME);
            }
            case READ_USERNAME: {
                this.fieldLength = buffer.readByte();
                this.username = buffer.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                this.checkpoint(State.READ_PASSWORD);
            }
            case READ_PASSWORD: {
                this.fieldLength = buffer.readByte();
                this.password = buffer.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                this.msg = new SocksAuthRequest(this.username, this.password);
            }
        }
        ctx.getPipeline().remove(this);
        return this.msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_USERNAME,
        READ_PASSWORD;

    }
}

