/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util;

import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.UnicodeUtil;

public class BytesRefBuilder {
    private final BytesRef ref = new BytesRef();

    public byte[] bytes() {
        return this.ref.bytes;
    }

    public int length() {
        return this.ref.length;
    }

    public void setLength(int length) {
        this.ref.length = length;
    }

    public byte byteAt(int offset) {
        return this.ref.bytes[offset];
    }

    public void setByteAt(int offset, byte b) {
        this.ref.bytes[offset] = b;
    }

    public void grow(int capacity) {
        this.ref.bytes = ArrayUtil.grow(this.ref.bytes, capacity);
    }

    public void append(byte b) {
        this.grow(this.ref.length + 1);
        this.ref.bytes[this.ref.length++] = b;
    }

    public void append(byte[] b, int off, int len) {
        this.grow(this.ref.length + len);
        System.arraycopy(b, off, this.ref.bytes, this.ref.length, len);
        this.ref.length += len;
    }

    public void append(BytesRef ref) {
        this.append(ref.bytes, ref.offset, ref.length);
    }

    public void append(BytesRefBuilder builder) {
        this.append(builder.get());
    }

    public void clear() {
        this.setLength(0);
    }

    public void copyBytes(byte[] b, int off, int len) {
        this.clear();
        this.append(b, off, len);
    }

    public void copyBytes(BytesRef ref) {
        this.clear();
        this.append(ref);
    }

    public void copyBytes(BytesRefBuilder builder) {
        this.clear();
        this.append(builder);
    }

    public void copyChars(CharSequence text) {
        this.copyChars(text, 0, text.length());
    }

    public void copyChars(CharSequence text, int off, int len) {
        this.grow(len * 3);
        this.ref.length = UnicodeUtil.UTF16toUTF8(text, off, len, this.ref.bytes);
    }

    public void copyChars(char[] text, int off, int len) {
        this.grow(len * 3);
        this.ref.length = UnicodeUtil.UTF16toUTF8(text, off, len, this.ref.bytes);
    }

    public BytesRef get() {
        assert (this.ref.offset == 0) : "Modifying the offset of the returned ref is illegal";
        return this.ref;
    }

    public BytesRef toBytesRef() {
        return new BytesRef(Arrays.copyOf(this.ref.bytes, this.ref.length));
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

