/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.GeoBasePolygon;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.Membership;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.Plane;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.Vector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.XYZBounds;

class GeoComplexPolygon
extends GeoBasePolygon {
    private final Tree xTree;
    private final Tree yTree;
    private final Tree zTree;
    private final boolean testPointInSet;
    private final GeoPoint testPoint;
    private final Plane testPointFixedYPlane;
    private final Plane testPointFixedYAbovePlane;
    private final Plane testPointFixedYBelowPlane;
    private final Plane testPointFixedXPlane;
    private final Plane testPointFixedXAbovePlane;
    private final Plane testPointFixedXBelowPlane;
    private final Plane testPointFixedZPlane;
    private final Plane testPointFixedZAbovePlane;
    private final Plane testPointFixedZBelowPlane;
    private final GeoPoint[] edgePoints;
    private final Edge[] shapeStartEdges;

    public GeoComplexPolygon(PlanetModel planetModel, List<List<GeoPoint>> pointsList, GeoPoint testPoint, boolean testPointInSet) {
        super(planetModel);
        this.testPointInSet = testPointInSet;
        this.testPoint = testPoint;
        this.testPointFixedYPlane = new Plane(0.0, 1.0, 0.0, -testPoint.y);
        this.testPointFixedXPlane = new Plane(1.0, 0.0, 0.0, -testPoint.x);
        this.testPointFixedZPlane = new Plane(0.0, 0.0, 1.0, -testPoint.z);
        this.testPointFixedYAbovePlane = new Plane(this.testPointFixedYPlane, true);
        this.testPointFixedYBelowPlane = new Plane(this.testPointFixedYPlane, false);
        this.testPointFixedXAbovePlane = new Plane(this.testPointFixedXPlane, true);
        this.testPointFixedXBelowPlane = new Plane(this.testPointFixedXPlane, false);
        this.testPointFixedZAbovePlane = new Plane(this.testPointFixedZPlane, true);
        this.testPointFixedZBelowPlane = new Plane(this.testPointFixedZPlane, false);
        this.edgePoints = new GeoPoint[pointsList.size()];
        this.shapeStartEdges = new Edge[pointsList.size()];
        ArrayList<Edge> allEdges = new ArrayList<Edge>();
        int edgePointIndex = 0;
        for (List<GeoPoint> shapePoints : pointsList) {
            GeoPoint lastGeoPoint;
            allEdges.ensureCapacity(allEdges.size() + shapePoints.size());
            this.edgePoints[edgePointIndex] = lastGeoPoint = shapePoints.get(shapePoints.size() - 1);
            Edge lastEdge = null;
            Edge firstEdge = null;
            for (GeoPoint thisGeoPoint : shapePoints) {
                Edge edge = new Edge(planetModel, lastGeoPoint, thisGeoPoint);
                allEdges.add(edge);
                if (firstEdge == null) {
                    firstEdge = edge;
                }
                if (lastEdge != null) {
                    lastEdge.next = edge;
                    edge.previous = lastEdge;
                }
                lastEdge = edge;
                lastGeoPoint = thisGeoPoint;
            }
            firstEdge.previous = lastEdge;
            lastEdge.next = firstEdge;
            this.shapeStartEdges[edgePointIndex] = firstEdge;
            ++edgePointIndex;
        }
        this.xTree = new XTree(allEdges);
        this.yTree = new YTree(allEdges);
        this.zTree = new ZTree(allEdges);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        double newDistance;
        double cpDelta2;
        double cpDelta1;
        double tpDelta2;
        double tpDelta1;
        if (this.testPoint.isNumericallyIdentical(x, y, z)) {
            return this.testPointInSet;
        }
        if (this.testPointFixedYPlane.evaluateIsZero(x, y, z)) {
            LinearCrossingEdgeIterator crossingEdgeIterator = new LinearCrossingEdgeIterator(this.testPointFixedYPlane, this.testPointFixedYAbovePlane, this.testPointFixedYBelowPlane, x, y, z);
            if (!this.yTree.traverse(crossingEdgeIterator, this.testPoint.y)) {
                return true;
            }
            return (crossingEdgeIterator.crossingCount & 1) == 0 ? this.testPointInSet : !this.testPointInSet;
        }
        if (this.testPointFixedXPlane.evaluateIsZero(x, y, z)) {
            LinearCrossingEdgeIterator crossingEdgeIterator = new LinearCrossingEdgeIterator(this.testPointFixedXPlane, this.testPointFixedXAbovePlane, this.testPointFixedXBelowPlane, x, y, z);
            if (!this.xTree.traverse(crossingEdgeIterator, this.testPoint.x)) {
                return true;
            }
            return (crossingEdgeIterator.crossingCount & 1) == 0 ? this.testPointInSet : !this.testPointInSet;
        }
        if (this.testPointFixedZPlane.evaluateIsZero(x, y, z)) {
            LinearCrossingEdgeIterator crossingEdgeIterator = new LinearCrossingEdgeIterator(this.testPointFixedZPlane, this.testPointFixedZAbovePlane, this.testPointFixedZBelowPlane, x, y, z);
            if (!this.zTree.traverse(crossingEdgeIterator, this.testPoint.z)) {
                return true;
            }
            return (crossingEdgeIterator.crossingCount & 1) == 0 ? this.testPointInSet : !this.testPointInSet;
        }
        Plane travelPlaneFixedX = new Plane(1.0, 0.0, 0.0, -x);
        Plane travelPlaneFixedY = new Plane(0.0, 1.0, 0.0, -y);
        Plane travelPlaneFixedZ = new Plane(0.0, 0.0, 1.0, -z);
        GeoPoint[] XIntersectionsY = travelPlaneFixedX.findIntersections(this.planetModel, this.testPointFixedYPlane, new Membership[0]);
        GeoPoint[] XIntersectionsZ = travelPlaneFixedX.findIntersections(this.planetModel, this.testPointFixedZPlane, new Membership[0]);
        GeoPoint[] YIntersectionsX = travelPlaneFixedY.findIntersections(this.planetModel, this.testPointFixedXPlane, new Membership[0]);
        GeoPoint[] YIntersectionsZ = travelPlaneFixedY.findIntersections(this.planetModel, this.testPointFixedZPlane, new Membership[0]);
        GeoPoint[] ZIntersectionsX = travelPlaneFixedZ.findIntersections(this.planetModel, this.testPointFixedXPlane, new Membership[0]);
        GeoPoint[] ZIntersectionsY = travelPlaneFixedZ.findIntersections(this.planetModel, this.testPointFixedYPlane, new Membership[0]);
        double bestDistance = Double.POSITIVE_INFINITY;
        double firstLegValue = 0.0;
        double secondLegValue = 0.0;
        Plane firstLegPlane = null;
        Plane firstLegAbovePlane = null;
        Plane firstLegBelowPlane = null;
        Plane secondLegPlane = null;
        Tree firstLegTree = null;
        Tree secondLegTree = null;
        GeoPoint intersectionPoint = null;
        for (GeoPoint p : XIntersectionsY) {
            tpDelta1 = this.testPoint.x - p.x;
            tpDelta2 = this.testPoint.z - p.z;
            cpDelta1 = y - p.y;
            cpDelta2 = z - p.z;
            newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
            if (!(newDistance < bestDistance)) continue;
            bestDistance = newDistance;
            firstLegValue = this.testPoint.y;
            secondLegValue = x;
            firstLegPlane = this.testPointFixedYPlane;
            firstLegAbovePlane = this.testPointFixedYAbovePlane;
            firstLegBelowPlane = this.testPointFixedYBelowPlane;
            secondLegPlane = travelPlaneFixedX;
            firstLegTree = this.yTree;
            secondLegTree = this.xTree;
            intersectionPoint = p;
        }
        for (GeoPoint p : XIntersectionsZ) {
            tpDelta1 = this.testPoint.x - p.x;
            tpDelta2 = this.testPoint.y - p.y;
            cpDelta1 = y - p.y;
            cpDelta2 = z - p.z;
            newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
            if (!(newDistance < bestDistance)) continue;
            bestDistance = newDistance;
            firstLegValue = this.testPoint.z;
            secondLegValue = x;
            firstLegPlane = this.testPointFixedZPlane;
            firstLegAbovePlane = this.testPointFixedZAbovePlane;
            firstLegBelowPlane = this.testPointFixedZBelowPlane;
            secondLegPlane = travelPlaneFixedX;
            firstLegTree = this.zTree;
            secondLegTree = this.xTree;
            intersectionPoint = p;
        }
        for (GeoPoint p : YIntersectionsX) {
            tpDelta1 = this.testPoint.y - p.y;
            tpDelta2 = this.testPoint.z - p.z;
            cpDelta1 = x - p.x;
            cpDelta2 = z - p.z;
            newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
            if (!(newDistance < bestDistance)) continue;
            bestDistance = newDistance;
            firstLegValue = this.testPoint.x;
            secondLegValue = y;
            firstLegPlane = this.testPointFixedXPlane;
            firstLegAbovePlane = this.testPointFixedXAbovePlane;
            firstLegBelowPlane = this.testPointFixedXBelowPlane;
            secondLegPlane = travelPlaneFixedY;
            firstLegTree = this.xTree;
            secondLegTree = this.yTree;
            intersectionPoint = p;
        }
        for (GeoPoint p : YIntersectionsZ) {
            tpDelta1 = this.testPoint.x - p.x;
            tpDelta2 = this.testPoint.y - p.y;
            cpDelta1 = x - p.x;
            cpDelta2 = z - p.z;
            newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
            if (!(newDistance < bestDistance)) continue;
            bestDistance = newDistance;
            firstLegValue = this.testPoint.z;
            secondLegValue = y;
            firstLegPlane = this.testPointFixedZPlane;
            firstLegAbovePlane = this.testPointFixedZAbovePlane;
            firstLegBelowPlane = this.testPointFixedZBelowPlane;
            secondLegPlane = travelPlaneFixedY;
            firstLegTree = this.zTree;
            secondLegTree = this.yTree;
            intersectionPoint = p;
        }
        for (GeoPoint p : ZIntersectionsX) {
            tpDelta1 = this.testPoint.y - p.y;
            tpDelta2 = this.testPoint.z - p.z;
            cpDelta1 = y - p.y;
            cpDelta2 = x - p.x;
            newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
            if (!(newDistance < bestDistance)) continue;
            bestDistance = newDistance;
            firstLegValue = this.testPoint.x;
            secondLegValue = z;
            firstLegPlane = this.testPointFixedXPlane;
            firstLegAbovePlane = this.testPointFixedXAbovePlane;
            firstLegBelowPlane = this.testPointFixedXBelowPlane;
            secondLegPlane = travelPlaneFixedZ;
            firstLegTree = this.xTree;
            secondLegTree = this.zTree;
            intersectionPoint = p;
        }
        for (GeoPoint p : ZIntersectionsY) {
            tpDelta1 = this.testPoint.x - p.x;
            tpDelta2 = this.testPoint.z - p.z;
            cpDelta1 = y - p.y;
            cpDelta2 = x - p.x;
            newDistance = tpDelta1 * tpDelta1 + tpDelta2 * tpDelta2 + cpDelta1 * cpDelta1 + cpDelta2 * cpDelta2;
            if (!(newDistance < bestDistance)) continue;
            bestDistance = newDistance;
            firstLegValue = this.testPoint.y;
            secondLegValue = z;
            firstLegPlane = this.testPointFixedYPlane;
            firstLegAbovePlane = this.testPointFixedYAbovePlane;
            firstLegBelowPlane = this.testPointFixedYBelowPlane;
            secondLegPlane = travelPlaneFixedZ;
            firstLegTree = this.yTree;
            secondLegTree = this.zTree;
            intersectionPoint = p;
        }
        assert (bestDistance > 0.0) : "Best distance should not be zero unless on single plane";
        assert (bestDistance < Double.POSITIVE_INFINITY) : "Couldn't find an intersection point of any kind";
        DualCrossingEdgeIterator edgeIterator = new DualCrossingEdgeIterator(firstLegPlane, firstLegAbovePlane, firstLegBelowPlane, secondLegPlane, x, y, z, intersectionPoint);
        if (!firstLegTree.traverse(edgeIterator, firstLegValue)) {
            return true;
        }
        edgeIterator.setSecondLeg();
        if (!secondLegTree.traverse(edgeIterator, secondLegValue)) {
            return true;
        }
        return (edgeIterator.crossingCount & 1) == 0 ? this.testPointInSet : !this.testPointInSet;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        IntersectorEdgeIterator intersector = new IntersectorEdgeIterator(p, notablePoints, bounds);
        XYZBounds xyzBounds = new XYZBounds();
        p.recordBounds(this.planetModel, xyzBounds, bounds);
        for (GeoPoint point : notablePoints) {
            xyzBounds.addPoint(point);
        }
        double xDelta = xyzBounds.getMaximumX() - xyzBounds.getMinimumX();
        double yDelta = xyzBounds.getMaximumY() - xyzBounds.getMinimumY();
        double zDelta = xyzBounds.getMaximumZ() - xyzBounds.getMinimumZ();
        if (xDelta <= yDelta && xDelta <= zDelta) {
            return !this.xTree.traverse(intersector, xyzBounds.getMinimumX(), xyzBounds.getMaximumX());
        }
        if (yDelta <= xDelta && yDelta <= zDelta) {
            return !this.yTree.traverse(intersector, xyzBounds.getMinimumY(), xyzBounds.getMaximumY());
        }
        if (zDelta <= xDelta && zDelta <= yDelta) {
            return !this.zTree.traverse(intersector, xyzBounds.getMinimumZ(), xyzBounds.getMaximumZ());
        }
        return true;
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        Edge[] edgeArray = this.shapeStartEdges;
        int n = edgeArray.length;
        for (int i = 0; i < n; ++i) {
            Edge startEdge;
            Edge currentEdge = startEdge = edgeArray[i];
            do {
                bounds.addPoint(currentEdge.startPoint);
                bounds.addPlane(this.planetModel, currentEdge.plane, currentEdge.startPlane, currentEdge.endPlane);
            } while ((currentEdge = currentEdge.next) != startEdge);
        }
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double minimumDistance = Double.POSITIVE_INFINITY;
        Edge[] edgeArray = this.shapeStartEdges;
        int n = edgeArray.length;
        for (int i = 0; i < n; ++i) {
            Edge shapeStartEdge;
            Edge shapeEdge = shapeStartEdge = edgeArray[i];
            do {
                double newDist;
                if ((newDist = distanceStyle.computeDistance(shapeEdge.startPoint, x, y, z)) < minimumDistance) {
                    minimumDistance = newDist;
                }
                Membership[] membershipArray = new Membership[]{shapeEdge.startPlane, shapeEdge.endPlane};
                double newPlaneDist = distanceStyle.computeDistance(this.planetModel, shapeEdge.plane, x, y, z, membershipArray);
                if (!(newPlaneDist < minimumDistance)) continue;
                minimumDistance = newPlaneDist;
            } while ((shapeEdge = shapeEdge.next) != shapeStartEdge);
        }
        return minimumDistance;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        StringBuilder edgeDescription = new StringBuilder();
        for (Edge shapeStartEdge : this.shapeStartEdges) {
            GeoComplexPolygon.fillInEdgeDescription(edgeDescription, shapeStartEdge);
        }
        return "GeoComplexPolygon: {planetmodel=" + this.planetModel + ", number of shapes=" + this.shapeStartEdges.length + ", address=" + Integer.toHexString(this.hashCode()) + ", testPoint=" + this.testPoint + ", testPointInSet=" + this.testPointInSet + ", shapes={" + edgeDescription + "}}";
    }

    private static void fillInEdgeDescription(StringBuilder description, Edge startEdge) {
        description.append(" {");
        Edge currentEdge = startEdge;
        int edgeCounter = 0;
        while (true) {
            if (edgeCounter > 0) {
                description.append(", ");
            }
            if (edgeCounter >= 20) {
                description.append("...");
                break;
            }
            description.append(currentEdge.startPoint);
            currentEdge = currentEdge.next;
            if (currentEdge == startEdge) break;
            ++edgeCounter;
        }
    }

    private class DualCrossingEdgeIterator
    implements EdgeIterator {
        private boolean isSecondLeg = false;
        private final Plane testPointPlane;
        private final Plane testPointAbovePlane;
        private final Plane testPointBelowPlane;
        private final Plane travelPlane;
        private final double thePointX;
        private final double thePointY;
        private final double thePointZ;
        private final GeoPoint intersectionPoint;
        private final SidedPlane testPointCutoffPlane;
        private final SidedPlane checkPointCutoffPlane;
        private final SidedPlane testPointOtherCutoffPlane;
        private final SidedPlane checkPointOtherCutoffPlane;
        private boolean computedInsideOutside = false;
        private Plane testPointInsidePlane;
        private Plane testPointOutsidePlane;
        private Plane travelInsidePlane;
        private Plane travelOutsidePlane;
        private SidedPlane insideTestPointCutoffPlane;
        private SidedPlane insideTravelCutoffPlane;
        public int crossingCount = 0;

        public DualCrossingEdgeIterator(Plane testPointPlane, Plane testPointAbovePlane, Plane testPointBelowPlane, Plane travelPlane, double thePointX, double thePointY, double thePointZ, GeoPoint intersectionPoint) {
            this.testPointPlane = testPointPlane;
            this.testPointAbovePlane = testPointAbovePlane;
            this.testPointBelowPlane = testPointBelowPlane;
            this.travelPlane = travelPlane;
            this.thePointX = thePointX;
            this.thePointY = thePointY;
            this.thePointZ = thePointZ;
            this.intersectionPoint = intersectionPoint;
            assert (travelPlane.evaluateIsZero(intersectionPoint)) : "intersection point must be on travel plane";
            assert (testPointPlane.evaluateIsZero(intersectionPoint)) : "intersection point must be on test point plane";
            assert (!GeoComplexPolygon.this.testPoint.isNumericallyIdentical(intersectionPoint)) : "test point is the same as intersection point";
            assert (!intersectionPoint.isNumericallyIdentical(thePointX, thePointY, thePointZ)) : "check point is same is intersection point";
            this.testPointCutoffPlane = new SidedPlane((Vector)intersectionPoint, (Vector)testPointPlane, GeoComplexPolygon.this.testPoint);
            this.checkPointCutoffPlane = new SidedPlane(intersectionPoint, travelPlane, thePointX, thePointY, thePointZ);
            this.testPointOtherCutoffPlane = new SidedPlane((Vector)GeoComplexPolygon.this.testPoint, (Vector)testPointPlane, intersectionPoint);
            this.checkPointOtherCutoffPlane = new SidedPlane(thePointX, thePointY, thePointZ, (Vector)travelPlane, intersectionPoint);
            assert (this.testPointCutoffPlane.isWithin(intersectionPoint)) : "intersection must be within testPointCutoffPlane";
            assert (this.testPointOtherCutoffPlane.isWithin(intersectionPoint)) : "intersection must be within testPointOtherCutoffPlane";
            assert (this.checkPointCutoffPlane.isWithin(intersectionPoint)) : "intersection must be within checkPointCutoffPlane";
            assert (this.checkPointOtherCutoffPlane.isWithin(intersectionPoint)) : "intersection must be within checkPointOtherCutoffPlane";
        }

        protected void computeInsideOutside() {
            if (!this.computedInsideOutside) {
                SidedPlane intersectionBound1 = new SidedPlane((Vector)GeoComplexPolygon.this.testPoint, (Vector)this.travelPlane, this.travelPlane.D);
                SidedPlane intersectionBound2 = new SidedPlane(this.thePointX, this.thePointY, this.thePointZ, (Vector)this.testPointPlane, this.testPointPlane.D);
                assert (intersectionBound1.isWithin(this.intersectionPoint)) : "intersection must be within intersectionBound1";
                assert (intersectionBound2.isWithin(this.intersectionPoint)) : "intersection must be within intersectionBound2";
                Plane travelAbovePlane = new Plane(this.travelPlane, true);
                Plane travelBelowPlane = new Plane(this.travelPlane, false);
                GeoPoint[] aboveAbove = travelAbovePlane.findIntersections(GeoComplexPolygon.this.planetModel, this.testPointAbovePlane, intersectionBound1, intersectionBound2);
                assert (aboveAbove != null) : "Above + above should not be coplanar";
                GeoPoint[] aboveBelow = travelAbovePlane.findIntersections(GeoComplexPolygon.this.planetModel, this.testPointBelowPlane, intersectionBound1, intersectionBound2);
                assert (aboveBelow != null) : "Above + below should not be coplanar";
                GeoPoint[] belowBelow = travelBelowPlane.findIntersections(GeoComplexPolygon.this.planetModel, this.testPointBelowPlane, intersectionBound1, intersectionBound2);
                assert (belowBelow != null) : "Below + below should not be coplanar";
                GeoPoint[] belowAbove = travelBelowPlane.findIntersections(GeoComplexPolygon.this.planetModel, this.testPointAbovePlane, intersectionBound1, intersectionBound2);
                assert (belowAbove != null) : "Below + above should not be coplanar";
                assert ((aboveAbove.length > 0 ? 1 : 0) + (aboveBelow.length > 0 ? 1 : 0) + (belowBelow.length > 0 ? 1 : 0) + (belowAbove.length > 0 ? 1 : 0) == 1) : "Can be exactly one inside point, instead was: aa=" + aboveAbove.length + " ab=" + aboveBelow.length + " bb=" + belowBelow.length + " ba=" + belowAbove.length;
                if (aboveAbove.length > 0) {
                    this.travelInsidePlane = travelAbovePlane;
                    this.testPointInsidePlane = this.testPointAbovePlane;
                    this.travelOutsidePlane = travelBelowPlane;
                    this.testPointOutsidePlane = this.testPointBelowPlane;
                } else if (aboveBelow.length > 0) {
                    this.travelInsidePlane = travelAbovePlane;
                    this.testPointInsidePlane = this.testPointBelowPlane;
                    this.travelOutsidePlane = travelBelowPlane;
                    this.testPointOutsidePlane = this.testPointAbovePlane;
                } else if (belowBelow.length > 0) {
                    this.travelInsidePlane = travelBelowPlane;
                    this.testPointInsidePlane = this.testPointBelowPlane;
                    this.travelOutsidePlane = travelAbovePlane;
                    this.testPointOutsidePlane = this.testPointAbovePlane;
                } else {
                    this.travelInsidePlane = travelBelowPlane;
                    this.testPointInsidePlane = this.testPointAbovePlane;
                    this.travelOutsidePlane = travelAbovePlane;
                    this.testPointOutsidePlane = this.testPointBelowPlane;
                }
                this.insideTravelCutoffPlane = new SidedPlane(this.thePointX, this.thePointY, this.thePointZ, (Vector)this.testPointInsidePlane, this.testPointInsidePlane.D);
                this.insideTestPointCutoffPlane = new SidedPlane((Vector)GeoComplexPolygon.this.testPoint, (Vector)this.travelInsidePlane, this.travelInsidePlane.D);
                this.computedInsideOutside = true;
            }
        }

        public void setSecondLeg() {
            this.isSecondLeg = true;
        }

        @Override
        public boolean matches(Edge edge) {
            if (edge.plane.evaluateIsZero(this.thePointX, this.thePointY, this.thePointZ) && edge.startPlane.isWithin(this.thePointX, this.thePointY, this.thePointZ) && edge.endPlane.isWithin(this.thePointX, this.thePointY, this.thePointZ)) {
                return false;
            }
            GeoPoint[] crossingPoints = this.isSecondLeg ? this.travelPlane.findCrossings(GeoComplexPolygon.this.planetModel, edge.plane, this.checkPointCutoffPlane, this.checkPointOtherCutoffPlane, edge.startPlane, edge.endPlane) : this.testPointPlane.findCrossings(GeoComplexPolygon.this.planetModel, edge.plane, this.testPointCutoffPlane, this.testPointOtherCutoffPlane, edge.startPlane, edge.endPlane);
            if (crossingPoints != null) {
                for (GeoPoint crossingPoint : crossingPoints) {
                    this.countCrossingPoint(crossingPoint, edge);
                }
            }
            return true;
        }

        private void countCrossingPoint(GeoPoint crossingPoint, Edge edge) {
            GeoPoint[] insideTravelPlaneIntersections;
            GeoPoint[] insideTestPointPlaneIntersections;
            if (crossingPoint.isNumericallyIdentical(this.intersectionPoint) && this.isSecondLeg) {
                GeoPoint[] firstLegCrossings;
                for (GeoPoint firstLegCrossing : firstLegCrossings = this.testPointPlane.findCrossings(GeoComplexPolygon.this.planetModel, edge.plane, this.testPointCutoffPlane, this.testPointOtherCutoffPlane, edge.startPlane, edge.endPlane)) {
                    if (!firstLegCrossing.isNumericallyIdentical(this.intersectionPoint)) continue;
                    return;
                }
            }
            if (crossingPoint.isNumericallyIdentical(edge.startPoint)) {
                boolean assessEdgeInside;
                GeoPoint[] assessOutsideTravelIntersections;
                GeoPoint[] assessOutsideTestPointIntersections;
                GeoPoint[] assessInsideTravelIntersections;
                GeoPoint[] assessInsideTestPointIntersections;
                this.computeInsideOutside();
                insideTestPointPlaneIntersections = this.testPointInsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane, this.insideTestPointCutoffPlane);
                insideTravelPlaneIntersections = this.travelInsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane, this.insideTravelCutoffPlane);
                GeoPoint[] outsideTestPointPlaneIntersections = this.testPointOutsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane);
                GeoPoint[] outsideTravelPlaneIntersections = this.travelOutsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane);
                assert (insideTestPointPlaneIntersections.length + insideTravelPlaneIntersections.length <= 0 || outsideTestPointPlaneIntersections.length + outsideTravelPlaneIntersections.length <= 0) : "edge that ends in a crossing can't both up and down";
                if (insideTestPointPlaneIntersections.length + insideTravelPlaneIntersections.length == 0 && outsideTestPointPlaneIntersections.length + outsideTravelPlaneIntersections.length == 0) {
                    return;
                }
                boolean edgeCrossesInside = insideTestPointPlaneIntersections.length + insideTravelPlaneIntersections.length > 0;
                Edge assessEdge = edge;
                do {
                    assessEdge = assessEdge.previous;
                    assessInsideTestPointIntersections = this.testPointInsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane, this.insideTestPointCutoffPlane);
                    assessInsideTravelIntersections = this.travelInsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane, this.insideTravelCutoffPlane);
                    assessOutsideTestPointIntersections = this.testPointOutsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane);
                    assessOutsideTravelIntersections = this.travelOutsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane);
                } while (assessInsideTestPointIntersections.length + assessInsideTravelIntersections.length == 0 && assessOutsideTestPointIntersections.length + assessOutsideTravelIntersections.length == 0);
                GeoPoint[] otherCrossingPoints = this.isSecondLeg ? this.travelPlane.findCrossings(GeoComplexPolygon.this.planetModel, assessEdge.plane, this.checkPointCutoffPlane, this.checkPointOtherCutoffPlane, assessEdge.startPlane, assessEdge.endPlane) : this.testPointPlane.findCrossings(GeoComplexPolygon.this.planetModel, assessEdge.plane, this.testPointCutoffPlane, this.testPointOtherCutoffPlane, assessEdge.startPlane, assessEdge.endPlane);
                for (GeoPoint otherCrossingPoint : otherCrossingPoints) {
                    if (!otherCrossingPoint.isNumericallyIdentical(assessEdge.endPoint)) continue;
                    return;
                }
                boolean bl = assessEdgeInside = assessInsideTestPointIntersections.length + assessInsideTravelIntersections.length > 0;
                if (assessEdgeInside != edgeCrossesInside) {
                    ++this.crossingCount;
                }
            } else if (crossingPoint.isNumericallyIdentical(edge.endPoint)) {
                boolean assessEdgeInside;
                GeoPoint[] assessOutsideTravelIntersections;
                GeoPoint[] assessOutsideTestPointIntersections;
                GeoPoint[] assessInsideTravelIntersections;
                GeoPoint[] assessInsideTestPointIntersections;
                this.computeInsideOutside();
                insideTestPointPlaneIntersections = this.testPointInsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane, this.insideTestPointCutoffPlane);
                insideTravelPlaneIntersections = this.travelInsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane, this.insideTravelCutoffPlane);
                GeoPoint[] outsideTestPointPlaneIntersections = this.testPointOutsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane);
                GeoPoint[] outsideTravelPlaneIntersections = this.travelOutsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane);
                if (insideTestPointPlaneIntersections.length + insideTravelPlaneIntersections.length == 0 && outsideTestPointPlaneIntersections.length + outsideTravelPlaneIntersections.length == 0) {
                    return;
                }
                boolean edgeCrossesInside = insideTestPointPlaneIntersections.length + insideTravelPlaneIntersections.length > 0;
                Edge assessEdge = edge;
                do {
                    assessEdge = assessEdge.next;
                    assessInsideTestPointIntersections = this.testPointInsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane, this.insideTestPointCutoffPlane);
                    assessInsideTravelIntersections = this.travelInsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane, this.insideTravelCutoffPlane);
                    assessOutsideTestPointIntersections = this.testPointOutsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane);
                    assessOutsideTravelIntersections = this.travelOutsidePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane);
                    assert (assessInsideTestPointIntersections.length + assessInsideTravelIntersections.length <= 0 || assessOutsideTestPointIntersections.length + assessOutsideTravelIntersections.length <= 0) : "assess edge that ends in a crossing can't both up and down";
                } while (assessInsideTestPointIntersections.length + assessInsideTravelIntersections.length == 0 && assessOutsideTestPointIntersections.length + assessOutsideTravelIntersections.length == 0);
                boolean bl = assessEdgeInside = assessInsideTestPointIntersections.length + assessInsideTravelIntersections.length > 0;
                if (assessEdgeInside != edgeCrossesInside) {
                    ++this.crossingCount;
                }
            } else {
                ++this.crossingCount;
            }
        }
    }

    private class LinearCrossingEdgeIterator
    implements EdgeIterator {
        private final Plane plane;
        private final Plane abovePlane;
        private final Plane belowPlane;
        private final Membership bound1;
        private final Membership bound2;
        private final double thePointX;
        private final double thePointY;
        private final double thePointZ;
        public int crossingCount = 0;

        public LinearCrossingEdgeIterator(Plane plane, Plane abovePlane, Plane belowPlane, double thePointX, double thePointY, double thePointZ) {
            this.plane = plane;
            this.abovePlane = abovePlane;
            this.belowPlane = belowPlane;
            this.bound1 = new SidedPlane(thePointX, thePointY, thePointZ, (Vector)plane, GeoComplexPolygon.this.testPoint);
            this.bound2 = new SidedPlane(GeoComplexPolygon.this.testPoint, plane, thePointX, thePointY, thePointZ);
            this.thePointX = thePointX;
            this.thePointY = thePointY;
            this.thePointZ = thePointZ;
        }

        @Override
        public boolean matches(Edge edge) {
            if (edge.plane.evaluateIsZero(this.thePointX, this.thePointY, this.thePointZ) && edge.startPlane.isWithin(this.thePointX, this.thePointY, this.thePointZ) && edge.endPlane.isWithin(this.thePointX, this.thePointY, this.thePointZ)) {
                return false;
            }
            GeoPoint[] crossingPoints = this.plane.findCrossings(GeoComplexPolygon.this.planetModel, edge.plane, this.bound1, this.bound2, edge.startPlane, edge.endPlane);
            if (crossingPoints != null) {
                for (GeoPoint crossingPoint : crossingPoints) {
                    this.countCrossingPoint(crossingPoint, edge);
                }
            }
            return true;
        }

        private void countCrossingPoint(GeoPoint crossingPoint, Edge edge) {
            if (crossingPoint.isNumericallyIdentical(edge.startPoint)) {
                boolean assessEdgeAbove;
                GeoPoint[] otherCrossingPoints;
                GeoPoint[] assessBelowIntersections;
                GeoPoint[] assessAboveIntersections;
                GeoPoint[] aboveIntersections = this.abovePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane);
                GeoPoint[] belowIntersections = this.belowPlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane);
                assert (aboveIntersections.length <= 0 || belowIntersections.length <= 0) : "edge that ends in a crossing can't both up and down";
                if (aboveIntersections.length == 0 && belowIntersections.length == 0) {
                    return;
                }
                boolean edgeCrossesAbove = aboveIntersections.length > 0;
                Edge assessEdge = edge;
                do {
                    assessEdge = assessEdge.previous;
                    assessAboveIntersections = this.abovePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane);
                    assessBelowIntersections = this.belowPlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane);
                    assert (assessAboveIntersections.length <= 0 || assessBelowIntersections.length <= 0) : "assess edge that ends in a crossing can't both up and down";
                } while (assessAboveIntersections.length == 0 && assessBelowIntersections.length == 0);
                for (GeoPoint otherCrossingPoint : otherCrossingPoints = this.plane.findCrossings(GeoComplexPolygon.this.planetModel, assessEdge.plane, this.bound1, this.bound2, assessEdge.startPlane, assessEdge.endPlane)) {
                    if (!otherCrossingPoint.isNumericallyIdentical(assessEdge.endPoint)) continue;
                    return;
                }
                boolean bl = assessEdgeAbove = assessAboveIntersections.length > 0;
                if (assessEdgeAbove != edgeCrossesAbove) {
                    ++this.crossingCount;
                }
            } else if (crossingPoint.isNumericallyIdentical(edge.endPoint)) {
                boolean assessEdgeAbove;
                GeoPoint[] assessBelowIntersections;
                GeoPoint[] assessAboveIntersections;
                GeoPoint[] aboveIntersections = this.abovePlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane);
                GeoPoint[] belowIntersections = this.belowPlane.findIntersections(GeoComplexPolygon.this.planetModel, edge.plane, edge.startPlane, edge.endPlane);
                assert (aboveIntersections.length <= 0 || belowIntersections.length <= 0) : "edge that ends in a crossing can't both up and down";
                if (aboveIntersections.length == 0 && belowIntersections.length == 0) {
                    return;
                }
                boolean edgeCrossesAbove = aboveIntersections.length > 0;
                Edge assessEdge = edge;
                do {
                    assessEdge = assessEdge.next;
                    assessAboveIntersections = this.abovePlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane);
                    assessBelowIntersections = this.belowPlane.findIntersections(GeoComplexPolygon.this.planetModel, assessEdge.plane, assessEdge.startPlane, assessEdge.endPlane);
                    assert (assessAboveIntersections.length <= 0 || assessBelowIntersections.length <= 0) : "assess edge that ends in a crossing can't both up and down";
                } while (assessAboveIntersections.length == 0 && assessBelowIntersections.length == 0);
                boolean bl = assessEdgeAbove = assessAboveIntersections.length > 0;
                if (assessEdgeAbove != edgeCrossesAbove) {
                    ++this.crossingCount;
                }
            } else {
                ++this.crossingCount;
            }
        }
    }

    private class IntersectorEdgeIterator
    implements EdgeIterator {
        private final Plane plane;
        private final GeoPoint[] notablePoints;
        private final Membership[] bounds;

        public IntersectorEdgeIterator(Plane plane, GeoPoint[] notablePoints, Membership ... bounds) {
            this.plane = plane;
            this.notablePoints = notablePoints;
            this.bounds = bounds;
        }

        @Override
        public boolean matches(Edge edge) {
            return !this.plane.intersects(GeoComplexPolygon.this.planetModel, edge.plane, this.notablePoints, edge.notablePoints, this.bounds, edge.startPlane, edge.endPlane);
        }
    }

    private static class XTree
    extends Tree {
        public XTree(List<Edge> allEdges) {
            super(allEdges);
        }

        @Override
        protected double getMinimum(Edge edge) {
            return edge.planeBounds.getMinimumX();
        }

        @Override
        protected double getMaximum(Edge edge) {
            return edge.planeBounds.getMaximumX();
        }
    }

    private static class YTree
    extends Tree {
        public YTree(List<Edge> allEdges) {
            super(allEdges);
        }

        @Override
        protected double getMinimum(Edge edge) {
            return edge.planeBounds.getMinimumY();
        }

        @Override
        protected double getMaximum(Edge edge) {
            return edge.planeBounds.getMaximumY();
        }
    }

    private static class ZTree
    extends Tree {
        public Node rootNode = null;

        public ZTree(List<Edge> allEdges) {
            super(allEdges);
        }

        @Override
        protected double getMinimum(Edge edge) {
            return edge.planeBounds.getMinimumZ();
        }

        @Override
        protected double getMaximum(Edge edge) {
            return edge.planeBounds.getMaximumZ();
        }
    }

    private static abstract class Tree {
        private final Node rootNode;
        protected static final Edge[] EMPTY_ARRAY = new Edge[0];

        public Tree(List<Edge> allEdges) {
            Node[] edges = new Node[allEdges.size()];
            int i = 0;
            for (Edge edge : allEdges) {
                edges[i++] = new Node(edge, this.getMinimum(edge), this.getMaximum(edge));
            }
            Arrays.sort(edges, (left, right) -> {
                int ret = Double.compare(left.low, right.low);
                if (ret == 0) {
                    ret = Double.compare(left.max, right.max);
                }
                return ret;
            });
            this.rootNode = Tree.createTree(edges, 0, edges.length - 1);
        }

        private static Node createTree(Node[] edges, int low, int high) {
            if (low > high) {
                return null;
            }
            int mid = low + high >>> 1;
            Node newNode = edges[mid];
            newNode.left = Tree.createTree(edges, low, mid - 1);
            newNode.right = Tree.createTree(edges, mid + 1, high);
            if (newNode.left != null) {
                newNode.max = Math.max(newNode.max, newNode.left.max);
            }
            if (newNode.right != null) {
                newNode.max = Math.max(newNode.max, newNode.right.max);
            }
            return newNode;
        }

        protected abstract double getMinimum(Edge var1);

        protected abstract double getMaximum(Edge var1);

        public boolean traverse(EdgeIterator edgeIterator, double value) {
            return this.traverse(edgeIterator, value, value);
        }

        public boolean traverse(EdgeIterator edgeIterator, double minValue, double maxValue) {
            if (this.rootNode == null) {
                return true;
            }
            return this.rootNode.traverse(edgeIterator, minValue, maxValue);
        }
    }

    private static class Node {
        public final Edge edge;
        public final double low;
        public final double high;
        public Node left = null;
        public Node right = null;
        public double max;

        public Node(Edge edge, double minimumValue, double maximumValue) {
            this.edge = edge;
            this.low = minimumValue;
            this.high = maximumValue;
            this.max = maximumValue;
        }

        public boolean traverse(EdgeIterator edgeIterator, double minValue, double maxValue) {
            if (minValue <= this.max) {
                if (minValue <= this.high && maxValue >= this.low && !edgeIterator.matches(this.edge)) {
                    return false;
                }
                if (this.left != null && !this.left.traverse(edgeIterator, minValue, maxValue)) {
                    return false;
                }
                if (this.right != null && minValue >= this.low && !this.right.traverse(edgeIterator, minValue, maxValue)) {
                    return false;
                }
            }
            return true;
        }
    }

    private static interface EdgeIterator {
        public boolean matches(Edge var1);
    }

    private static class Edge {
        public final GeoPoint startPoint;
        public final GeoPoint endPoint;
        public final GeoPoint[] notablePoints;
        public final SidedPlane startPlane;
        public final SidedPlane endPlane;
        public final Plane plane;
        public final XYZBounds planeBounds;
        public Edge previous = null;
        public Edge next = null;

        public Edge(PlanetModel pm, GeoPoint startPoint, GeoPoint endPoint) {
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.notablePoints = new GeoPoint[]{startPoint, endPoint};
            this.plane = new Plane((Vector)startPoint, endPoint);
            this.startPlane = new SidedPlane((Vector)endPoint, (Vector)this.plane, startPoint);
            this.endPlane = new SidedPlane((Vector)startPoint, (Vector)this.plane, endPoint);
            this.planeBounds = new XYZBounds();
            this.planeBounds.addPoint(startPoint);
            this.planeBounds.addPoint(endPoint);
            this.planeBounds.addPlane(pm, this.plane, this.startPlane, this.endPlane);
        }
    }
}

