/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.Geo3DPointDistanceComparator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial3d.geom.GeoDistanceShape;

final class Geo3DPointSortField
extends SortField {
    final GeoDistanceShape distanceShape;

    Geo3DPointSortField(String field, GeoDistanceShape distanceShape) {
        super(field, SortField.Type.CUSTOM);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (distanceShape == null) {
            throw new IllegalArgumentException("distanceShape must not be null");
        }
        this.distanceShape = distanceShape;
        this.setMissingValue(Double.POSITIVE_INFINITY);
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, int sortPos) throws IOException {
        return new Geo3DPointDistanceComparator(this.getField(), this.distanceShape, numHits);
    }

    @Override
    public Double getMissingValue() {
        return (Double)super.getMissingValue();
    }

    @Override
    public void setMissingValue(Object missingValue) {
        if (!Double.valueOf(Double.POSITIVE_INFINITY).equals(missingValue)) {
            throw new IllegalArgumentException("Missing value can only be Double.POSITIVE_INFINITY (missing values last), but got " + missingValue);
        }
        this.missingValue = missingValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = this.distanceShape.hashCode();
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Geo3DPointSortField other = (Geo3DPointSortField)obj;
        return this.distanceShape.equals(other.distanceShape);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<distanceShape:");
        builder.append('\"');
        builder.append(this.getField());
        builder.append('\"');
        builder.append(" shape=");
        builder.append(this.distanceShape);
        if (Double.POSITIVE_INFINITY != this.getMissingValue()) {
            builder.append(" missingValue=" + this.getMissingValue());
        }
        builder.append('>');
        return builder.toString();
    }
}

