/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefArray;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.CharsRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.UnicodeUtil;

final class TokenStreamFromTermVector
extends TokenStream {
    private static final double AVG_CHARS_PER_POSITION = 6.0;
    private static final int INSERTION_SORT_THRESHOLD = 16;
    private final Terms vector;
    private final int filteredDocId;
    private final CharTermAttribute termAttribute;
    private final PositionIncrementAttribute positionIncrementAttribute;
    private final int offsetLength;
    private final float loadFactor;
    private OffsetAttribute offsetAttribute;
    private PayloadAttribute payloadAttribute;
    private CharsRefBuilder termCharsBuilder;
    private BytesRefArray payloadsBytesRefArray;
    private BytesRefBuilder spareBytesRefBuilder;
    private TokenLL firstToken = null;
    private TokenLL incrementToken = null;
    private boolean initialized = false;

    public TokenStreamFromTermVector(Terms vector, int offsetLength) throws IOException {
        this(vector, 0, offsetLength, 1.0f);
    }

    TokenStreamFromTermVector(Terms vector, int filteredDocId, int offsetLength, float loadFactor) throws IOException {
        this.filteredDocId = filteredDocId;
        int n = this.offsetLength = offsetLength == Integer.MAX_VALUE ? -1 : offsetLength;
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor should be > 0 and <= 1");
        }
        this.loadFactor = loadFactor;
        assert (!this.hasAttribute(PayloadAttribute.class)) : "AttributeFactory shouldn't have payloads *yet*";
        if (!vector.hasPositions() && !vector.hasOffsets()) {
            throw new IllegalArgumentException("The term vector needs positions and/or offsets.");
        }
        assert (vector.hasFreqs());
        this.vector = vector;
        this.termAttribute = this.addAttribute(CharTermAttribute.class);
        this.positionIncrementAttribute = this.addAttribute(PositionIncrementAttribute.class);
    }

    public Terms getTermVectorTerms() {
        return this.vector;
    }

    @Override
    public void reset() throws IOException {
        this.incrementToken = null;
        super.reset();
    }

    private void init() throws IOException {
        BytesRef termBytesRef;
        assert (!this.initialized);
        int dpEnumFlags = 0;
        if (this.vector.hasOffsets()) {
            this.offsetAttribute = this.addAttribute(OffsetAttribute.class);
            dpEnumFlags |= 0x38;
        }
        if (this.vector.hasPayloads() && this.hasAttribute(PayloadAttribute.class)) {
            this.payloadAttribute = this.getAttribute(PayloadAttribute.class);
            this.payloadsBytesRefArray = new BytesRefArray(Counter.newCounter());
            this.spareBytesRefBuilder = new BytesRefBuilder();
            dpEnumFlags |= 0x58;
        }
        this.termCharsBuilder = new CharsRefBuilder();
        this.termCharsBuilder.grow(this.initTotalTermCharLen());
        TokenLL[] tokenBuckets = this.initTokenBucketsArray();
        double OFFSET_TO_BUCKET_IDX = (double)this.loadFactor / 6.0;
        double POSITION_TO_BUCKET_IDX = this.loadFactor;
        TermsEnum termsEnum = this.vector.iterator();
        PostingsEnum dpEnum = null;
        CharsRefBuilder tempCharsRefBuilder = new CharsRefBuilder();
        block0: while ((termBytesRef = termsEnum.next()) != null) {
            tempCharsRefBuilder.grow(termBytesRef.length);
            int termCharsLen = UnicodeUtil.UTF8toUTF16(termBytesRef, tempCharsRefBuilder.chars());
            int termCharsOff = this.termCharsBuilder.length();
            this.termCharsBuilder.append(tempCharsRefBuilder.chars(), 0, termCharsLen);
            dpEnum = termsEnum.postings(dpEnum, dpEnumFlags);
            assert (dpEnum != null);
            int currentDocId = dpEnum.advance(this.filteredDocId);
            if (currentDocId != this.filteredDocId) continue;
            int freq = dpEnum.freq();
            for (int j = 0; j < freq; ++j) {
                int bucketIdx;
                TokenLL token = new TokenLL();
                token.position = dpEnum.nextPosition();
                token.termCharsOff = termCharsOff;
                token.termCharsLen = (short)Math.min(termCharsLen, Short.MAX_VALUE);
                if (this.offsetAttribute != null) {
                    token.startOffset = dpEnum.startOffset();
                    if (this.offsetLength >= 0 && token.startOffset > this.offsetLength) continue block0;
                    token.endOffsetInc = (short)Math.min(dpEnum.endOffset() - token.startOffset, Short.MAX_VALUE);
                    bucketIdx = (int)((double)token.startOffset * OFFSET_TO_BUCKET_IDX);
                } else {
                    bucketIdx = (int)((double)token.position * POSITION_TO_BUCKET_IDX);
                }
                if (bucketIdx >= tokenBuckets.length) {
                    bucketIdx = tokenBuckets.length - 1;
                }
                if (this.payloadAttribute != null) {
                    BytesRef payload = dpEnum.getPayload();
                    token.payloadIndex = payload == null ? -1 : this.payloadsBytesRefArray.append(payload);
                }
                token.next = tokenBuckets[bucketIdx];
                tokenBuckets[bucketIdx] = token;
            }
        }
        this.firstToken = TokenStreamFromTermVector.initLinkAndSortTokens(tokenBuckets);
        if (!this.vector.hasPositions() && this.firstToken != null) {
            TokenLL prevToken = this.firstToken;
            prevToken.position = 0;
            TokenLL token = prevToken.next;
            while (token != null) {
                token.position = prevToken.startOffset == token.startOffset ? prevToken.position : prevToken.position + 1;
                prevToken = token;
                token = token.next;
            }
        }
        this.initialized = true;
    }

    private static TokenLL initLinkAndSortTokens(TokenLL[] tokenBuckets) {
        TokenLL firstToken = null;
        ArrayList<TokenLL> scratchTokenArray = new ArrayList<TokenLL>();
        TokenLL prevToken = null;
        for (TokenLL tokenHead : tokenBuckets) {
            TokenLL tokenTail;
            if (tokenHead == null) continue;
            if (tokenHead.next == null) {
                tokenTail = tokenHead;
            } else {
                TokenLL cur = tokenHead;
                while (cur != null) {
                    scratchTokenArray.add(cur);
                    cur = cur.next;
                }
                if (scratchTokenArray.size() < 16) {
                    tokenHead = tokenTail = (TokenLL)scratchTokenArray.get(0);
                    tokenHead.next = null;
                    block2: for (int i = 1; i < scratchTokenArray.size(); ++i) {
                        TokenLL insertToken = (TokenLL)scratchTokenArray.get(i);
                        if (insertToken.compareTo(tokenHead) <= 0) {
                            insertToken.next = tokenHead;
                            tokenHead = insertToken;
                            continue;
                        }
                        TokenLL prev = tokenHead;
                        while (true) {
                            if (prev.next == null || insertToken.compareTo(prev.next) <= 0) {
                                if (prev.next == null) {
                                    tokenTail = insertToken;
                                }
                                insertToken.next = prev.next;
                                prev.next = insertToken;
                                continue block2;
                            }
                            prev = prev.next;
                        }
                    }
                } else {
                    Collections.sort(scratchTokenArray);
                    TokenLL prev = tokenHead = (TokenLL)scratchTokenArray.get(0);
                    for (int i = 1; i < scratchTokenArray.size(); ++i) {
                        prev = prev.next = (TokenLL)scratchTokenArray.get(i);
                    }
                    tokenTail = prev;
                    tokenTail.next = null;
                }
                scratchTokenArray.clear();
            }
            if (prevToken != null) {
                assert (prevToken.next == null);
                prevToken.next = tokenHead;
                assert (prevToken.compareTo(tokenHead) < 0) : "wrong offset / position ordering expectations";
            } else {
                assert (firstToken == null);
                firstToken = tokenHead;
            }
            prevToken = tokenTail;
        }
        return firstToken;
    }

    private int initTotalTermCharLen() throws IOException {
        int guessNumTerms;
        if (this.vector.size() != -1L) {
            guessNumTerms = (int)this.vector.size();
        } else if (this.offsetLength != -1) {
            guessNumTerms = (int)((double)this.offsetLength * 0.33);
        } else {
            return 128;
        }
        return Math.max(64, (int)((double)((float)guessNumTerms * this.loadFactor) * 7.0));
    }

    private TokenLL[] initTokenBucketsArray() throws IOException {
        int positionsEstimate;
        if (this.offsetLength == -1) {
            int sumTotalTermFreq = (int)this.vector.getSumTotalTermFreq();
            if (sumTotalTermFreq == -1) {
                int size = (int)this.vector.size();
                if (size == -1) {
                    size = 128;
                }
                sumTotalTermFreq = (int)((double)size * 2.4);
            }
            positionsEstimate = (int)((double)sumTotalTermFreq * 1.5);
        } else {
            positionsEstimate = (int)((double)this.offsetLength / 6.0);
        }
        return new TokenLL[Math.max(1, (int)((float)positionsEstimate * this.loadFactor))];
    }

    @Override
    public boolean incrementToken() throws IOException {
        int posInc;
        if (this.incrementToken == null) {
            if (!this.initialized) {
                this.init();
                assert (this.initialized);
            }
            this.incrementToken = this.firstToken;
            if (this.incrementToken == null) {
                return false;
            }
            posInc = this.incrementToken.position + 1;
        } else if (this.incrementToken.next != null) {
            int lastPosition = this.incrementToken.position;
            this.incrementToken = this.incrementToken.next;
            posInc = this.incrementToken.position - lastPosition;
        } else {
            return false;
        }
        this.clearAttributes();
        this.termAttribute.copyBuffer(this.termCharsBuilder.chars(), this.incrementToken.termCharsOff, this.incrementToken.termCharsLen);
        this.positionIncrementAttribute.setPositionIncrement(posInc);
        if (this.offsetAttribute != null) {
            this.offsetAttribute.setOffset(this.incrementToken.startOffset, this.incrementToken.startOffset + this.incrementToken.endOffsetInc);
        }
        if (this.payloadAttribute != null && this.incrementToken.payloadIndex >= 0) {
            this.payloadAttribute.setPayload(this.payloadsBytesRefArray.get(this.spareBytesRefBuilder, this.incrementToken.payloadIndex));
        }
        return true;
    }

    private static class TokenLL
    implements Comparable<TokenLL> {
        int termCharsOff;
        short termCharsLen;
        int position;
        int startOffset;
        short endOffsetInc;
        int payloadIndex;
        TokenLL next;

        private TokenLL() {
        }

        @Override
        public int compareTo(TokenLL tokenB) {
            int cmp = Integer.compare(this.position, tokenB.position);
            if (cmp == 0 && (cmp = Integer.compare(this.startOffset, tokenB.startOffset)) == 0) {
                cmp = Short.compare(this.endOffsetInc, tokenB.endOffsetInc);
            }
            return cmp;
        }
    }
}

