/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.ReaderUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.TermVectorFilteredLeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class PostingsWithTermVectorsOffsetStrategy
extends FieldOffsetStrategy {
    public PostingsWithTermVectorsOffsetStrategy(String field, BytesRef[] queryTerms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata) {
        super(field, queryTerms, phraseHelper, automata);
    }

    @Override
    public List<OffsetsEnum> getOffsetsEnums(IndexReader reader, int docId, String content) throws IOException {
        LeafReader leafReader;
        if (reader instanceof LeafReader) {
            leafReader = (LeafReader)reader;
        } else {
            List<LeafReaderContext> leaves = reader.leaves();
            LeafReaderContext LeafReaderContext2 = leaves.get(ReaderUtil.subIndex(docId, leaves));
            leafReader = LeafReaderContext2.reader();
            docId -= LeafReaderContext2.docBase;
        }
        Terms docTerms = leafReader.getTermVector(docId, this.field);
        if (docTerms == null) {
            return Collections.emptyList();
        }
        leafReader = new TermVectorFilteredLeafReader(leafReader, docTerms);
        TokenStream tokenStream = this.automata.length > 0 ? MultiTermHighlighting.uninvertAndFilterTerms(leafReader.terms(this.field), docId, this.automata, content.length()) : null;
        return this.createOffsetsEnums(leafReader, docId, tokenStream);
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.POSTINGS;
    }
}

