/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BlendedTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.MultiTermQueryConstantScoreWrapper;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ScoringRewrite;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TopTermsRewrite;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.AttributeSource;

public abstract class MultiTermQuery
extends Query {
    protected final String field;
    protected RewriteMethod rewriteMethod = CONSTANT_SCORE_REWRITE;
    public static final RewriteMethod CONSTANT_SCORE_REWRITE = new RewriteMethod(){

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            return new MultiTermQueryConstantScoreWrapper<MultiTermQuery>(query);
        }
    };
    public static final RewriteMethod SCORING_BOOLEAN_REWRITE = ScoringRewrite.SCORING_BOOLEAN_REWRITE;
    public static final RewriteMethod CONSTANT_SCORE_BOOLEAN_REWRITE = ScoringRewrite.CONSTANT_SCORE_BOOLEAN_REWRITE;

    public MultiTermQuery(String field) {
        this.field = Objects.requireNonNull(field, "field must not be null");
    }

    public final String getField() {
        return this.field;
    }

    protected abstract TermsEnum getTermsEnum(Terms var1, AttributeSource var2) throws IOException;

    protected final TermsEnum getTermsEnum(Terms terms) throws IOException {
        return this.getTermsEnum(terms, new AttributeSource());
    }

    @Override
    public final Query rewrite(IndexReader reader) throws IOException {
        return this.rewriteMethod.rewrite(reader, this);
    }

    public RewriteMethod getRewriteMethod() {
        return this.rewriteMethod;
    }

    public void setRewriteMethod(RewriteMethod method) {
        this.rewriteMethod = method;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.rewriteMethod.hashCode();
        result = 31 * result + this.field.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((MultiTermQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(MultiTermQuery other) {
        return this.rewriteMethod.equals(other.rewriteMethod) && this.field.equals(other.field);
    }

    public static final class TopTermsBoostOnlyBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery.Builder> {
        public TopTermsBoostOnlyBooleanQueryRewrite(int size) {
            super(size);
        }

        @Override
        protected int getMaxSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        protected BooleanQuery.Builder getTopLevelBuilder() {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(true);
            return builder;
        }

        @Override
        protected Query build(BooleanQuery.Builder builder) {
            return builder.build();
        }

        @Override
        protected void addClause(BooleanQuery.Builder topLevel, Term term, int docFreq, float boost, TermContext states) {
            ConstantScoreQuery q = new ConstantScoreQuery(new TermQuery(term, states));
            topLevel.add(new BoostQuery(q, boost), BooleanClause.Occur.SHOULD);
        }
    }

    public static final class TopTermsBlendedFreqScoringRewrite
    extends TopTermsRewrite<BlendedTermQuery.Builder> {
        public TopTermsBlendedFreqScoringRewrite(int size) {
            super(size);
        }

        @Override
        protected int getMaxSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        protected BlendedTermQuery.Builder getTopLevelBuilder() {
            BlendedTermQuery.Builder builder = new BlendedTermQuery.Builder();
            builder.setRewriteMethod(BlendedTermQuery.BOOLEAN_REWRITE);
            return builder;
        }

        @Override
        protected Query build(BlendedTermQuery.Builder builder) {
            return builder.build();
        }

        @Override
        protected void addClause(BlendedTermQuery.Builder topLevel, Term term, int docCount, float boost, TermContext states) {
            topLevel.add(term, boost, states);
        }
    }

    public static final class TopTermsScoringBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery.Builder> {
        public TopTermsScoringBooleanQueryRewrite(int size) {
            super(size);
        }

        @Override
        protected int getMaxSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        protected BooleanQuery.Builder getTopLevelBuilder() {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(true);
            return builder;
        }

        @Override
        protected Query build(BooleanQuery.Builder builder) {
            return builder.build();
        }

        @Override
        protected void addClause(BooleanQuery.Builder topLevel, Term term, int docCount, float boost, TermContext states) {
            TermQuery tq = new TermQuery(term, states);
            topLevel.add(new BoostQuery(tq, boost), BooleanClause.Occur.SHOULD);
        }
    }

    public static abstract class RewriteMethod {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;

        protected TermsEnum getTermsEnum(MultiTermQuery query, Terms terms, AttributeSource atts) throws IOException {
            return query.getTermsEnum(terms, atts);
        }
    }
}

