/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queryparser.analyzing;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queryparser.classic.ParseException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefBuilder;

public class AnalyzingQueryParser
extends QueryParser {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(\\\\.)|([?*]+)");

    public AnalyzingQueryParser(String field, Analyzer analyzer) {
        super(field, analyzer);
        this.setAnalyzeRangeTerms(true);
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if ("*".equals(field) && "*".equals(termStr)) {
            return this.newMatchAllDocsQuery();
        }
        if (!this.getAllowLeadingWildcard() && (termStr.startsWith("*") || termStr.startsWith("?"))) {
            throw new ParseException("'*' or '?' not allowed as first character in WildcardQuery");
        }
        Term t = new Term(field, this.analyzeWildcard(field, termStr));
        return this.newWildcardQuery(t);
    }

    private BytesRef analyzeWildcard(String field, String termStr) {
        BytesRef normalized;
        String chunk;
        Matcher wildcardMatcher = WILDCARD_PATTERN.matcher(termStr);
        BytesRefBuilder sb = new BytesRefBuilder();
        int last = 0;
        while (wildcardMatcher.find()) {
            if (wildcardMatcher.start() > 0) {
                chunk = termStr.substring(last, wildcardMatcher.start());
                normalized = this.getAnalyzer().normalize(field, chunk);
                sb.append(normalized);
            }
            sb.append(new BytesRef(wildcardMatcher.group()));
            last = wildcardMatcher.end();
        }
        if (last < termStr.length()) {
            chunk = termStr.substring(last);
            normalized = this.getAnalyzer().normalize(field, chunk);
            sb.append(normalized);
        }
        return sb.toBytesRef();
    }

    @Override
    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (!this.getAllowLeadingWildcard() && termStr.startsWith("*")) {
            throw new ParseException("'*' not allowed as first character in PrefixQuery");
        }
        if (this.getLowercaseExpandedTerms()) {
            termStr = termStr.toLowerCase(this.getLocale());
        }
        BytesRef term = this.getAnalyzer().normalize(field, termStr);
        Term t = new Term(field, term);
        return this.newPrefixQuery(t);
    }

    @Override
    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        BytesRef term = this.getAnalyzer().normalize(field, termStr);
        Term t = new Term(field, term);
        return this.newFuzzyQuery(t, minSimilarity, this.getFuzzyPrefixLength());
    }
}

