/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.CodecReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MergeState;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MultiDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MultiReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.PriorityQueue;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.packed.PackedLongValues;

final class MultiSorter {
    MultiSorter() {
    }

    static MergeState.DocMap[] sort(Sort sort, List<CodecReader> readers) throws IOException {
        SortField[] fields = sort.getSort();
        final CrossReaderComparator[] comparators = new CrossReaderComparator[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            comparators[i] = MultiSorter.getComparator(readers, fields[i]);
        }
        int leafCount = readers.size();
        PriorityQueue<LeafAndDocID> queue = new PriorityQueue<LeafAndDocID>(leafCount){

            @Override
            public boolean lessThan(LeafAndDocID a, LeafAndDocID b) {
                for (int i = 0; i < comparators.length; ++i) {
                    int cmp = comparators[i].compare(a.readerIndex, a.docID, b.readerIndex, b.docID);
                    if (cmp == 0) continue;
                    return cmp < 0;
                }
                if (a.readerIndex != b.readerIndex) {
                    return a.readerIndex < b.readerIndex;
                }
                return a.docID < b.docID;
            }
        };
        PackedLongValues.Builder[] builders = new PackedLongValues.Builder[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            CodecReader reader = readers.get(i);
            queue.add(new LeafAndDocID(i, reader.getLiveDocs(), reader.maxDoc()));
            builders[i] = PackedLongValues.monotonicBuilder(0.0f);
        }
        int mappedDocID = 0;
        while (queue.size() != 0) {
            LeafAndDocID top = (LeafAndDocID)queue.top();
            builders[top.readerIndex].add(mappedDocID);
            if (top.liveDocs == null || top.liveDocs.get(top.docID)) {
                ++mappedDocID;
            }
            ++top.docID;
            if (top.docID < top.maxDoc) {
                queue.updateTop();
                continue;
            }
            queue.pop();
        }
        MergeState.DocMap[] docMaps = new MergeState.DocMap[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            final PackedLongValues remapped = builders[i].build();
            final Bits liveDocs = readers.get(i).getLiveDocs();
            docMaps[i] = new MergeState.DocMap(){

                @Override
                public int get(int docID) {
                    if (liveDocs == null || liveDocs.get(docID)) {
                        return (int)remapped.get(docID);
                    }
                    return -1;
                }
            };
        }
        return docMaps;
    }

    private static CrossReaderComparator getComparator(List<CodecReader> readers, SortField sortField) throws IOException {
        switch (sortField.getType()) {
            case STRING: {
                MultiReader multiReader = new MultiReader((IndexReader[])readers.toArray(new LeafReader[readers.size()]));
                final SortedDocValues sorted = MultiDocValues.getSortedValues(multiReader, sortField.getField());
                final int[] docStarts = new int[readers.size()];
                List<LeafReaderContext> leaves = multiReader.leaves();
                for (int i = 0; i < readers.size(); ++i) {
                    docStarts[i] = leaves.get((int)i).docBase;
                }
                final int missingOrd = sortField.getMissingValue() == SortField.STRING_LAST ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                final int reverseMul = sortField.getReverse() ? -1 : 1;
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        int ordB;
                        int ordA = sorted.getOrd(docStarts[readerIndexA] + docIDA);
                        if (ordA == -1) {
                            ordA = missingOrd;
                        }
                        if ((ordB = sorted.getOrd(docStarts[readerIndexB] + docIDB)) == -1) {
                            ordB = missingOrd;
                        }
                        return reverseMul * Integer.compare(ordA, ordB);
                    }
                };
            }
            case LONG: {
                final ArrayList<NumericDocValues> values = new ArrayList<NumericDocValues>();
                final ArrayList<Bits> docsWithFields = new ArrayList<Bits>();
                for (CodecReader reader : readers) {
                    values.add(DocValues.getNumeric(reader, sortField.getField()));
                    docsWithFields.add(DocValues.getDocsWithField(reader, sortField.getField()));
                }
                final int reverseMul = sortField.getReverse() ? -1 : 1;
                final long missingValue = sortField.getMissingValue() != null ? (Long)sortField.getMissingValue() : 0L;
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        long valueA = ((Bits)docsWithFields.get(readerIndexA)).get(docIDA) ? ((NumericDocValues)values.get(readerIndexA)).get(docIDA) : missingValue;
                        long valueB = ((Bits)docsWithFields.get(readerIndexB)).get(docIDB) ? ((NumericDocValues)values.get(readerIndexB)).get(docIDB) : missingValue;
                        return reverseMul * Long.compare(valueA, valueB);
                    }
                };
            }
            case INT: {
                final ArrayList<NumericDocValues> values = new ArrayList<NumericDocValues>();
                final ArrayList<Bits> docsWithFields = new ArrayList<Bits>();
                for (CodecReader reader : readers) {
                    values.add(DocValues.getNumeric(reader, sortField.getField()));
                    docsWithFields.add(DocValues.getDocsWithField(reader, sortField.getField()));
                }
                final int reverseMul = sortField.getReverse() ? -1 : 1;
                final int missingValue = sortField.getMissingValue() != null ? (Integer)sortField.getMissingValue() : 0;
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        int valueA = ((Bits)docsWithFields.get(readerIndexA)).get(docIDA) ? (int)((NumericDocValues)values.get(readerIndexA)).get(docIDA) : missingValue;
                        int valueB = ((Bits)docsWithFields.get(readerIndexB)).get(docIDB) ? (int)((NumericDocValues)values.get(readerIndexB)).get(docIDB) : missingValue;
                        return reverseMul * Integer.compare(valueA, valueB);
                    }
                };
            }
            case DOUBLE: {
                final ArrayList<NumericDocValues> values = new ArrayList<NumericDocValues>();
                final ArrayList<Bits> docsWithFields = new ArrayList<Bits>();
                for (CodecReader reader : readers) {
                    values.add(DocValues.getNumeric(reader, sortField.getField()));
                    docsWithFields.add(DocValues.getDocsWithField(reader, sortField.getField()));
                }
                final int reverseMul = sortField.getReverse() ? -1 : 1;
                final double missingValue = sortField.getMissingValue() != null ? (Double)sortField.getMissingValue() : 0.0;
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        double valueA = ((Bits)docsWithFields.get(readerIndexA)).get(docIDA) ? Double.longBitsToDouble(((NumericDocValues)values.get(readerIndexA)).get(docIDA)) : missingValue;
                        double valueB = ((Bits)docsWithFields.get(readerIndexB)).get(docIDB) ? Double.longBitsToDouble(((NumericDocValues)values.get(readerIndexB)).get(docIDB)) : missingValue;
                        return reverseMul * Double.compare(valueA, valueB);
                    }
                };
            }
            case FLOAT: {
                final ArrayList<NumericDocValues> values = new ArrayList<NumericDocValues>();
                final ArrayList<Bits> docsWithFields = new ArrayList<Bits>();
                for (CodecReader reader : readers) {
                    values.add(DocValues.getNumeric(reader, sortField.getField()));
                    docsWithFields.add(DocValues.getDocsWithField(reader, sortField.getField()));
                }
                final int reverseMul = sortField.getReverse() ? -1 : 1;
                final float missingValue = sortField.getMissingValue() != null ? ((Float)sortField.getMissingValue()).floatValue() : 0.0f;
                return new CrossReaderComparator(){

                    @Override
                    public int compare(int readerIndexA, int docIDA, int readerIndexB, int docIDB) {
                        float valueA = ((Bits)docsWithFields.get(readerIndexA)).get(docIDA) ? Float.intBitsToFloat((int)((NumericDocValues)values.get(readerIndexA)).get(docIDA)) : missingValue;
                        float valueB = ((Bits)docsWithFields.get(readerIndexB)).get(docIDB) ? Float.intBitsToFloat((int)((NumericDocValues)values.get(readerIndexB)).get(docIDB)) : missingValue;
                        return reverseMul * Float.compare(valueA, valueB);
                    }
                };
            }
        }
        throw new IllegalArgumentException("unhandled SortField.getType()=" + (Object)((Object)sortField.getType()));
    }

    private static interface CrossReaderComparator {
        public int compare(int var1, int var2, int var3, int var4);
    }

    private static class LeafAndDocID {
        final int readerIndex;
        final Bits liveDocs;
        final int maxDoc;
        int docID;

        public LeafAndDocID(int readerIndex, Bits liveDocs, int maxDoc) {
            this.readerIndex = readerIndex;
            this.liveDocs = liveDocs;
            this.maxDoc = maxDoc;
        }
    }
}

