/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.Field;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.RangeFieldQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.NumericUtils;

public class DoubleRangeField
extends Field {
    public static final int BYTES = 8;

    public DoubleRangeField(String name, double[] min, double[] max) {
        super(name, DoubleRangeField.getType(min.length));
        this.setRangeValues(min, max);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("DoubleRangeField does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 8);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(double[] min, double[] max) {
        byte[] bytes;
        DoubleRangeField.checkArgs(min, max);
        if (min.length * 2 != this.type.pointDimensionCount() || max.length * 2 != this.type.pointDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[16 * min.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        DoubleRangeField.verifyAndEncode(min, max, bytes);
    }

    private static void checkArgs(double[] min, double[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min.length > 4) {
            throw new IllegalArgumentException("DoubleRangeField does not support greater than 4 dimensions");
        }
    }

    private static byte[] encode(double[] min, double[] max) {
        DoubleRangeField.checkArgs(min, max);
        byte[] b = new byte[16 * min.length];
        DoubleRangeField.verifyAndEncode(min, max, b);
        return b;
    }

    static void verifyAndEncode(double[] min, double[] max, byte[] bytes) {
        int d = 0;
        int i = 0;
        int j = min.length * 8;
        while (d < min.length) {
            if (Double.isNaN(min[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in DoubleRangeField");
            }
            if (Double.isNaN(max[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in DoubleRangeField");
            }
            if (min[d] > max[d]) {
                throw new IllegalArgumentException("min value (" + min[d] + ") is greater than max value (" + max[d] + ")");
            }
            DoubleRangeField.encode(min[d], bytes, i);
            DoubleRangeField.encode(max[d], bytes, j);
            ++d;
            i += 8;
            j += 8;
        }
    }

    private static void encode(double val, byte[] bytes, int offset) {
        NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(val), bytes, offset);
    }

    public double getMin(int dimension) {
        if (dimension < 0 || dimension >= this.type.pointDimensionCount() / 2) {
            throw new IllegalArgumentException("dimension request (" + dimension + ") out of bounds for field (name=" + this.name + " dimensions=" + this.type.pointDimensionCount() / 2 + "). ");
        }
        return DoubleRangeField.decodeMin(((BytesRef)this.fieldsData).bytes, dimension);
    }

    public double getMax(int dimension) {
        if (dimension < 0 || dimension >= this.type.pointDimensionCount() / 2) {
            throw new IllegalArgumentException("dimension request (" + dimension + ") out of bounds for field (name=" + this.name + " dimensions=" + this.type.pointDimensionCount() / 2 + "). ");
        }
        return DoubleRangeField.decodeMax(((BytesRef)this.fieldsData).bytes, dimension);
    }

    static double decodeMin(byte[] b, int dimension) {
        int offset = dimension * 8;
        return NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(b, offset));
    }

    static double decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 8;
        return NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(b, offset));
    }

    public static Query newIntersectsQuery(String field, double[] min, double[] max) {
        return new RangeFieldQuery(field, DoubleRangeField.encode(min, max), min.length, RangeFieldQuery.QueryType.INTERSECTS){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return DoubleRangeField.toString(ranges, dimension);
            }
        };
    }

    public static Query newContainsQuery(String field, double[] min, double[] max) {
        return new RangeFieldQuery(field, DoubleRangeField.encode(min, max), min.length, RangeFieldQuery.QueryType.CONTAINS){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return DoubleRangeField.toString(ranges, dimension);
            }
        };
    }

    public static Query newWithinQuery(String field, double[] min, double[] max) {
        DoubleRangeField.checkArgs(min, max);
        return new RangeFieldQuery(field, DoubleRangeField.encode(min, max), min.length, RangeFieldQuery.QueryType.WITHIN){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return DoubleRangeField.toString(ranges, dimension);
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        DoubleRangeField.toString(b, 0);
        for (int d = 1; d < this.type.pointDimensionCount(); ++d) {
            sb.append(' ');
            DoubleRangeField.toString(b, d);
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Double.toString(DoubleRangeField.decodeMin(ranges, dimension)) + " : " + Double.toString(DoubleRangeField.decodeMax(ranges, dimension)) + "]";
    }
}

