/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion2x.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.IntHashSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.PrefixAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.StringField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.Automata;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.Automaton;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.search.suggest.completion2x.context.ContextBuilder;
import org.elasticsearch.search.suggest.completion2x.context.ContextMapping;

public class GeolocationContextMapping
extends ContextMapping {
    public static final String TYPE = "geo";
    public static final String FIELD_PRECISION = "precision";
    public static final String FIELD_NEIGHBORS = "neighbors";
    public static final String FIELD_FIELDNAME = "path";
    private final Collection<String> defaultLocations;
    private final int[] precision;
    private final boolean neighbors;
    private final String fieldName;
    private final GeoConfig defaultConfig;

    protected GeolocationContextMapping(String name, int[] precision, boolean neighbors, Collection<String> defaultLocations, String fieldName) {
        super(TYPE, name);
        this.precision = precision;
        this.neighbors = neighbors;
        this.defaultLocations = defaultLocations;
        this.fieldName = fieldName;
        this.defaultConfig = new GeoConfig(this, defaultLocations);
    }

    protected static GeolocationContextMapping load(String name, Map<String, Object> config) {
        if (!config.containsKey(FIELD_PRECISION)) {
            throw new ElasticsearchParseException("field [precision] is missing", new Object[0]);
        }
        Builder builder = new Builder(name);
        if (config != null) {
            Object fieldName;
            Object def;
            Object configNeighbors;
            Object configPrecision = config.get(FIELD_PRECISION);
            if (configPrecision != null) {
                if (configPrecision instanceof Integer) {
                    builder.precision((Integer)configPrecision);
                    config.remove(FIELD_PRECISION);
                } else if (configPrecision instanceof Long) {
                    builder.precision(((Long)configPrecision).longValue());
                    config.remove(FIELD_PRECISION);
                } else if (configPrecision instanceof Double) {
                    builder.precision((Double)configPrecision);
                    config.remove(FIELD_PRECISION);
                } else if (configPrecision instanceof Float) {
                    builder.precision(((Float)configPrecision).floatValue());
                    config.remove(FIELD_PRECISION);
                } else if (configPrecision instanceof Iterable) {
                    for (Object precision : (Iterable)configPrecision) {
                        if (precision instanceof Integer) {
                            builder.precision((Integer)precision);
                            continue;
                        }
                        if (precision instanceof Long) {
                            builder.precision(((Long)precision).longValue());
                            continue;
                        }
                        if (precision instanceof Double) {
                            builder.precision((Double)precision);
                            continue;
                        }
                        if (precision instanceof Float) {
                            builder.precision(((Float)precision).floatValue());
                            continue;
                        }
                        builder.precision(precision.toString());
                    }
                    config.remove(FIELD_PRECISION);
                } else {
                    builder.precision(configPrecision.toString());
                    config.remove(FIELD_PRECISION);
                }
            }
            if ((configNeighbors = config.get(FIELD_NEIGHBORS)) != null) {
                builder.neighbors((Boolean)configNeighbors);
                config.remove(FIELD_NEIGHBORS);
            }
            if ((def = config.get("default")) != null) {
                if (def instanceof Iterable) {
                    for (Object location : (Iterable)def) {
                        builder.addDefaultLocation(location.toString());
                    }
                } else if (def instanceof String) {
                    builder.addDefaultLocation(def.toString());
                } else if (def instanceof Map) {
                    Map latlonMap = (Map)def;
                    if (!latlonMap.containsKey("lat") || !(latlonMap.get("lat") instanceof Double)) {
                        throw new ElasticsearchParseException("field [{}] map must have field lat and a valid latitude", "default");
                    }
                    if (!latlonMap.containsKey("lon") || !(latlonMap.get("lon") instanceof Double)) {
                        throw new ElasticsearchParseException("field [{}] map must have field lon and a valid longitude", "default");
                    }
                    builder.addDefaultLocation(Double.valueOf(latlonMap.get("lat").toString()), Double.valueOf(latlonMap.get("lon").toString()));
                } else {
                    throw new ElasticsearchParseException("field [{}] must be of type string or list", "default");
                }
                config.remove("default");
            }
            if ((fieldName = config.get(FIELD_FIELDNAME)) != null) {
                builder.field(fieldName.toString());
                config.remove(FIELD_FIELDNAME);
            }
        }
        return builder.build();
    }

    @Override
    protected XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.array(FIELD_PRECISION, this.precision);
        builder.field(FIELD_NEIGHBORS, this.neighbors);
        if (this.defaultLocations != null) {
            builder.startArray("default");
            for (String defaultLocation : this.defaultLocations) {
                builder.value(defaultLocation);
            }
            builder.endArray();
        }
        if (this.fieldName != null) {
            builder.field(FIELD_FIELDNAME, this.fieldName);
        }
        return builder;
    }

    protected static Collection<String> parseSinglePointOrList(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = parser.nextToken();
            if (token == XContentParser.Token.VALUE_NUMBER) {
                double lon = parser.doubleValue();
                if (parser.nextToken() == XContentParser.Token.VALUE_NUMBER) {
                    double lat = parser.doubleValue();
                    if (parser.nextToken() == XContentParser.Token.END_ARRAY) {
                        return Collections.singleton(GeoHashUtils.stringEncode(lon, lat));
                    }
                    throw new ElasticsearchParseException("only two values expected", new Object[0]);
                }
                throw new ElasticsearchParseException("latitue must be a numeric value", new Object[0]);
            }
            ArrayList<String> result = new ArrayList<String>();
            while (token != XContentParser.Token.END_ARRAY) {
                result.add(GeoUtils.parseGeoPoint(parser).geohash());
                token = parser.nextToken();
            }
            return result;
        }
        return Collections.singleton(GeoUtils.parseGeoPoint(parser).geohash());
    }

    @Override
    public ContextMapping.ContextConfig defaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ContextMapping.ContextConfig parseContext(ParseContext parseContext, XContentParser parser) throws IOException, ElasticsearchParseException {
        FieldMapper mapper;
        if (this.fieldName != null && !((mapper = parseContext.docMapper().mappers().getMapper(this.fieldName)) instanceof GeoPointFieldMapper)) {
            throw new ElasticsearchParseException("referenced field must be mapped to geo_point", new Object[0]);
        }
        Collection<String> locations = parser.currentToken() == XContentParser.Token.VALUE_NULL ? null : GeolocationContextMapping.parseSinglePointOrList(parser);
        return new GeoConfig(this, locations);
    }

    public static GeoQuery query(String name, GeoPoint point) {
        return GeolocationContextMapping.query(name, point.getGeohash(), new int[0]);
    }

    public static GeoQuery query(String name, double lat, double lon, int ... precisions) {
        return GeolocationContextMapping.query(name, GeoHashUtils.stringEncode(lon, lat), precisions);
    }

    public static GeoQuery query(String name, double lat, double lon, String ... precisions) {
        int[] precisionInts = new int[precisions.length];
        for (int i = 0; i < precisions.length; ++i) {
            precisionInts[i] = GeoUtils.geoHashLevelsForPrecision(precisions[i]);
        }
        return GeolocationContextMapping.query(name, GeoHashUtils.stringEncode(lon, lat), precisionInts);
    }

    public static GeoQuery query(String name, String geohash, int ... precisions) {
        return new GeoQuery(name, geohash, precisions);
    }

    private static int parsePrecision(XContentParser parser) throws IOException, ElasticsearchParseException {
        switch (parser.currentToken()) {
            case VALUE_STRING: {
                return GeoUtils.geoHashLevelsForPrecision(parser.text());
            }
            case VALUE_NUMBER: {
                switch (parser.numberType()) {
                    case INT: 
                    case LONG: {
                        return parser.intValue();
                    }
                }
                return GeoUtils.geoHashLevelsForPrecision(parser.doubleValue());
            }
        }
        throw new ElasticsearchParseException("invalid precision value", new Object[0]);
    }

    @Override
    public GeoQuery parseQuery(String name, XContentParser parser) throws IOException, ElasticsearchParseException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            double lat = Double.NaN;
            double lon = Double.NaN;
            GeoPoint point = null;
            int[] precision = null;
            block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                if ("lat".equals(fieldName)) {
                    if (point == null) {
                        parser.nextToken();
                        switch (parser.currentToken()) {
                            case VALUE_STRING: 
                            case VALUE_NUMBER: {
                                lat = parser.doubleValue(true);
                                continue block6;
                            }
                        }
                        throw new ElasticsearchParseException("latitude must be a number", new Object[0]);
                    }
                    throw new ElasticsearchParseException("only lat/lon or [{}] is allowed", "value");
                }
                if ("lon".equals(fieldName)) {
                    if (point == null) {
                        parser.nextToken();
                        switch (parser.currentToken()) {
                            case VALUE_STRING: 
                            case VALUE_NUMBER: {
                                lon = parser.doubleValue(true);
                                continue block6;
                            }
                        }
                        throw new ElasticsearchParseException("longitude must be a number", new Object[0]);
                    }
                    throw new ElasticsearchParseException("only lat/lon or [{}] is allowed", "value");
                }
                if (FIELD_PRECISION.equals(fieldName)) {
                    if (parser.nextToken() == XContentParser.Token.START_ARRAY) {
                        IntHashSet precisions = new IntHashSet();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            precisions.add(GeolocationContextMapping.parsePrecision(parser));
                        }
                        precision = precisions.toArray();
                        continue;
                    }
                    precision = new int[]{GeolocationContextMapping.parsePrecision(parser)};
                    continue;
                }
                if ("value".equals(fieldName)) {
                    if (Double.isNaN(lon) && Double.isNaN(lat)) {
                        parser.nextToken();
                        point = GeoUtils.parseGeoPoint(parser);
                        continue;
                    }
                    throw new ElasticsearchParseException("only lat/lon or [{}] is allowed", "value");
                }
                throw new ElasticsearchParseException("unexpected fieldname [{}]", fieldName);
            }
            if (point == null) {
                if (Double.isNaN(lat) || Double.isNaN(lon)) {
                    throw new ElasticsearchParseException("location is missing", new Object[0]);
                }
                point = new GeoPoint(lat, lon);
            }
            if (precision == null || precision.length == 0) {
                precision = this.precision;
            }
            return new GeoQuery(name, point.geohash(), precision);
        }
        return new GeoQuery(name, GeoUtils.parseGeoPoint(parser).getGeohash(), this.precision);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultLocations == null ? 0 : this.defaultLocations.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.neighbors ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.precision);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeolocationContextMapping other = (GeolocationContextMapping)obj;
        if (this.defaultLocations == null ? other.defaultLocations != null : !this.defaultLocations.equals(other.defaultLocations)) {
            return false;
        }
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        if (this.neighbors != other.neighbors) {
            return false;
        }
        return Arrays.equals(this.precision, other.precision);
    }

    private static class GeoQuery
    extends ContextMapping.ContextQuery {
        private final String location;
        private final int[] precisions;

        GeoQuery(String name, String location, int ... precisions) {
            super(name);
            this.location = location;
            this.precisions = precisions;
        }

        @Override
        public Automaton toAutomaton() {
            Automaton automaton;
            if (this.precisions == null || this.precisions.length == 0) {
                automaton = Automata.makeString(this.location);
            } else {
                automaton = Automata.makeString(this.location.substring(0, Math.max(1, Math.min(this.location.length(), this.precisions[0]))));
                for (int i = 1; i < this.precisions.length; ++i) {
                    String cell = this.location.substring(0, Math.max(1, Math.min(this.location.length(), this.precisions[i])));
                    automaton = Operations.union(automaton, Automata.makeString(cell));
                }
            }
            return automaton;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.precisions == null || this.precisions.length == 0) {
                builder.field(this.name, this.location);
            } else {
                builder.startObject(this.name);
                builder.field("value", this.location);
                builder.array(GeolocationContextMapping.FIELD_PRECISION, this.precisions);
                builder.endObject();
            }
            return builder;
        }
    }

    private static class GeoConfig
    extends ContextMapping.ContextConfig {
        private final GeolocationContextMapping mapping;
        private final Collection<String> locations;

        GeoConfig(GeolocationContextMapping mapping, Collection<String> locations) {
            this.locations = locations;
            this.mapping = mapping;
        }

        @Override
        protected TokenStream wrapTokenStream(ParseContext.Document doc, TokenStream stream) {
            Collection<String> geohashes;
            if (this.locations == null || this.locations.size() == 0) {
                if (this.mapping.fieldName != null) {
                    IndexableField[] fields = doc.getFields(this.mapping.fieldName);
                    if (fields.length == 0) {
                        IndexableField[] lonFields = doc.getFields(this.mapping.fieldName + ".lon");
                        IndexableField[] latFields = doc.getFields(this.mapping.fieldName + ".lat");
                        if (lonFields.length > 0 && latFields.length > 0) {
                            geohashes = new ArrayList(fields.length);
                            GeoPoint spare = new GeoPoint();
                            for (int i = 0; i < lonFields.length; ++i) {
                                IndexableField lonField = lonFields[i];
                                IndexableField latField = latFields[i];
                                assert (lonField.fieldType().docValuesType() == latField.fieldType().docValuesType());
                                if (lonField.fieldType().docValuesType() != DocValuesType.NONE) continue;
                                spare.reset(latField.numericValue().doubleValue(), lonField.numericValue().doubleValue());
                                geohashes.add(spare.geohash());
                            }
                        } else {
                            geohashes = this.mapping.defaultLocations;
                        }
                    } else {
                        geohashes = new ArrayList(fields.length);
                        GeoPoint spare = new GeoPoint();
                        for (IndexableField field : fields) {
                            if (field instanceof StringField) {
                                spare.resetFromString(field.stringValue());
                            } else if (field instanceof GeoPointField) {
                                GeoPointField geoPointField = (GeoPointField)field;
                                spare.reset(geoPointField.getLat(), geoPointField.getLon());
                            } else {
                                spare.resetFromString(field.stringValue());
                            }
                            geohashes.add(spare.geohash());
                        }
                    }
                } else {
                    geohashes = this.mapping.defaultLocations;
                }
            } else {
                geohashes = this.locations;
            }
            HashSet<String> locations = new HashSet<String>();
            for (String geohash : geohashes) {
                for (int p : this.mapping.precision) {
                    int precision = Math.min(p, geohash.length());
                    String truncatedGeohash = geohash.substring(0, precision);
                    if (this.mapping.neighbors) {
                        GeoHashUtils.addNeighbors(truncatedGeohash, precision, locations);
                    }
                    locations.add(truncatedGeohash);
                }
            }
            return new PrefixAnalyzer.PrefixTokenFilter(stream, '\u001d', locations);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GeoConfig(location = [");
            Iterator<String> location = this.locations.iterator();
            if (location.hasNext()) {
                sb.append((CharSequence)location.next());
                while (location.hasNext()) {
                    sb.append(", ").append((CharSequence)location.next());
                }
            }
            return sb.append("])").toString();
        }
    }

    public static class Builder
    extends ContextBuilder<GeolocationContextMapping> {
        private IntHashSet precisions = new IntHashSet();
        private boolean neighbors;
        private HashSet<String> defaultLocations = new HashSet();
        private String fieldName = null;

        protected Builder(String name) {
            this(name, true, null);
        }

        protected Builder(String name, boolean neighbors, int ... levels) {
            super(name);
            this.neighbors(neighbors);
            if (levels != null) {
                for (int level : levels) {
                    this.precision(level);
                }
            }
        }

        public Builder precision(String precision) {
            return this.precision(DistanceUnit.parse(precision, DistanceUnit.METERS, DistanceUnit.METERS));
        }

        public Builder precision(double precision, DistanceUnit unit) {
            return this.precision(unit.toMeters(precision));
        }

        public Builder precision(double meters) {
            int level = GeoUtils.geoHashLevelsForPrecision(meters);
            if (GeoUtils.geoHashCellSize(level) < meters) {
                level = Math.max(1, level - 1);
            }
            return this.precision(level);
        }

        public Builder precision(int level) {
            this.precisions.add(level);
            return this;
        }

        public Builder neighbors(boolean neighbors) {
            this.neighbors = neighbors;
            return this;
        }

        public Builder addDefaultLocation(String geohash) {
            this.defaultLocations.add(geohash);
            return this;
        }

        public Builder addDefaultLocations(Collection<String> geohashes) {
            this.defaultLocations.addAll(geohashes);
            return this;
        }

        public Builder addDefaultLocation(double lat, double lon) {
            this.defaultLocations.add(GeoHashUtils.stringEncode(lon, lat));
            return this;
        }

        public Builder defaultLocation(GeoPoint point) {
            this.defaultLocations.add(point.geohash());
            return this;
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public GeolocationContextMapping build() {
            if (this.precisions.isEmpty()) {
                this.precisions.add(12);
            }
            int[] precisionArray = this.precisions.toArray();
            Arrays.sort(precisionArray);
            return new GeolocationContextMapping(this.name, precisionArray, this.neighbors, this.defaultLocations, this.fieldName);
        }
    }
}

