/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetSettingsAction
extends BaseRestHandler {
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    public RestGetSettingsAction(Settings settings, RestController controller, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter) {
        super(settings);
        this.indexScopedSettings = indexScopedSettings;
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_settings/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_settings/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_setting/{name}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] names = request.paramAsStringArrayOrEmptyIfAll("name");
        final boolean renderDefaults = request.paramAsBoolean("include_defaults", false);
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(Strings.splitStringByCommaToArray(request.param("index"))).indicesOptions(IndicesOptions.fromRequest(request, IndicesOptions.strictExpandOpen())).humanReadable(request.hasParam("human")).names(names);
        getSettingsRequest.local(request.paramAsBoolean("local", getSettingsRequest.local()));
        return channel -> client.admin().indices().getSettings(getSettingsRequest, (ActionListener<GetSettingsResponse>)new RestBuilderListener<GetSettingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetSettingsResponse getSettingsResponse, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (ObjectObjectCursor<String, Settings> objectObjectCursor : getSettingsResponse.getIndexToSettings()) {
                    if (((Settings)objectObjectCursor.value).isEmpty()) continue;
                    builder.startObject((String)objectObjectCursor.key);
                    builder.startObject("settings");
                    ((Settings)objectObjectCursor.value).toXContent(builder, request);
                    builder.endObject();
                    if (renderDefaults) {
                        builder.startObject("defaults");
                        RestGetSettingsAction.this.settingsFilter.filter(RestGetSettingsAction.this.indexScopedSettings.diff((Settings)objectObjectCursor.value, RestGetSettingsAction.this.settings)).toXContent(builder, request);
                        builder.endObject();
                    }
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

