/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestGetIndexTemplateAction
extends BaseRestHandler {
    public RestGetIndexTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_template", this);
        controller.registerHandler(RestRequest.Method.GET, "/_template/{name}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] names = Strings.splitStringByCommaToArray(request.param("name"));
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(names);
        getIndexTemplatesRequest.local(request.paramAsBoolean("local", getIndexTemplatesRequest.local()));
        getIndexTemplatesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getIndexTemplatesRequest.masterNodeTimeout()));
        final boolean implicitAll = getIndexTemplatesRequest.names().length == 0;
        return channel -> client.admin().indices().getTemplates(getIndexTemplatesRequest, (ActionListener<GetIndexTemplatesResponse>)new RestToXContentListener<GetIndexTemplatesResponse>(channel){

            @Override
            protected RestStatus getStatus(GetIndexTemplatesResponse response) {
                boolean templateExists = false == response.getIndexTemplates().isEmpty();
                return templateExists || implicitAll ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

