/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.percolator.MultiPercolateAction;
import org.elasticsearch.percolator.MultiPercolateRequest;
import org.elasticsearch.percolator.MultiPercolateResponse;
import org.elasticsearch.percolator.PercolateAction;
import org.elasticsearch.percolator.PercolateQueryBuilder;
import org.elasticsearch.percolator.PercolateRequest;
import org.elasticsearch.percolator.PercolateResponse;
import org.elasticsearch.percolator.PercolatorFieldMapper;
import org.elasticsearch.percolator.PercolatorHighlightSubFetchPhase;
import org.elasticsearch.percolator.RestMultiPercolateAction;
import org.elasticsearch.percolator.RestPercolateAction;
import org.elasticsearch.percolator.TransportMultiPercolateAction;
import org.elasticsearch.percolator.TransportPercolateAction;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.search.fetch.FetchSubPhase;

public class PercolatorPlugin
extends Plugin
implements MapperPlugin,
ActionPlugin,
SearchPlugin {
    private final Settings settings;

    public PercolatorPlugin(Settings settings) {
        this.settings = settings;
    }

    @Override
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler<PercolateRequest, PercolateResponse>(PercolateAction.INSTANCE, TransportPercolateAction.class, new Class[0]), new ActionPlugin.ActionHandler<MultiPercolateRequest, MultiPercolateResponse>(MultiPercolateAction.INSTANCE, TransportMultiPercolateAction.class, new Class[0]));
    }

    @Override
    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestPercolateAction(settings, restController), new RestMultiPercolateAction(settings, restController));
    }

    @Override
    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec<PercolateQueryBuilder>("percolate", PercolateQueryBuilder::new, PercolateQueryBuilder::fromXContent));
    }

    @Override
    public List<FetchSubPhase> getFetchSubPhases(SearchPlugin.FetchPhaseConstructionContext context) {
        return Collections.singletonList(new PercolatorHighlightSubFetchPhase(this.settings, context.getHighlighters()));
    }

    @Override
    public List<Setting<?>> getSettings() {
        return Collections.singletonList(PercolatorFieldMapper.INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING);
    }

    @Override
    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("percolator", new PercolatorFieldMapper.TypeParser());
    }
}

