/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.StoreRateLimiting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.FsDirectoryService;
import org.elasticsearch.index.store.IndexStoreConfig;

public class IndexStore
extends AbstractIndexComponent {
    public static final Setting<IndexRateLimitingType> INDEX_STORE_THROTTLE_TYPE_SETTING = new Setting<IndexRateLimitingType>("index.store.throttle.type", "none", IndexRateLimitingType::fromString, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_STORE_THROTTLE_MAX_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("index.store.throttle.max_bytes_per_sec", new ByteSizeValue(0L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    protected final IndexStoreConfig indexStoreConfig;
    private final StoreRateLimiting rateLimiting = new StoreRateLimiting();
    private volatile IndexRateLimitingType type;

    public IndexStore(IndexSettings indexSettings, IndexStoreConfig indexStoreConfig) {
        super(indexSettings);
        this.indexStoreConfig = indexStoreConfig;
        this.setType(indexSettings.getValue(INDEX_STORE_THROTTLE_TYPE_SETTING));
        this.rateLimiting.setMaxRate(indexSettings.getValue(INDEX_STORE_THROTTLE_MAX_BYTES_PER_SEC_SETTING));
        this.logger.debug("using index.store.throttle.type [{}], with index.store.throttle.max_bytes_per_sec [{}]", (Object)this.rateLimiting.getType(), (Object)this.rateLimiting.getRateLimiter());
    }

    public StoreRateLimiting rateLimiting() {
        return this.type.useStoreLimiter() ? this.indexStoreConfig.getNodeRateLimiter() : this.rateLimiting;
    }

    public DirectoryService newDirectoryService(ShardPath path) {
        return new FsDirectoryService(this.indexSettings, this, path);
    }

    public void setType(IndexRateLimitingType type) {
        this.type = type;
        if (!type.useStoreLimiter()) {
            this.rateLimiting.setType(type.type);
        }
    }

    public void setMaxRate(ByteSizeValue rate) {
        this.rateLimiting.setMaxRate(rate);
    }

    public static final class IndexRateLimitingType {
        private final StoreRateLimiting.Type type;

        private IndexRateLimitingType(StoreRateLimiting.Type type) {
            this.type = type;
        }

        private boolean useStoreLimiter() {
            return this.type == null;
        }

        static IndexRateLimitingType fromString(String type) {
            if ("node".equalsIgnoreCase(type)) {
                return new IndexRateLimitingType(null);
            }
            try {
                return new IndexRateLimitingType(StoreRateLimiting.Type.fromString(type));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("rate limiting type [" + type + "] not valid, can be one of [all|merge|none|node]");
            }
        }
    }
}

