/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.AbstractBulkByQueryRestHandler;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;

public class RestUpdateByQueryAction
extends AbstractBulkByQueryRestHandler<UpdateByQueryRequest, UpdateByQueryAction> {
    public RestUpdateByQueryAction(Settings settings, RestController controller) {
        super(settings, UpdateByQueryAction.INSTANCE);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_update_by_query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_update_by_query", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return this.doPrepareRequest(request, client, false, true);
    }

    @Override
    protected UpdateByQueryRequest buildRequest(RestRequest request) throws IOException {
        UpdateByQueryRequest internal = new UpdateByQueryRequest(new SearchRequest());
        HashMap<String, Consumer<Object>> consumers = new HashMap<String, Consumer<Object>>();
        consumers.put("conflicts", o -> internal.setConflicts((String)o));
        consumers.put("script", o -> {
            UpdateByQueryRequest cfr_ignored_0 = (UpdateByQueryRequest)internal.setScript(RestUpdateByQueryAction.parseScript((Map)o));
        });
        this.parseInternalRequest(internal, request, consumers);
        internal.setPipeline(request.param("pipeline"));
        return internal;
    }

    private static Script parseScript(Map<String, Object> config) {
        String script = null;
        ScriptType type = null;
        String lang = "painless";
        Map params = Collections.emptyMap();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String parameterName = entry.getKey();
            Object parameterValue = entry.getValue();
            if (Script.LANG_PARSE_FIELD.match(parameterName)) {
                if (parameterValue instanceof String || parameterValue == null) {
                    lang = (String)parameterValue;
                    continue;
                }
                throw new ElasticsearchParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
            }
            if (Script.PARAMS_PARSE_FIELD.match(parameterName)) {
                if (parameterValue instanceof Map || parameterValue == null) {
                    params = (Map)parameterValue;
                    continue;
                }
                throw new ElasticsearchParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
            }
            if (ScriptType.INLINE.getParseField().match(parameterName)) {
                if (parameterValue instanceof String || parameterValue == null) {
                    script = (String)parameterValue;
                    type = ScriptType.INLINE;
                    continue;
                }
                throw new ElasticsearchParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
            }
            if (ScriptType.FILE.getParseField().match(parameterName)) {
                if (parameterValue instanceof String || parameterValue == null) {
                    script = (String)parameterValue;
                    type = ScriptType.FILE;
                    continue;
                }
                throw new ElasticsearchParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
            }
            if (!ScriptType.STORED.getParseField().match(parameterName)) continue;
            if (parameterValue instanceof String || parameterValue == null) {
                script = (String)parameterValue;
                type = ScriptType.STORED;
                continue;
            }
            throw new ElasticsearchParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
        }
        if (script == null) {
            throw new ElasticsearchParseException("expected one of [{}], [{}] or [{}] fields, but found none", ScriptType.INLINE.getParseField().getPreferredName(), ScriptType.FILE.getParseField().getPreferredName(), ScriptType.STORED.getParseField().getPreferredName());
        }
        assert (type != null) : "if script is not null, type should definitely not be null";
        return new Script(type, lang, script, params);
    }
}

