/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.WildcardQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class WildcardQueryBuilder
extends AbstractQueryBuilder<WildcardQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "wildcard";
    private static final ParseField WILDCARD_FIELD = new ParseField("wildcard", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ParseField REWRITE_FIELD = new ParseField("rewrite", new String[0]);
    private final String fieldName;
    private final String value;
    private String rewrite;

    public WildcardQueryBuilder(String fieldName, String value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public WildcardQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readString();
        this.rewrite = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeString(this.value);
        out.writeOptionalString(this.rewrite);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String value() {
        return this.value;
    }

    public WildcardQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public String rewrite() {
        return this.rewrite;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(WILDCARD_FIELD.getPreferredName(), this.value);
        if (this.rewrite != null) {
            builder.field(REWRITE_FIELD.getPreferredName(), this.rewrite);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static Optional<WildcardQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        String rewrite = null;
        String value = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                WildcardQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (WILDCARD_FIELD.match(currentFieldName)) {
                        value = parser.text();
                        continue;
                    }
                    if (VALUE_FIELD.match(currentFieldName)) {
                        value = parser.text();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (REWRITE_FIELD.match(currentFieldName)) {
                        rewrite = parser.textOrNull();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[wildcard] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            WildcardQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = parser.text();
        }
        return Optional.of(((WildcardQueryBuilder)new WildcardQueryBuilder(fieldName, value).rewrite(rewrite).boost(boost)).queryName(queryName));
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Term term;
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            term = new Term(this.fieldName, BytesRefs.toBytesRef(this.value));
        } else {
            Query termQuery = fieldType.termQuery(this.value, context);
            term = MappedFieldType.extractTerm(termQuery);
        }
        WildcardQuery query = new WildcardQuery(term);
        MultiTermQuery.RewriteMethod rewriteMethod = QueryParsers.parseRewriteMethod(this.rewrite, null);
        QueryParsers.setRewriteMethod(query, rewriteMethod);
        return query;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.rewrite);
    }

    @Override
    protected boolean doEquals(WildcardQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.rewrite, other.rewrite);
    }
}

