/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queryparser.classic.MapperQueryParser;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queryparser.classic.ParseException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.joda.time.DateTimeZone;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.support.QueryParsers;

public class QueryStringQueryBuilder
extends AbstractQueryBuilder<QueryStringQueryBuilder> {
    public static final String NAME = "query_string";
    public static final boolean DEFAULT_AUTO_GENERATE_PHRASE_QUERIES = false;
    public static final int DEFAULT_MAX_DETERMINED_STATES = 10000;
    public static final boolean DEFAULT_ENABLE_POSITION_INCREMENTS = true;
    public static final boolean DEFAULT_ESCAPE = false;
    public static final boolean DEFAULT_USE_DIS_MAX = true;
    public static final int DEFAULT_FUZZY_PREFIX_LENGTH = 0;
    public static final int DEFAULT_FUZZY_MAX_EXPANSIONS = 50;
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final float DEFAULT_TIE_BREAKER = 0.0f;
    public static final Fuzziness DEFAULT_FUZZINESS = Fuzziness.AUTO;
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    public static final boolean DEFAULT_SPLIT_ON_WHITESPACE = true;
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField DEFAULT_FIELD_FIELD = new ParseField("default_field", new String[0]);
    private static final ParseField DEFAULT_OPERATOR_FIELD = new ParseField("default_operator", new String[0]);
    private static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    private static final ParseField QUOTE_ANALYZER_FIELD = new ParseField("quote_analyzer", new String[0]);
    private static final ParseField ALLOW_LEADING_WILDCARD_FIELD = new ParseField("allow_leading_wildcard", new String[0]);
    private static final ParseField AUTO_GENERATE_PHRASE_QUERIES_FIELD = new ParseField("auto_generate_phrase_queries", new String[0]);
    private static final ParseField MAX_DETERMINIZED_STATES_FIELD = new ParseField("max_determinized_states", "max_determined_states");
    private static final ParseField LOWERCASE_EXPANDED_TERMS_FIELD = new ParseField("lowercase_expanded_terms", new String[0]).withAllDeprecated("Decision is now made by the analyzer");
    private static final ParseField ENABLE_POSITION_INCREMENTS_FIELD = new ParseField("enable_position_increments", "enable_position_increment");
    private static final ParseField ESCAPE_FIELD = new ParseField("escape", new String[0]);
    private static final ParseField USE_DIS_MAX_FIELD = new ParseField("use_dis_max", new String[0]);
    private static final ParseField FUZZY_PREFIX_LENGTH_FIELD = new ParseField("fuzzy_prefix_length", new String[0]);
    private static final ParseField FUZZY_MAX_EXPANSIONS_FIELD = new ParseField("fuzzy_max_expansions", new String[0]);
    private static final ParseField FUZZY_REWRITE_FIELD = new ParseField("fuzzy_rewrite", new String[0]);
    private static final ParseField PHRASE_SLOP_FIELD = new ParseField("phrase_slop", new String[0]);
    private static final ParseField TIE_BREAKER_FIELD = new ParseField("tie_breaker", new String[0]);
    private static final ParseField ANALYZE_WILDCARD_FIELD = new ParseField("analyze_wildcard", new String[0]);
    private static final ParseField REWRITE_FIELD = new ParseField("rewrite", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField QUOTE_FIELD_SUFFIX_FIELD = new ParseField("quote_field_suffix", new String[0]);
    private static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    private static final ParseField LOCALE_FIELD = new ParseField("locale", new String[0]).withAllDeprecated("Decision is now made by the analyzer");
    private static final ParseField TIME_ZONE_FIELD = new ParseField("time_zone", new String[0]);
    private static final ParseField SPLIT_ON_WHITESPACE = new ParseField("split_on_whitespace", new String[0]);
    private static final ParseField ALL_FIELDS_FIELD = new ParseField("all_fields", new String[0]);
    public static final Set<String> ALLOWED_QUERY_MAPPER_TYPES = new HashSet<String>();
    private final String queryString;
    private String defaultField;
    private final Map<String, Float> fieldsAndWeights = new TreeMap<String, Float>();
    private Operator defaultOperator = DEFAULT_OPERATOR;
    private String analyzer;
    private String quoteAnalyzer;
    private String quoteFieldSuffix;
    private boolean autoGeneratePhraseQueries = false;
    private Boolean allowLeadingWildcard;
    private Boolean analyzeWildcard;
    private boolean enablePositionIncrements = true;
    private Fuzziness fuzziness = DEFAULT_FUZZINESS;
    private int fuzzyPrefixLength = 0;
    private int fuzzyMaxExpansions = 50;
    private String rewrite;
    private String fuzzyRewrite;
    private boolean escape = false;
    private int phraseSlop = 0;
    private boolean useDisMax = true;
    private float tieBreaker = 0.0f;
    private String minimumShouldMatch;
    private Boolean lenient;
    private DateTimeZone timeZone;
    private Boolean useAllFields;
    private int maxDeterminizedStates = 10000;
    private boolean splitOnWhitespace = true;

    public QueryStringQueryBuilder(String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException("query text missing");
        }
        this.queryString = queryString;
    }

    public QueryStringQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryString = in.readString();
        this.defaultField = in.readOptionalString();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.fieldsAndWeights.put(in.readString(), Float.valueOf(in.readFloat()));
        }
        this.defaultOperator = Operator.readFromStream(in);
        this.analyzer = in.readOptionalString();
        this.quoteAnalyzer = in.readOptionalString();
        this.quoteFieldSuffix = in.readOptionalString();
        this.autoGeneratePhraseQueries = in.readBoolean();
        this.allowLeadingWildcard = in.readOptionalBoolean();
        this.analyzeWildcard = in.readOptionalBoolean();
        if (in.getVersion().before(Version.V_5_1_1_UNRELEASED)) {
            in.readBoolean();
        }
        this.enablePositionIncrements = in.readBoolean();
        if (in.getVersion().before(Version.V_5_1_1_UNRELEASED)) {
            in.readString();
        }
        this.fuzziness = new Fuzziness(in);
        this.fuzzyPrefixLength = in.readVInt();
        this.fuzzyMaxExpansions = in.readVInt();
        this.fuzzyRewrite = in.readOptionalString();
        this.phraseSlop = in.readVInt();
        this.useDisMax = in.readBoolean();
        this.tieBreaker = in.readFloat();
        this.rewrite = in.readOptionalString();
        this.minimumShouldMatch = in.readOptionalString();
        this.lenient = in.readOptionalBoolean();
        this.timeZone = in.readOptionalTimeZone();
        this.escape = in.readBoolean();
        this.maxDeterminizedStates = in.readVInt();
        if (in.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED)) {
            this.splitOnWhitespace = in.readBoolean();
            this.useAllFields = in.readOptionalBoolean();
        } else {
            this.splitOnWhitespace = true;
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.queryString);
        out.writeOptionalString(this.defaultField);
        out.writeVInt(this.fieldsAndWeights.size());
        for (Map.Entry<String, Float> fieldsEntry : this.fieldsAndWeights.entrySet()) {
            out.writeString(fieldsEntry.getKey());
            out.writeFloat(fieldsEntry.getValue().floatValue());
        }
        this.defaultOperator.writeTo(out);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalString(this.quoteAnalyzer);
        out.writeOptionalString(this.quoteFieldSuffix);
        out.writeBoolean(this.autoGeneratePhraseQueries);
        out.writeOptionalBoolean(this.allowLeadingWildcard);
        out.writeOptionalBoolean(this.analyzeWildcard);
        if (out.getVersion().before(Version.V_5_1_1_UNRELEASED)) {
            out.writeBoolean(true);
        }
        out.writeBoolean(this.enablePositionIncrements);
        if (out.getVersion().before(Version.V_5_1_1_UNRELEASED)) {
            out.writeString(Locale.ROOT.toLanguageTag());
        }
        this.fuzziness.writeTo(out);
        out.writeVInt(this.fuzzyPrefixLength);
        out.writeVInt(this.fuzzyMaxExpansions);
        out.writeOptionalString(this.fuzzyRewrite);
        out.writeVInt(this.phraseSlop);
        out.writeBoolean(this.useDisMax);
        out.writeFloat(this.tieBreaker);
        out.writeOptionalString(this.rewrite);
        out.writeOptionalString(this.minimumShouldMatch);
        out.writeOptionalBoolean(this.lenient);
        out.writeOptionalTimeZone(this.timeZone);
        out.writeBoolean(this.escape);
        out.writeVInt(this.maxDeterminizedStates);
        if (out.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED)) {
            out.writeBoolean(this.splitOnWhitespace);
            out.writeOptionalBoolean(this.useAllFields);
        }
    }

    public String queryString() {
        return this.queryString;
    }

    public QueryStringQueryBuilder defaultField(String defaultField) {
        this.defaultField = defaultField;
        return this;
    }

    public String defaultField() {
        return this.defaultField;
    }

    public QueryStringQueryBuilder useAllFields(Boolean useAllFields) {
        this.useAllFields = useAllFields;
        return this;
    }

    public Boolean useAllFields() {
        return this.useAllFields;
    }

    public QueryStringQueryBuilder field(String field) {
        this.fieldsAndWeights.put(field, Float.valueOf(1.0f));
        return this;
    }

    public QueryStringQueryBuilder field(String field, float boost) {
        this.fieldsAndWeights.put(field, Float.valueOf(boost));
        return this;
    }

    public QueryStringQueryBuilder fields(Map<String, Float> fields) {
        this.fieldsAndWeights.putAll(fields);
        return this;
    }

    public Map<String, Float> fields() {
        return this.fieldsAndWeights;
    }

    public QueryStringQueryBuilder useDisMax(boolean useDisMax) {
        this.useDisMax = useDisMax;
        return this;
    }

    public boolean useDisMax() {
        return this.useDisMax;
    }

    public QueryStringQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public float tieBreaker() {
        return this.tieBreaker;
    }

    public QueryStringQueryBuilder defaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator == null ? DEFAULT_OPERATOR : defaultOperator;
        return this;
    }

    public Operator defaultOperator() {
        return this.defaultOperator;
    }

    public QueryStringQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public QueryStringQueryBuilder quoteAnalyzer(String quoteAnalyzer) {
        this.quoteAnalyzer = quoteAnalyzer;
        return this;
    }

    public QueryStringQueryBuilder autoGeneratePhraseQueries(boolean autoGeneratePhraseQueries) {
        this.autoGeneratePhraseQueries = autoGeneratePhraseQueries;
        return this;
    }

    public boolean autoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public QueryStringQueryBuilder maxDeterminizedStates(int maxDeterminizedStates) {
        this.maxDeterminizedStates = maxDeterminizedStates;
        return this;
    }

    public int maxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    public QueryStringQueryBuilder allowLeadingWildcard(Boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
        return this;
    }

    public Boolean allowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public QueryStringQueryBuilder enablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
        return this;
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public QueryStringQueryBuilder fuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness == null ? DEFAULT_FUZZINESS : fuzziness;
        return this;
    }

    public Fuzziness fuzziness() {
        return this.fuzziness;
    }

    public QueryStringQueryBuilder fuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
        return this;
    }

    public int fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public QueryStringQueryBuilder fuzzyMaxExpansions(int fuzzyMaxExpansions) {
        this.fuzzyMaxExpansions = fuzzyMaxExpansions;
        return this;
    }

    public int fuzzyMaxExpansions() {
        return this.fuzzyMaxExpansions;
    }

    public QueryStringQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    public QueryStringQueryBuilder phraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
        return this;
    }

    public int phraseSlop() {
        return this.phraseSlop;
    }

    public QueryStringQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public QueryStringQueryBuilder analyzeWildcard(Boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
        return this;
    }

    public Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    public String rewrite() {
        return this.rewrite;
    }

    public QueryStringQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public QueryStringQueryBuilder quoteFieldSuffix(String quoteFieldSuffix) {
        this.quoteFieldSuffix = quoteFieldSuffix;
        return this;
    }

    public String quoteFieldSuffix() {
        return this.quoteFieldSuffix;
    }

    public QueryStringQueryBuilder lenient(Boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public Boolean lenient() {
        return this.lenient;
    }

    public QueryStringQueryBuilder timeZone(String timeZone) {
        this.timeZone = timeZone != null ? DateTimeZone.forID(timeZone) : null;
        return this;
    }

    public QueryStringQueryBuilder timeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public DateTimeZone timeZone() {
        return this.timeZone;
    }

    public QueryStringQueryBuilder escape(boolean escape) {
        this.escape = escape;
        return this;
    }

    public boolean escape() {
        return this.escape;
    }

    public QueryStringQueryBuilder splitOnWhitespace(boolean value) {
        this.splitOnWhitespace = value;
        return this;
    }

    public boolean splitOnWhitespace() {
        return this.splitOnWhitespace;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.queryString);
        if (this.defaultField != null) {
            builder.field(DEFAULT_FIELD_FIELD.getPreferredName(), this.defaultField);
        }
        builder.startArray(FIELDS_FIELD.getPreferredName());
        for (Map.Entry<String, Float> fieldEntry : this.fieldsAndWeights.entrySet()) {
            builder.value(fieldEntry.getKey() + "^" + fieldEntry.getValue());
        }
        builder.endArray();
        builder.field(USE_DIS_MAX_FIELD.getPreferredName(), this.useDisMax);
        builder.field(TIE_BREAKER_FIELD.getPreferredName(), this.tieBreaker);
        builder.field(DEFAULT_OPERATOR_FIELD.getPreferredName(), this.defaultOperator.name().toLowerCase(Locale.ROOT));
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        if (this.quoteAnalyzer != null) {
            builder.field(QUOTE_ANALYZER_FIELD.getPreferredName(), this.quoteAnalyzer);
        }
        builder.field(AUTO_GENERATE_PHRASE_QUERIES_FIELD.getPreferredName(), this.autoGeneratePhraseQueries);
        builder.field(MAX_DETERMINIZED_STATES_FIELD.getPreferredName(), this.maxDeterminizedStates);
        if (this.allowLeadingWildcard != null) {
            builder.field(ALLOW_LEADING_WILDCARD_FIELD.getPreferredName(), this.allowLeadingWildcard);
        }
        builder.field(ENABLE_POSITION_INCREMENTS_FIELD.getPreferredName(), this.enablePositionIncrements);
        this.fuzziness.toXContent(builder, params);
        builder.field(FUZZY_PREFIX_LENGTH_FIELD.getPreferredName(), this.fuzzyPrefixLength);
        builder.field(FUZZY_MAX_EXPANSIONS_FIELD.getPreferredName(), this.fuzzyMaxExpansions);
        if (this.fuzzyRewrite != null) {
            builder.field(FUZZY_REWRITE_FIELD.getPreferredName(), this.fuzzyRewrite);
        }
        builder.field(PHRASE_SLOP_FIELD.getPreferredName(), this.phraseSlop);
        if (this.analyzeWildcard != null) {
            builder.field(ANALYZE_WILDCARD_FIELD.getPreferredName(), this.analyzeWildcard);
        }
        if (this.rewrite != null) {
            builder.field(REWRITE_FIELD.getPreferredName(), this.rewrite);
        }
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.quoteFieldSuffix != null) {
            builder.field(QUOTE_FIELD_SUFFIX_FIELD.getPreferredName(), this.quoteFieldSuffix);
        }
        if (this.lenient != null) {
            builder.field(LENIENT_FIELD.getPreferredName(), this.lenient);
        }
        if (this.timeZone != null) {
            builder.field(TIME_ZONE_FIELD.getPreferredName(), this.timeZone.getID());
        }
        builder.field(ESCAPE_FIELD.getPreferredName(), this.escape);
        builder.field(SPLIT_ON_WHITESPACE.getPreferredName(), this.splitOnWhitespace);
        if (this.useAllFields != null) {
            builder.field(ALL_FIELDS_FIELD.getPreferredName(), this.useAllFields);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<QueryStringQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String currentFieldName = null;
        String queryString = null;
        String defaultField = null;
        String analyzer = null;
        String quoteAnalyzer = null;
        String queryName = null;
        float boost = 1.0f;
        boolean autoGeneratePhraseQueries = false;
        int maxDeterminizedStates = 10000;
        boolean enablePositionIncrements = true;
        boolean escape = false;
        boolean useDisMax = true;
        int fuzzyPrefixLength = 0;
        int fuzzyMaxExpansions = 50;
        int phraseSlop = 0;
        float tieBreaker = 0.0f;
        Boolean analyzeWildcard = null;
        Boolean allowLeadingWildcard = null;
        String minimumShouldMatch = null;
        String quoteFieldSuffix = null;
        Boolean lenient = null;
        Operator defaultOperator = DEFAULT_OPERATOR;
        String timeZone = null;
        Fuzziness fuzziness = DEFAULT_FUZZINESS;
        String fuzzyRewrite = null;
        String rewrite = null;
        boolean splitOnWhitespace = true;
        Boolean useAllFields = null;
        HashMap<String, Float> fieldsAndWeights = new HashMap<String, Float>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (FIELDS_FIELD.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String fField = null;
                        float fBoost = 1.0f;
                        char[] text = parser.textCharacters();
                        int end = parser.textOffset() + parser.textLength();
                        for (int i = parser.textOffset(); i < end; ++i) {
                            if (text[i] != '^') continue;
                            int relativeLocation = i - parser.textOffset();
                            fField = new String(text, parser.textOffset(), relativeLocation);
                            fBoost = Float.parseFloat(new String(text, i + 1, parser.textLength() - relativeLocation - 1));
                            break;
                        }
                        if (fField == null) {
                            fField = parser.text();
                        }
                        fieldsAndWeights.put(fField, Float.valueOf(fBoost));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[query_string] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    queryString = parser.text();
                    continue;
                }
                if (DEFAULT_FIELD_FIELD.match(currentFieldName)) {
                    defaultField = parser.text();
                    continue;
                }
                if (DEFAULT_OPERATOR_FIELD.match(currentFieldName)) {
                    defaultOperator = Operator.fromString(parser.text());
                    continue;
                }
                if (ANALYZER_FIELD.match(currentFieldName)) {
                    analyzer = parser.text();
                    continue;
                }
                if (QUOTE_ANALYZER_FIELD.match(currentFieldName)) {
                    quoteAnalyzer = parser.text();
                    continue;
                }
                if (ALLOW_LEADING_WILDCARD_FIELD.match(currentFieldName)) {
                    allowLeadingWildcard = parser.booleanValue();
                    continue;
                }
                if (AUTO_GENERATE_PHRASE_QUERIES_FIELD.match(currentFieldName)) {
                    autoGeneratePhraseQueries = parser.booleanValue();
                    continue;
                }
                if (MAX_DETERMINIZED_STATES_FIELD.match(currentFieldName)) {
                    maxDeterminizedStates = parser.intValue();
                    continue;
                }
                if (LOWERCASE_EXPANDED_TERMS_FIELD.match(currentFieldName)) continue;
                if (ENABLE_POSITION_INCREMENTS_FIELD.match(currentFieldName)) {
                    enablePositionIncrements = parser.booleanValue();
                    continue;
                }
                if (ESCAPE_FIELD.match(currentFieldName)) {
                    escape = parser.booleanValue();
                    continue;
                }
                if (USE_DIS_MAX_FIELD.match(currentFieldName)) {
                    useDisMax = parser.booleanValue();
                    continue;
                }
                if (FUZZY_PREFIX_LENGTH_FIELD.match(currentFieldName)) {
                    fuzzyPrefixLength = parser.intValue();
                    continue;
                }
                if (FUZZY_MAX_EXPANSIONS_FIELD.match(currentFieldName)) {
                    fuzzyMaxExpansions = parser.intValue();
                    continue;
                }
                if (FUZZY_REWRITE_FIELD.match(currentFieldName)) {
                    fuzzyRewrite = parser.textOrNull();
                    continue;
                }
                if (PHRASE_SLOP_FIELD.match(currentFieldName)) {
                    phraseSlop = parser.intValue();
                    continue;
                }
                if (Fuzziness.FIELD.match(currentFieldName)) {
                    fuzziness = Fuzziness.parse(parser);
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (TIE_BREAKER_FIELD.match(currentFieldName)) {
                    tieBreaker = parser.floatValue();
                    continue;
                }
                if (ANALYZE_WILDCARD_FIELD.match(currentFieldName)) {
                    analyzeWildcard = parser.booleanValue();
                    continue;
                }
                if (REWRITE_FIELD.match(currentFieldName)) {
                    rewrite = parser.textOrNull();
                    continue;
                }
                if (MINIMUM_SHOULD_MATCH_FIELD.match(currentFieldName)) {
                    minimumShouldMatch = parser.textOrNull();
                    continue;
                }
                if (QUOTE_FIELD_SUFFIX_FIELD.match(currentFieldName)) {
                    quoteFieldSuffix = parser.textOrNull();
                    continue;
                }
                if (LENIENT_FIELD.match(currentFieldName)) {
                    lenient = parser.booleanValue();
                    continue;
                }
                if (LOCALE_FIELD.match(currentFieldName)) continue;
                if (ALL_FIELDS_FIELD.match(currentFieldName)) {
                    useAllFields = parser.booleanValue();
                    continue;
                }
                if (TIME_ZONE_FIELD.match(currentFieldName)) {
                    try {
                        timeZone = parser.text();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParsingException(parser.getTokenLocation(), "[query_string] time_zone [" + parser.text() + "] is unknown", new Object[0]);
                    }
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                if (SPLIT_ON_WHITESPACE.match(currentFieldName)) {
                    splitOnWhitespace = parser.booleanValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[query_string] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[query_string] unknown token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (queryString == null) {
            throw new ParsingException(parser.getTokenLocation(), "[query_string] must be provided with a [query]", new Object[0]);
        }
        if (useAllFields != null && useAllFields.booleanValue() && (defaultField != null || fieldsAndWeights.size() != 0)) {
            throw new ParsingException(parser.getTokenLocation(), "cannot use [all_fields] parameter in conjunction with [default_field] or [fields]", new Object[0]);
        }
        QueryStringQueryBuilder queryStringQuery = new QueryStringQueryBuilder(queryString);
        queryStringQuery.fields(fieldsAndWeights);
        queryStringQuery.defaultField(defaultField);
        queryStringQuery.defaultOperator(defaultOperator);
        queryStringQuery.analyzer(analyzer);
        queryStringQuery.quoteAnalyzer(quoteAnalyzer);
        queryStringQuery.allowLeadingWildcard(allowLeadingWildcard);
        queryStringQuery.autoGeneratePhraseQueries(autoGeneratePhraseQueries);
        queryStringQuery.maxDeterminizedStates(maxDeterminizedStates);
        queryStringQuery.enablePositionIncrements(enablePositionIncrements);
        queryStringQuery.escape(escape);
        queryStringQuery.useDisMax(useDisMax);
        queryStringQuery.fuzzyPrefixLength(fuzzyPrefixLength);
        queryStringQuery.fuzzyMaxExpansions(fuzzyMaxExpansions);
        queryStringQuery.fuzzyRewrite(fuzzyRewrite);
        queryStringQuery.phraseSlop(phraseSlop);
        queryStringQuery.fuzziness(fuzziness);
        queryStringQuery.tieBreaker(tieBreaker);
        queryStringQuery.analyzeWildcard(analyzeWildcard);
        queryStringQuery.rewrite(rewrite);
        queryStringQuery.minimumShouldMatch(minimumShouldMatch);
        queryStringQuery.quoteFieldSuffix(quoteFieldSuffix);
        queryStringQuery.lenient(lenient);
        queryStringQuery.timeZone(timeZone);
        queryStringQuery.boost(boost);
        queryStringQuery.queryName(queryName);
        queryStringQuery.splitOnWhitespace(splitOnWhitespace);
        queryStringQuery.useAllFields(useAllFields);
        return Optional.of(queryStringQuery);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(QueryStringQueryBuilder other) {
        return Objects.equals(this.queryString, other.queryString) && Objects.equals(this.defaultField, other.defaultField) && Objects.equals(this.fieldsAndWeights, other.fieldsAndWeights) && Objects.equals(this.defaultOperator, other.defaultOperator) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.quoteAnalyzer, other.quoteAnalyzer) && Objects.equals(this.quoteFieldSuffix, other.quoteFieldSuffix) && Objects.equals(this.autoGeneratePhraseQueries, other.autoGeneratePhraseQueries) && Objects.equals(this.allowLeadingWildcard, other.allowLeadingWildcard) && Objects.equals(this.enablePositionIncrements, other.enablePositionIncrements) && Objects.equals(this.analyzeWildcard, other.analyzeWildcard) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.fuzzyPrefixLength, other.fuzzyPrefixLength) && Objects.equals(this.fuzzyMaxExpansions, other.fuzzyMaxExpansions) && Objects.equals(this.fuzzyRewrite, other.fuzzyRewrite) && Objects.equals(this.phraseSlop, other.phraseSlop) && Objects.equals(this.useDisMax, other.useDisMax) && Objects.equals(Float.valueOf(this.tieBreaker), Float.valueOf(other.tieBreaker)) && Objects.equals(this.rewrite, other.rewrite) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.lenient, other.lenient) && this.timeZone == null ? other.timeZone == null : other.timeZone != null && Objects.equals(this.timeZone.getID(), other.timeZone.getID()) && Objects.equals(this.escape, other.escape) && Objects.equals(this.maxDeterminizedStates, other.maxDeterminizedStates) && Objects.equals(this.splitOnWhitespace, other.splitOnWhitespace) && Objects.equals(this.useAllFields, other.useAllFields);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.queryString, this.defaultField, this.fieldsAndWeights, this.defaultOperator, this.analyzer, this.quoteAnalyzer, this.quoteFieldSuffix, this.autoGeneratePhraseQueries, this.allowLeadingWildcard, this.analyzeWildcard, this.enablePositionIncrements, this.fuzziness, this.fuzzyPrefixLength, this.fuzzyMaxExpansions, this.fuzzyRewrite, this.phraseSlop, this.useDisMax, Float.valueOf(this.tieBreaker), this.rewrite, this.minimumShouldMatch, this.lenient, this.timeZone == null ? Integer.valueOf(0) : this.timeZone.getID(), this.escape, this.maxDeterminizedStates, this.splitOnWhitespace, this.useAllFields);
    }

    public static Map<String, Float> allQueryableDefaultFields(QueryShardContext context) {
        Collection<String> allFields = context.simpleMatchToIndexNames("*");
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (String fieldName : allFields) {
            if (MapperService.isMetadataField(fieldName)) continue;
            MappedFieldType mft = context.fieldMapper(fieldName);
            assert (mft != null) : "should never have a null mapper for an existing field";
            String mappingType = mft.typeName();
            if (!ALLOWED_QUERY_MAPPER_TYPES.contains(mappingType)) continue;
            fields.put(fieldName, Float.valueOf(1.0f));
        }
        return fields;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query query;
        NamedAnalyzer namedAnalyzer;
        if (!this.splitOnWhitespace && this.autoGeneratePhraseQueries) {
            throw new IllegalArgumentException("it is disallowed to disable [split_on_whitespace] if [auto_generate_phrase_queries] is activated");
        }
        QueryParserSettings qpSettings = this.escape ? new QueryParserSettings(QueryParser.escape(this.queryString)) : new QueryParserSettings(this.queryString);
        TreeMap<String, Float> resolvedFields = new TreeMap();
        if (this.useAllFields != null && this.useAllFields.booleanValue() && (this.fieldsAndWeights.size() != 0 || this.defaultField != null)) {
            throw this.addValidationError("cannot use [all_fields] parameter in conjunction with [default_field] or [fields]", null);
        }
        if (this.useAllFields != null && this.useAllFields.booleanValue() || !context.getMapperService().allEnabled() && "_all".equals(context.defaultField()) && this.defaultField == null && this.fieldsAndWeights.size() == 0) {
            resolvedFields = QueryStringQueryBuilder.allQueryableDefaultFields(context);
            qpSettings.lenient(true);
        } else {
            qpSettings.defaultField(this.defaultField == null ? context.defaultField() : this.defaultField);
            for (Map.Entry<String, Float> fieldsEntry : this.fieldsAndWeights.entrySet()) {
                String fieldName = fieldsEntry.getKey();
                Float weight = fieldsEntry.getValue();
                if (Regex.isSimpleMatchPattern(fieldName)) {
                    for (String resolvedFieldName : context.getMapperService().simpleMatchToIndexNames(fieldName)) {
                        resolvedFields.put(resolvedFieldName, weight);
                    }
                    continue;
                }
                resolvedFields.put(fieldName, weight);
            }
            qpSettings.lenient(this.lenient == null ? context.queryStringLenient() : this.lenient.booleanValue());
        }
        qpSettings.fieldsAndWeights(resolvedFields);
        qpSettings.defaultOperator(this.defaultOperator.toQueryParserOperator());
        if (this.analyzer == null) {
            qpSettings.defaultAnalyzer(context.getMapperService().searchAnalyzer());
        } else {
            namedAnalyzer = context.getIndexAnalyzers().get(this.analyzer);
            if (namedAnalyzer == null) {
                throw new QueryShardException(context, "[query_string] analyzer [" + this.analyzer + "] not found", new Object[0]);
            }
            qpSettings.forceAnalyzer(namedAnalyzer);
        }
        if (this.quoteAnalyzer != null) {
            namedAnalyzer = context.getIndexAnalyzers().get(this.quoteAnalyzer);
            if (namedAnalyzer == null) {
                throw new QueryShardException(context, "[query_string] quote_analyzer [" + this.quoteAnalyzer + "] not found", new Object[0]);
            }
            qpSettings.forceQuoteAnalyzer(namedAnalyzer);
        } else if (this.analyzer != null) {
            qpSettings.forceQuoteAnalyzer(qpSettings.analyzer());
        } else {
            qpSettings.defaultQuoteAnalyzer(context.getMapperService().searchQuoteAnalyzer());
        }
        qpSettings.quoteFieldSuffix(this.quoteFieldSuffix);
        qpSettings.autoGeneratePhraseQueries(this.autoGeneratePhraseQueries);
        qpSettings.allowLeadingWildcard(this.allowLeadingWildcard == null ? context.queryStringAllowLeadingWildcard() : this.allowLeadingWildcard.booleanValue());
        qpSettings.analyzeWildcard(this.analyzeWildcard == null ? context.queryStringAnalyzeWildcard() : this.analyzeWildcard.booleanValue());
        qpSettings.enablePositionIncrements(this.enablePositionIncrements);
        qpSettings.fuzziness(this.fuzziness);
        qpSettings.fuzzyPrefixLength(this.fuzzyPrefixLength);
        qpSettings.fuzzyMaxExpansions(this.fuzzyMaxExpansions);
        qpSettings.fuzzyRewriteMethod(QueryParsers.parseRewriteMethod(this.fuzzyRewrite));
        qpSettings.phraseSlop(this.phraseSlop);
        qpSettings.useDisMax(this.useDisMax);
        qpSettings.tieBreaker(this.tieBreaker);
        qpSettings.rewriteMethod(QueryParsers.parseRewriteMethod(this.rewrite));
        qpSettings.timeZone(this.timeZone);
        qpSettings.maxDeterminizedStates(this.maxDeterminizedStates);
        qpSettings.splitOnWhitespace(this.splitOnWhitespace);
        MapperQueryParser queryParser = context.queryParser(qpSettings);
        try {
            query = queryParser.parse(this.queryString);
        }
        catch (ParseException e) {
            throw new QueryShardException(context, "Failed to parse query [" + this.queryString + "]", e, new Object[0]);
        }
        if (query == null) {
            return null;
        }
        ArrayList<Float> boosts = new ArrayList<Float>();
        while (query instanceof BoostQuery) {
            BoostQuery boostQuery = (BoostQuery)query;
            boosts.add(Float.valueOf(boostQuery.getBoost()));
            query = boostQuery.getQuery();
        }
        query = Queries.fixNegativeQueryIfNeeded(query);
        query = Queries.maybeApplyMinimumShouldMatch(query, this.minimumShouldMatch);
        for (int i = boosts.size() - 1; i >= 0; --i) {
            query = new BoostQuery(query, ((Float)boosts.get(i)).floatValue());
        }
        return query;
    }

    static {
        ALLOWED_QUERY_MAPPER_TYPES.add("date");
        ALLOWED_QUERY_MAPPER_TYPES.add("ip");
        ALLOWED_QUERY_MAPPER_TYPES.add("keyword");
        for (NumberFieldMapper.NumberType nt : NumberFieldMapper.NumberType.values()) {
            ALLOWED_QUERY_MAPPER_TYPES.add(nt.typeName());
        }
        ALLOWED_QUERY_MAPPER_TYPES.add("scaled_float");
        ALLOWED_QUERY_MAPPER_TYPES.add("string");
        ALLOWED_QUERY_MAPPER_TYPES.add("text");
        ALLOWED_QUERY_MAPPER_TYPES.add("_timestamp");
    }
}

