/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.LegacyNumericTokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.Field;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.joda.time.DateTimeZone;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.search.DocValueFormat;

public abstract class LegacyNumberFieldMapper
extends FieldMapper {
    private static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    protected Boolean includeInAll;
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> coerce;

    protected LegacyNumberFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (!fieldType.tokenized());
        this.ignoreMalformed = ignoreMalformed;
        this.coerce = coerce;
        this.includeInAll = includeInAll;
    }

    @Override
    protected LegacyNumberFieldMapper clone() {
        return (LegacyNumberFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        RuntimeException e = null;
        try {
            this.innerParseCreateField(context, fields);
        }
        catch (IllegalArgumentException e1) {
            e = e1;
        }
        catch (MapperParsingException e2) {
            e = e2;
        }
        if (e != null && !this.ignoreMalformed.value().booleanValue()) {
            throw e;
        }
    }

    protected abstract void innerParseCreateField(ParseContext var1, List<IndexableField> var2) throws IOException;

    protected final void addDocValue(ParseContext context, List<IndexableField> fields, long value) {
        fields.add(new SortedNumericDocValuesField(this.fieldType().name(), value));
    }

    public static double parseDoubleValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof BytesRef) {
            return Double.parseDouble(((BytesRef)value).utf8ToString());
        }
        return Double.parseDouble(value.toString());
    }

    public static long parseLongValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return Long.parseLong(((BytesRef)value).utf8ToString());
        }
        return Long.parseLong(value.toString());
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        LegacyNumberFieldMapper nfmMergeWith = (LegacyNumberFieldMapper)mergeWith;
        this.includeInAll = nfmMergeWith.includeInAll;
        if (nfmMergeWith.ignoreMalformed.explicit()) {
            this.ignoreMalformed = nfmMergeWith.ignoreMalformed;
        }
        if (nfmMergeWith.coerce.explicit()) {
            this.coerce = nfmMergeWith.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
    }

    public static abstract class CustomNumericField
    extends Field {
        private ThreadLocal<LegacyNumericTokenStream> tokenStream = new ThreadLocal<LegacyNumericTokenStream>(){

            @Override
            protected LegacyNumericTokenStream initialValue() {
                return new LegacyNumericTokenStream(this.fieldType().numericPrecisionStep());
            }
        };
        private static ThreadLocal<LegacyNumericTokenStream> tokenStream4 = new ThreadLocal<LegacyNumericTokenStream>(){

            @Override
            protected LegacyNumericTokenStream initialValue() {
                return new LegacyNumericTokenStream(4);
            }
        };
        private static ThreadLocal<LegacyNumericTokenStream> tokenStream8 = new ThreadLocal<LegacyNumericTokenStream>(){

            @Override
            protected LegacyNumericTokenStream initialValue() {
                return new LegacyNumericTokenStream(8);
            }
        };
        private static ThreadLocal<LegacyNumericTokenStream> tokenStream16 = new ThreadLocal<LegacyNumericTokenStream>(){

            @Override
            protected LegacyNumericTokenStream initialValue() {
                return new LegacyNumericTokenStream(16);
            }
        };
        private static ThreadLocal<LegacyNumericTokenStream> tokenStreamMax = new ThreadLocal<LegacyNumericTokenStream>(){

            @Override
            protected LegacyNumericTokenStream initialValue() {
                return new LegacyNumericTokenStream(Integer.MAX_VALUE);
            }
        };

        public CustomNumericField(Number value, MappedFieldType fieldType) {
            super(fieldType.name(), fieldType);
            if (value != null) {
                this.fieldsData = value;
            }
        }

        protected LegacyNumericTokenStream getCachedStream() {
            if (this.fieldType().numericPrecisionStep() == 4) {
                return tokenStream4.get();
            }
            if (this.fieldType().numericPrecisionStep() == 8) {
                return tokenStream8.get();
            }
            if (this.fieldType().numericPrecisionStep() == 16) {
                return tokenStream16.get();
            }
            if (this.fieldType().numericPrecisionStep() == Integer.MAX_VALUE) {
                return tokenStreamMax.get();
            }
            return this.tokenStream.get();
        }

        @Override
        public String stringValue() {
            return null;
        }

        @Override
        public Reader readerValue() {
            return null;
        }

        public abstract String numericAsString();
    }

    public static abstract class NumberFieldType
    extends TermBasedFieldType {
        public NumberFieldType(FieldType.LegacyNumericType numericType) {
            this.setTokenized(false);
            this.setOmitNorms(true);
            this.setIndexOptions(IndexOptions.DOCS);
            this.setStoreTermVectors(false);
            this.setNumericType(numericType);
        }

        protected NumberFieldType(NumberFieldType ref) {
            super(ref);
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
            super.checkCompatibility(other, conflicts, strict);
            if (this.numericPrecisionStep() != other.numericPrecisionStep()) {
                conflicts.add("mapper [" + this.name() + "] has different [precision_step] values");
            }
        }

        @Override
        public abstract NumberFieldType clone();

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, DateTimeZone timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }
    }

    public static abstract class Builder<T extends Builder, Y extends LegacyNumberFieldMapper>
    extends FieldMapper.Builder<T, Y> {
        private Boolean ignoreMalformed;
        private Boolean coerce;

        public Builder(String name, MappedFieldType fieldType, int defaultPrecisionStep) {
            super(name, fieldType, fieldType);
            this.fieldType.setNumericPrecisionStep(defaultPrecisionStep);
        }

        public T precisionStep(int precisionStep) {
            this.fieldType.setNumericPrecisionStep(precisionStep);
            return (T)((Builder)this.builder);
        }

        public T ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public T coerce(boolean coerce) {
            this.coerce = coerce;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>((Boolean)COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            int precisionStep = this.fieldType.numericPrecisionStep();
            if (precisionStep <= 0 || precisionStep >= this.maxPrecisionStep()) {
                this.fieldType.setNumericPrecisionStep(Integer.MAX_VALUE);
            }
        }

        protected abstract int maxPrecisionStep();
    }

    public static class Defaults {
        public static final int PRECISION_STEP_8_BIT = Integer.MAX_VALUE;
        public static final int PRECISION_STEP_16_BIT = 8;
        public static final int PRECISION_STEP_32_BIT = 8;
        public static final int PRECISION_STEP_64_BIT = 16;
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(true, false);
    }
}

