/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.InetAddressPoint;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.search.MultiValueMode;

final class LegacyIpIndexFieldData
implements IndexFieldData<AtomicFieldData> {
    protected final Index index;
    protected final String fieldName;
    protected final Logger logger;

    LegacyIpIndexFieldData(Index index, String fieldName) {
        this.index = index;
        this.fieldName = fieldName;
        this.logger = Loggers.getLogger(this.getClass());
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void clear() {
    }

    public void clear(IndexReader reader) {
    }

    @Override
    public Index index() {
        return this.index;
    }

    @Override
    public AtomicFieldData load(final LeafReaderContext context) {
        return new AtomicFieldData(){

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public ScriptDocValues<?> getScriptValues() {
                throw new UnsupportedOperationException("Cannot run scripts on ip fields");
            }

            @Override
            public SortedBinaryDocValues getBytesValues() {
                SortedNumericDocValues values;
                try {
                    values = DocValues.getSortedNumeric(context.reader(), LegacyIpIndexFieldData.this.fieldName);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot load doc values", e);
                }
                return new SortedBinaryDocValues(){
                    final ByteBuffer scratch = ByteBuffer.allocate(4);

                    @Override
                    public BytesRef valueAt(int index) {
                        InetAddress inet;
                        long ip = values.valueAt(index);
                        this.scratch.putInt(0, (int)ip);
                        try {
                            inet = InetAddress.getByAddress(this.scratch.array());
                        }
                        catch (UnknownHostException e) {
                            throw new IllegalStateException("Cannot happen", e);
                        }
                        byte[] encoded = InetAddressPoint.encode(inet);
                        return new BytesRef(encoded);
                    }

                    @Override
                    public void setDocument(int docId) {
                        values.setDocument(docId);
                    }

                    @Override
                    public int count() {
                        return values.count();
                    }
                };
            }
        };
    }

    @Override
    public AtomicFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
    }
}

