/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.MappedFieldType;

public class SingleFieldsVisitor
extends FieldsVisitor {
    private String field;

    public SingleFieldsVisitor(String field) {
        super(false);
        this.field = field;
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (fieldInfo.name.equals(this.field)) {
            return StoredFieldVisitor.Status.YES;
        }
        if (fieldInfo.name.equals("_uid") && ("_type".equals(this.field) || "_id".equals(this.field))) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    public void reset(String field) {
        this.field = field;
        super.reset();
    }

    public void postProcess(MappedFieldType fieldType) {
        if (this.uid != null) {
            switch (this.field) {
                case "_uid": {
                    this.addValue(this.field, this.uid.toString());
                    break;
                }
                case "_id": {
                    this.addValue(this.field, this.uid.id());
                    break;
                }
                case "_type": {
                    this.addValue(this.field, this.uid.type());
                }
            }
        }
        if (this.fieldsValues == null) {
            return;
        }
        List fieldValues = (List)this.fieldsValues.get(fieldType.name());
        if (fieldValues == null) {
            return;
        }
        for (int i = 0; i < fieldValues.size(); ++i) {
            fieldValues.set(i, fieldType.valueForDisplay(fieldValues.get(i)));
        }
    }
}

