/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty3;

import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.Channel;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.netty3.Netty3Utils;

public class Netty3HttpRequest
extends RestRequest {
    private final HttpRequest request;
    private final Channel channel;
    private final BytesReference content;

    public Netty3HttpRequest(NamedXContentRegistry xContentRegistry, HttpRequest request, Channel channel) {
        super(xContentRegistry, request.getUri(), new HttpHeadersMap(request.headers()));
        this.request = request;
        this.channel = channel;
        this.content = request.getContent().readable() ? Netty3Utils.toBytesReference(request.getContent()) : BytesArray.EMPTY;
    }

    public HttpRequest request() {
        return this.request;
    }

    @Override
    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.getMethod();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        return RestRequest.Method.GET;
    }

    @Override
    public String uri() {
        return this.request.getUri();
    }

    @Override
    public boolean hasContent() {
        return this.content.length() > 0;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public Channel getChannel() {
        return this.channel;
    }

    private static class HttpHeadersMap
    implements Map<String, List<String>> {
        private final HttpHeaders httpHeaders;

        private HttpHeadersMap(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
        }

        @Override
        public int size() {
            return this.httpHeaders.names().size();
        }

        @Override
        public boolean isEmpty() {
            return this.httpHeaders.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof String && this.httpHeaders.contains((String)key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean containsValue(Object value) {
            if (!(value instanceof List)) return false;
            if (!this.httpHeaders.names().stream().map(this.httpHeaders::getAll).anyMatch(value::equals)) return false;
            return true;
        }

        @Override
        public List<String> get(Object key) {
            return key instanceof String ? this.httpHeaders.getAll((String)key) : null;
        }

        @Override
        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public List<String> remove(Object key) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void putAll(Map<? extends String, ? extends List<String>> m) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public Set<String> keySet() {
            return this.httpHeaders.names();
        }

        @Override
        public Collection<List<String>> values() {
            return this.httpHeaders.names().stream().map(k -> Collections.unmodifiableList(this.httpHeaders.getAll((String)k))).collect(Collectors.toList());
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return this.httpHeaders.names().stream().map(k -> new AbstractMap.SimpleImmutableEntry<String, List<String>>((String)k, this.httpHeaders.getAll((String)k))).collect(Collectors.toSet());
        }
    }
}

