/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.streaming.connectors.elasticsearch.ActionRequestFailureHandler;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchUpsertTableSinkBase;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class Elasticsearch
extends ConnectorDescriptor {
    private DescriptorProperties internalProperties = new DescriptorProperties(true);
    private List<ElasticsearchUpsertTableSinkBase.Host> hosts = new ArrayList<ElasticsearchUpsertTableSinkBase.Host>();

    public Elasticsearch() {
        super("elasticsearch", 1, true);
    }

    public Elasticsearch version(String version) {
        this.internalProperties.putString("connector.version", version);
        return this;
    }

    public Elasticsearch host(String hostname, int port, String protocol) {
        ElasticsearchUpsertTableSinkBase.Host host = new ElasticsearchUpsertTableSinkBase.Host((String)Preconditions.checkNotNull((Object)hostname), port, (String)Preconditions.checkNotNull((Object)protocol));
        this.hosts.add(host);
        return this;
    }

    public Elasticsearch index(String index) {
        this.internalProperties.putString("connector.index", index);
        return this;
    }

    public Elasticsearch documentType(String documentType) {
        this.internalProperties.putString("connector.document-type", documentType);
        return this;
    }

    public Elasticsearch keyDelimiter(String keyDelimiter) {
        this.internalProperties.putString("connector.key-delimiter", keyDelimiter);
        return this;
    }

    public Elasticsearch keyNullLiteral(String keyNullLiteral) {
        this.internalProperties.putString("connector.key-null-literal", keyNullLiteral);
        return this;
    }

    public Elasticsearch failureHandlerFail() {
        this.internalProperties.putString("connector.failure-handler", "fail");
        return this;
    }

    public Elasticsearch failureHandlerIgnore() {
        this.internalProperties.putString("connector.failure-handler", "ignore");
        return this;
    }

    public Elasticsearch failureHandlerRetryRejected() {
        this.internalProperties.putString("connector.failure-handler", "retry-rejected");
        return this;
    }

    public Elasticsearch failureHandlerCustom(Class<? extends ActionRequestFailureHandler> failureHandlerClass) {
        this.internalProperties.putString("connector.failure-handler", "custom");
        this.internalProperties.putClass("connector.failure-handler-class", failureHandlerClass);
        return this;
    }

    public Elasticsearch disableFlushOnCheckpoint() {
        this.internalProperties.putBoolean("connector.flush-on-checkpoint", false);
        return this;
    }

    public Elasticsearch bulkFlushMaxActions(int maxActions) {
        this.internalProperties.putInt("connector.bulk-flush.max-actions", maxActions);
        return this;
    }

    public Elasticsearch bulkFlushMaxSize(String maxSize) {
        this.internalProperties.putMemorySize("connector.bulk-flush.max-size", MemorySize.parse((String)maxSize, (MemorySize.MemoryUnit)MemorySize.MemoryUnit.BYTES));
        return this;
    }

    public Elasticsearch bulkFlushInterval(long interval) {
        this.internalProperties.putLong("connector.bulk-flush.interval", interval);
        return this;
    }

    public Elasticsearch bulkFlushBackoffConstant() {
        this.internalProperties.putString("connector.bulk-flush.backoff.type", "constant");
        return this;
    }

    public Elasticsearch bulkFlushBackoffExponential() {
        this.internalProperties.putString("connector.bulk-flush.backoff.type", "exponential");
        return this;
    }

    public Elasticsearch bulkFlushBackoffMaxRetries(int maxRetries) {
        this.internalProperties.putInt("connector.bulk-flush.backoff.max-retries", maxRetries);
        return this;
    }

    public Elasticsearch bulkFlushBackoffDelay(long delay) {
        this.internalProperties.putLong("connector.bulk-flush.backoff.delay", delay);
        return this;
    }

    public Elasticsearch connectionMaxRetryTimeout(int maxRetryTimeout) {
        this.internalProperties.putInt("connector.connection-max-retry-timeout", maxRetryTimeout);
        return this;
    }

    public Elasticsearch connectionPathPrefix(String pathPrefix) {
        this.internalProperties.putString("connector.connection-path-prefix", pathPrefix);
        return this;
    }

    protected Map<String, String> toConnectorProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putProperties(this.internalProperties);
        if (this.hosts.size() > 0) {
            properties.putString("connector.hosts", this.hosts.stream().map(ElasticsearchUpsertTableSinkBase.Host::toString).collect(Collectors.joining(";")));
        }
        return properties.asMap();
    }
}

