/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.Channel;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.ChannelException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.CompleteChannelFuture;

public class FailedChannelFuture
extends CompleteChannelFuture {
    private final Throwable cause;

    public FailedChannelFuture(Channel channel, Throwable cause) {
        super(channel);
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean isSuccess() {
        return false;
    }

    public ChannelFuture sync() throws InterruptedException {
        this.rethrow();
        return this;
    }

    public ChannelFuture syncUninterruptibly() {
        this.rethrow();
        return this;
    }

    private void rethrow() {
        if (this.cause instanceof RuntimeException) {
            throw (RuntimeException)this.cause;
        }
        if (this.cause instanceof Error) {
            throw (Error)this.cause;
        }
        throw new ChannelException(this.cause);
    }
}

