/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;

public class OffsetsEnum
implements Comparable<OffsetsEnum>,
Closeable {
    private final BytesRef term;
    private final PostingsEnum postingsEnum;
    private float weight;
    private int posCounter = 0;

    public OffsetsEnum(BytesRef term, PostingsEnum postingsEnum) throws IOException {
        this.term = term;
        this.postingsEnum = Objects.requireNonNull(postingsEnum);
    }

    @Override
    public int compareTo(OffsetsEnum other) {
        try {
            int cmp = Integer.compare(this.startOffset(), other.startOffset());
            if (cmp != 0) {
                return cmp;
            }
            if (this.term == null || other.term == null) {
                if (this.term == null && other.term == null) {
                    return 0;
                }
                if (this.term == null) {
                    return 1;
                }
                return -1;
            }
            return this.term.compareTo(other.term);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BytesRef getTerm() throws IOException {
        return this.term != null ? this.term : this.postingsEnum.getPayload();
    }

    public PostingsEnum getPostingsEnum() {
        return this.postingsEnum;
    }

    public int freq() throws IOException {
        return this.postingsEnum.freq();
    }

    public boolean hasMorePositions() throws IOException {
        return this.posCounter < this.postingsEnum.freq();
    }

    public void nextPosition() throws IOException {
        assert (this.hasMorePositions());
        ++this.posCounter;
        this.postingsEnum.nextPosition();
    }

    public int startOffset() throws IOException {
        return this.postingsEnum.startOffset();
    }

    public int endOffset() throws IOException {
        return this.postingsEnum.endOffset();
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    @Override
    public void close() throws IOException {
        if (this.postingsEnum instanceof Closeable) {
            ((Closeable)((Object)this.postingsEnum)).close();
        }
    }
}

