/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortedSetSelector;

public class SortedSetSortField
extends SortField {
    private final SortedSetSelector.Type selector;

    public SortedSetSortField(String field, boolean reverse) {
        this(field, reverse, SortedSetSelector.Type.MIN);
    }

    public SortedSetSortField(String field, boolean reverse, SortedSetSelector.Type selector) {
        super(field, SortField.Type.CUSTOM, reverse);
        if (selector == null) {
            throw new NullPointerException();
        }
        this.selector = selector;
    }

    public SortedSetSelector.Type getSelector() {
        return this.selector;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.selector.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortedSetSortField other = (SortedSetSortField)obj;
        return this.selector == other.selector;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<sortedset: \"").append(this.getField()).append("\">");
        if (this.getReverse()) {
            buffer.append('!');
        }
        if (this.missingValue != null) {
            buffer.append(" missingValue=");
            buffer.append(this.missingValue);
        }
        buffer.append(" selector=");
        buffer.append((Object)this.selector);
        return buffer.toString();
    }

    @Override
    public void setMissingValue(Object missingValue) {
        if (missingValue != STRING_FIRST && missingValue != STRING_LAST) {
            throw new IllegalArgumentException("For SORTED_SET type, missing value must be either STRING_FIRST or STRING_LAST");
        }
        this.missingValue = missingValue;
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, int sortPos) throws IOException {
        return new FieldComparator.TermOrdValComparator(numHits, this.getField(), this.missingValue == STRING_LAST){

            @Override
            protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
                SortedSetDocValues sortedSet = DocValues.getSortedSet(context.reader(), field);
                return SortedSetSelector.wrap(sortedSet, SortedSetSortField.this.selector);
            }
        };
    }
}

