/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;

public class MatchNoDocsQuery
extends Query {
    private final String reason;

    public MatchNoDocsQuery() {
        this("");
    }

    public MatchNoDocsQuery(String reason) {
        this.reason = reason;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return Explanation.noMatch(MatchNoDocsQuery.this.reason, new Explanation[0]);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return null;
            }

            @Override
            public final float getValueForNormalization() throws IOException {
                return 0.0f;
            }

            @Override
            public void normalize(float norm, float boost) {
            }

            protected final float queryNorm() {
                return 0.0f;
            }

            protected final float boost() {
                return 0.0f;
            }

            protected final float score() {
                return 0.0f;
            }
        };
    }

    @Override
    public String toString(String field) {
        return "MatchNoDocsQuery(\"" + this.reason + "\")";
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    @Override
    public int hashCode() {
        return this.classHash();
    }
}

