/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.FunctionValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.valuesource.MultiFunction;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;

public abstract class MultiFloatFunction
extends ValueSource {
    protected final ValueSource[] sources;

    public MultiFloatFunction(ValueSource[] sources) {
        this.sources = sources;
    }

    protected abstract String name();

    protected abstract float func(int var1, FunctionValues[] var2);

    protected boolean exists(int doc, FunctionValues[] valsArr) {
        return MultiFunction.allExists(doc, valsArr);
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        boolean firstTime = true;
        for (ValueSource source : this.sources) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(',');
            }
            sb.append(source);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues[] valsArr = new FunctionValues[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            valsArr[i] = this.sources[i].getValues(context, readerContext);
        }
        return new FloatDocValues(this){

            @Override
            public float floatVal(int doc) {
                return MultiFloatFunction.this.func(doc, valsArr);
            }

            @Override
            public boolean exists(int doc) {
                return MultiFloatFunction.this.exists(doc, valsArr);
            }

            @Override
            public String toString(int doc) {
                return MultiFunction.toString(MultiFloatFunction.this.name(), valsArr, doc);
            }
        };
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        for (ValueSource source : this.sources) {
            source.createWeight(context, searcher);
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.sources) + this.name().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        MultiFloatFunction other = (MultiFloatFunction)o;
        return this.name().equals(other.name()) && Arrays.equals(this.sources, other.sources);
    }
}

