/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.ArgumentAcceptingOptionSpec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.NoArgumentOptionSpec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.OptionParser;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.OptionSpec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.OptionalArgumentOptionSpec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.RequiredArgumentOptionSpec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.UnconfiguredOptionException;

public class OptionSpecBuilder
extends NoArgumentOptionSpec {
    private final OptionParser parser;

    OptionSpecBuilder(OptionParser parser, List<String> options, String description) {
        super(options, description);
        this.parser = parser;
        this.attachToParser();
    }

    private void attachToParser() {
        this.parser.recognize(this);
    }

    public ArgumentAcceptingOptionSpec<String> withRequiredArg() {
        RequiredArgumentOptionSpec<String> newSpec = new RequiredArgumentOptionSpec<String>(this.options(), this.description());
        this.parser.recognize(newSpec);
        return newSpec;
    }

    public ArgumentAcceptingOptionSpec<String> withOptionalArg() {
        OptionalArgumentOptionSpec<String> newSpec = new OptionalArgumentOptionSpec<String>(this.options(), this.description());
        this.parser.recognize(newSpec);
        return newSpec;
    }

    public OptionSpecBuilder requiredIf(String dependent, String ... otherDependents) {
        List<String> dependents = this.validatedDependents(dependent, otherDependents);
        for (String each : dependents) {
            this.parser.requiredIf(this.options(), each);
        }
        return this;
    }

    public OptionSpecBuilder requiredIf(OptionSpec<?> dependent, OptionSpec<?> ... otherDependents) {
        this.parser.requiredIf(this.options(), dependent);
        for (OptionSpec<?> each : otherDependents) {
            this.parser.requiredIf(this.options(), each);
        }
        return this;
    }

    public OptionSpecBuilder requiredUnless(String dependent, String ... otherDependents) {
        List<String> dependents = this.validatedDependents(dependent, otherDependents);
        for (String each : dependents) {
            this.parser.requiredUnless(this.options(), each);
        }
        return this;
    }

    public OptionSpecBuilder requiredUnless(OptionSpec<?> dependent, OptionSpec<?> ... otherDependents) {
        this.parser.requiredUnless(this.options(), dependent);
        for (OptionSpec<?> each : otherDependents) {
            this.parser.requiredUnless(this.options(), each);
        }
        return this;
    }

    public OptionSpecBuilder availableIf(String dependent, String ... otherDependents) {
        List<String> dependents = this.validatedDependents(dependent, otherDependents);
        for (String each : dependents) {
            this.parser.availableIf(this.options(), each);
        }
        return this;
    }

    public OptionSpecBuilder availableIf(OptionSpec<?> dependent, OptionSpec<?> ... otherDependents) {
        this.parser.availableIf(this.options(), dependent);
        for (OptionSpec<?> each : otherDependents) {
            this.parser.availableIf(this.options(), each);
        }
        return this;
    }

    public OptionSpecBuilder availableUnless(String dependent, String ... otherDependents) {
        List<String> dependents = this.validatedDependents(dependent, otherDependents);
        for (String each : dependents) {
            this.parser.availableUnless(this.options(), each);
        }
        return this;
    }

    public OptionSpecBuilder availableUnless(OptionSpec<?> dependent, OptionSpec<?> ... otherDependents) {
        this.parser.availableUnless(this.options(), dependent);
        for (OptionSpec<?> each : otherDependents) {
            this.parser.availableUnless(this.options(), each);
        }
        return this;
    }

    private List<String> validatedDependents(String dependent, String ... otherDependents) {
        ArrayList<String> dependents = new ArrayList<String>();
        dependents.add(dependent);
        Collections.addAll(dependents, otherDependents);
        for (String each : dependents) {
            if (this.parser.isRecognized(each)) continue;
            throw new UnconfiguredOptionException(each);
        }
        return dependents;
    }
}

