/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.BitMixer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.IntObjectHashMap;

public class IntObjectScatterMap<VType>
extends IntObjectHashMap<VType> {
    public IntObjectScatterMap() {
        this(4);
    }

    public IntObjectScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntObjectScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static <VType> IntObjectScatterMap<VType> from(int[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntObjectScatterMap<VType> map = new IntObjectScatterMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

